/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.lists;

import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.Map;
import org.embeddedt.embeddium.impl.render.chunk.ChunkUpdateType;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;

public record ChunkRebuildLists(Map<ChunkUpdateType, ArrayDeque<RenderSection>> byUpdateType, boolean hasAdditionalUpdates, Map<ChunkUpdateType, Integer> queueOverflowCounts) {
    public static final ChunkRebuildLists EMPTY;

    public int getUpdateCount(ChunkUpdateType type) {
        return this.byUpdateType.get((Object)type).size() + this.queueOverflowCounts.getOrDefault((Object)type, 0);
    }

    public boolean isEmpty() {
        if (this.hasAdditionalUpdates) {
            return false;
        }
        for (ArrayDeque<RenderSection> queue : this.byUpdateType.values()) {
            if (queue.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static {
        EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>> rebuildLists = new EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>>(ChunkUpdateType.class);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            rebuildLists.put(type, new ArrayDeque());
        }
        EMPTY = new ChunkRebuildLists(rebuildLists, false, new EnumMap<ChunkUpdateType, Integer>(ChunkUpdateType.class));
    }
}

