/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.texture;

import org.embeddedt.embeddium.api.util.ColorARGB;
import org.embeddedt.embeddium.impl.util.color.ColorSRGB;

public class MipmapHelper {
    public static int weightedAverageColor(int one, int two) {
        int alphaTwo;
        int alphaOne = ColorARGB.unpackAlpha(one);
        if (alphaOne == (alphaTwo = ColorARGB.unpackAlpha(two))) {
            return MipmapHelper.averageRgb(one, two, alphaOne);
        }
        if (alphaOne == 0) {
            return two & 0xFFFFFF | alphaTwo >> 2 << 24;
        }
        if (alphaTwo == 0) {
            return one & 0xFFFFFF | alphaOne >> 2 << 24;
        }
        float scale = 1.0f / (float)(alphaOne + alphaTwo);
        float relativeWeightOne = (float)alphaOne * scale;
        float relativeWeightTwo = (float)alphaTwo * scale;
        float oneR = ColorSRGB.srgbToLinear(ColorARGB.unpackRed(one)) * relativeWeightOne;
        float oneG = ColorSRGB.srgbToLinear(ColorARGB.unpackGreen(one)) * relativeWeightOne;
        float oneB = ColorSRGB.srgbToLinear(ColorARGB.unpackBlue(one)) * relativeWeightOne;
        float twoR = ColorSRGB.srgbToLinear(ColorARGB.unpackRed(two)) * relativeWeightTwo;
        float twoG = ColorSRGB.srgbToLinear(ColorARGB.unpackGreen(two)) * relativeWeightTwo;
        float twoB = ColorSRGB.srgbToLinear(ColorARGB.unpackBlue(two)) * relativeWeightTwo;
        float linearR = oneR + twoR;
        float linearG = oneG + twoG;
        float linearB = oneB + twoB;
        int averageAlpha = alphaOne + alphaTwo >> 1;
        return ColorSRGB.linearToSrgb(linearR, linearG, linearB, averageAlpha);
    }

    private static int averageRgb(int a, int b, int alpha) {
        float ar = ColorSRGB.srgbToLinear(ColorARGB.unpackRed(a));
        float ag = ColorSRGB.srgbToLinear(ColorARGB.unpackGreen(a));
        float ab = ColorSRGB.srgbToLinear(ColorARGB.unpackBlue(a));
        float br = ColorSRGB.srgbToLinear(ColorARGB.unpackRed(b));
        float bg = ColorSRGB.srgbToLinear(ColorARGB.unpackGreen(b));
        float bb = ColorSRGB.srgbToLinear(ColorARGB.unpackBlue(b));
        return ColorSRGB.linearToSrgb((ar + br) * 0.5f, (ag + bg) * 0.5f, (ab + bb) * 0.5f, alpha);
    }
}

