/*
 * Decompiled with CFR 0.152.
 */
package org.taumc.celeritas.api.options.control;

import org.embeddedt.embeddium.impl.gui.framework.DrawContext;
import org.embeddedt.embeddium.impl.gui.framework.TextComponent;
import org.embeddedt.embeddium.impl.gui.framework.TextFormattingStyle;
import org.embeddedt.embeddium.impl.gui.widgets.AbstractWidget;
import org.embeddedt.embeddium.impl.gui.widgets.FlatButtonWidget;
import org.embeddedt.embeddium.impl.util.Dim2i;
import org.jetbrains.annotations.NotNull;
import org.taumc.celeritas.api.options.control.OptionControlElement;
import org.taumc.celeritas.api.options.structure.Option;

public class ControlElement<T>
extends AbstractWidget
implements OptionControlElement<T> {
    protected final Option<T> option;
    protected final Dim2i dim;
    @NotNull
    private FlatButtonWidget.Style style = FlatButtonWidget.Style.defaults();

    public ControlElement(Option<T> option, Dim2i dim) {
        this.option = option;
        this.dim = dim;
    }

    @Override
    public void render(DrawContext drawContext, int mouseX, int mouseY, float delta) {
        Object name = drawContext.extractString(this.option.getName());
        boolean hovered = this.isMouseOver(mouseX, mouseY);
        if (hovered && drawContext.getStringWidth((String)name) > this.dim.width() - this.option.getControl().getMaxWidth()) {
            name = ((String)name).substring(0, Math.min(((String)name).length(), 10)) + "...";
        }
        TextComponent label = this.option.isAvailable() ? (this.option.hasChanged() ? TextComponent.literal((String)name + " *").withStyle(TextFormattingStyle.ITALIC, new TextFormattingStyle[0]) : TextComponent.literal((String)name).withStyle(TextFormattingStyle.WHITE, new TextFormattingStyle[0])) : TextComponent.literal((String)name).withStyle(TextFormattingStyle.GRAY, TextFormattingStyle.STRIKETHROUGH);
        drawContext.fill(this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), hovered ? this.style.bgHovered : this.style.bgDefault);
        drawContext.drawString(label, this.dim.x() + 6, this.dim.getCenterY() - 4, this.style.textDefault);
    }

    @Override
    public Option<T> getOption() {
        return this.option;
    }

    public Dim2i getDimensions() {
        return this.dim;
    }

    @Override
    public boolean isMouseOver(double x, double y) {
        return this.dim.containsCursor(x, y);
    }
}

