/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.asm;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class Lwjgl3ifyTransformer
implements IClassTransformer {
    private static final String PFX = "org/embeddedt/embeddium/impl/lwjgl2";
    private static final String REPLACE = "org/lwjgl/system";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.startsWith("org.embeddedt.embeddium") && !transformedName.startsWith("com.ventooth.beddium")) {
            return basicClass;
        }
        if (basicClass == null) {
            return null;
        }
        ClassWriter w = new ClassWriter(0);
        final boolean isFence = "org.embeddedt.embeddium.impl.gl.sync.GlFence".equals(transformedName);
        final AtomicBoolean didRemap = new AtomicBoolean(false);
        ClassReader reader = new ClassReader(basicClass);
        RemappingClassAdapter adapter = new RemappingClassAdapter((ClassVisitor)w, new Remapper(this){

            public String map(String typeName) {
                if (typeName.startsWith(Lwjgl3ifyTransformer.PFX)) {
                    didRemap.set(true);
                    return 1.jvmdowngrader$concat$map$1(typeName.substring(Lwjgl3ifyTransformer.PFX.length()));
                }
                if (isFence && "org/lwjgl/opengl/GLSync".equals(typeName)) {
                    return "org/lwjglx/opengl/GLSync";
                }
                return super.map(typeName);
            }

            public String mapMethodName(String owner, String name, String descriptor) {
                String string;
                switch (name) {
                    case "glUniform1": {
                        string = "glUniform1fv";
                        break;
                    }
                    case "glUniformMatrix3": {
                        string = "glUniformMatrix3fv";
                        break;
                    }
                    case "glUniformMatrix4": {
                        string = "glUniformMatrix4fv";
                        break;
                    }
                    default: {
                        string = name;
                    }
                }
                return string;
            }

            private static /* synthetic */ String jvmdowngrader$concat$map$1(String string) {
                return Lwjgl3ifyTransformer.REPLACE + string;
            }
        });
        reader.accept((ClassVisitor)adapter, 8);
        if (didRemap.get()) {
            w.visitAnnotation("Lme/eigenraven/lwjgl3ify/api/Lwjgl3Aware;", false);
            return w.toByteArray();
        }
        return basicClass;
    }
}

