/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.compile;

import com.ventooth.beddium.Share;
import com.ventooth.beddium.config.ModuleConfig;
import com.ventooth.beddium.modules.TerrainRendering.ArchaicRenderPassConfigurationBuilder;
import com.ventooth.beddium.modules.TerrainRendering.ext.TextureAtlasSpriteExt;
import com.ventooth.beddium.modules.TerrainRendering.ext.TextureMapExt;
import com.ventooth.beddium.modules.TerrainRendering.vertex.CompatibleChunkVertex;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildBuffers;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.data.MinecraftBuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevel;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.util.QuadUtil;
import org.jetbrains.annotations.Nullable;

public class ArchaicChunkBuildContext
extends ChunkBuildContext {
    public static final int NUM_PASSES = 2;
    private final CompatibleChunkVertex.Vertex[] vertices = CompatibleChunkVertex.get().uninitializedQuad();
    private final int rawBufStride = CompatibleChunkVertex.get().rawBufStride();
    private final TextureMapExt textureAtlas = TextureMapExt.of(Minecraft.func_71410_x().func_147117_R());

    public ArchaicChunkBuildContext(WorldClient world, RenderPassConfiguration renderPassConfiguration) {
        super(renderPassConfiguration);
    }

    public void copyRawBuffer(int[] rawBuffer, int vertexCount, ChunkBuildBuffers buffers, Material material) {
        if (vertexCount == 0) {
            return;
        }
        BuiltRenderSectionData ctxBundle = buffers.getSectionContextBundle();
        MinecraftBuiltRenderSectionData sectionData = (MinecraftBuiltRenderSectionData)ctxBundle;
        Collection animatedSprites = sectionData.animatedSprites;
        if ((vertexCount & 3) != 0) {
            IllegalStateException e = new IllegalStateException(ArchaicChunkBuildContext.jvmdowngrader$concat$copyRawBuffer$1(vertexCount));
            if (ModuleConfig.Debug) {
                Share.log.fatal("Caught would-be runtime crash: ", (Throwable)e);
            } else {
                throw e;
            }
        }
        int ptr = 0;
        int numQuads = vertexCount / 4;
        for (int quadIdx = 0; quadIdx < numQuads; ++quadIdx) {
            float uSum = 0.0f;
            float vSum = 0.0f;
            for (int vertIdx = 0; vertIdx < 4; ++vertIdx) {
                CompatibleChunkVertex.Vertex baseVertex = this.vertices[vertIdx];
                baseVertex.copyRawBuffer(rawBuffer, ptr);
                ptr += this.rawBufStride;
                uSum += baseVertex.u;
                vSum += baseVertex.v;
            }
            TextureAtlasSprite sprite = this.textureAtlas.celeritas$findFromUV(uSum * 0.25f, vSum * 0.25f);
            if (sprite != null && sprite.func_130098_m()) {
                animatedSprites.add(sprite);
            }
            int trueNormal = QuadUtil.calculateNormal(this.vertices);
            for (int vertIdx = 0; vertIdx < 4; ++vertIdx) {
                this.vertices[vertIdx].trueNormal = trueNormal;
            }
            ModelQuadFacing facing = QuadUtil.findNormalFace(trueNormal);
            Material correctMaterial = ArchaicChunkBuildContext.selectMaterial(material, sprite);
            buffers.get(correctMaterial).getVertexBuffer(facing).push(this.vertices, correctMaterial);
        }
    }

    private static Material selectMaterial(Material baseMaterial, @Nullable TextureAtlasSprite sprite) {
        if (sprite == null || sprite.getClass() != TextureAtlasSprite.class || sprite.func_130098_m()) {
            return baseMaterial;
        }
        SpriteTransparencyLevel transparencyLevel = TextureAtlasSpriteExt.of(sprite).celeritas$transparencyLevel();
        if (baseMaterial == ArchaicRenderPassConfigurationBuilder.CUTOUT_MIPPED_MATERIAL) {
            if (transparencyLevel == SpriteTransparencyLevel.OPAQUE) {
                return ArchaicRenderPassConfigurationBuilder.SOLID_MATERIAL;
            }
        } else if (baseMaterial == ArchaicRenderPassConfigurationBuilder.TRANSLUCENT_MATERIAL && transparencyLevel != SpriteTransparencyLevel.TRANSLUCENT) {
            return ArchaicRenderPassConfigurationBuilder.CUTOUT_MIPPED_MATERIAL;
        }
        return baseMaterial;
    }

    private static /* synthetic */ String jvmdowngrader$concat$copyRawBuffer$1(int n) {
        return "Bad vertex count: [" + n + "] is someone triangulating the quads early?";
    }
}

