/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.common.util;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.lwjgl2.MemoryUtil;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;

@NestMembers(value={BufferReference.class})
public class NativeBuffer {
    private static final Logger LOGGER = LogManager.getLogger(NativeBuffer.class);
    private static final ReferenceQueue<NativeBuffer> RECLAIM_QUEUE = new ReferenceQueue();
    private static final Reference2ReferenceMap<Reference<NativeBuffer>, BufferReference> ACTIVE_BUFFERS = Reference2ReferenceMaps.synchronize((Reference2ReferenceMap)new Reference2ReferenceOpenHashMap());
    private static long ALLOCATED = 0L;
    private final BufferReference ref;
    public static boolean ENABLE_MEMORY_TRACING = false;
    private static final int MAX_ALLOCATION_ATTEMPTS = 3;

    public NativeBuffer(int capacity) {
        this.ref = NativeBuffer.allocate(capacity);
        ACTIVE_BUFFERS.put(new PhantomReference<NativeBuffer>(this, RECLAIM_QUEUE), (Object)this.ref);
    }

    public static NativeBuffer copy(ByteBuffer src) {
        NativeBuffer dst = new NativeBuffer(src.remaining());
        MemoryUtil.memCopy(src, dst.getDirectBuffer());
        return dst;
    }

    public ByteBuffer getDirectBuffer() {
        this.ref.jvmdowngrader$nest$org_embeddedt_embeddium_impl_common_util_NativeBuffer$BufferReference$checkFreed();
        return MemoryUtil.memByteBuffer(this.ref.address, this.ref.length);
    }

    public void free() {
        NativeBuffer.deallocate(this.ref);
    }

    public int getLength() {
        return this.ref.length;
    }

    public static void reclaim(boolean forceGc) {
        Reference<NativeBuffer> ref;
        if (forceGc) {
            System.gc();
        }
        while ((ref = RECLAIM_QUEUE.poll()) != null) {
            BufferReference buf = (BufferReference)ACTIVE_BUFFERS.remove(ref);
            if (buf.freed) continue;
            NativeBuffer.deallocate(buf);
            if (buf.allocationSite != null) {
                LOGGER.warn("Reclaimed {} bytes at address {} that were leaked from allocation site:\n{}", new Object[]{buf.length, buf.address, Arrays.stream(buf.allocationSite).map(StackTraceElement::toString).collect(Collectors.joining("\n"))});
                continue;
            }
            LOGGER.warn("Reclaimed {} bytes at address {} that were leaked from an unknown location (logging is disabled)", new Object[]{buf.length, buf.address});
        }
    }

    public static long getTotalAllocated() {
        return ALLOCATED;
    }

    private static StackTraceElement[] getStackTrace() {
        return ENABLE_MEMORY_TRACING ? Thread.currentThread().getStackTrace() : null;
    }

    private static BufferReference allocate(int bytes) {
        long address = 0L;
        int attempts = 0;
        while (++attempts <= 3 && (address = MemoryUtil.nmemAlloc(bytes)) == 0L) {
            LOGGER.error("EMERGENCY: Tried to allocate {} bytes but the allocator reports failure", new Object[]{bytes});
            LOGGER.error("EMERGENCY: ... Attempting to force a garbage collection cycle (attempt {}/{})", new Object[]{attempts, 3});
            NativeBuffer.reclaim(true);
        }
        if (address == 0L) {
            throw new OutOfMemoryError(J_L_String.formatted((String)"Couldn't allocate %s bytes after %s attempts", (Object[])new Object[]{bytes, attempts}));
        }
        StackTraceElement[] stackTrace = NativeBuffer.getStackTrace();
        BufferReference ref = new BufferReference(address, bytes, stackTrace);
        ALLOCATED += (long)ref.length;
        return ref;
    }

    private static void deallocate(BufferReference ref) {
        ref.jvmdowngrader$nest$org_embeddedt_embeddium_impl_common_util_NativeBuffer$BufferReference$checkFreed();
        ref.freed = true;
        MemoryUtil.nmemFree(ref.address);
        ALLOCATED -= (long)ref.length;
    }

    @NestHost(value=NativeBuffer.class)
    private static class BufferReference {
        public final long address;
        public final int length;
        public final StackTraceElement[] allocationSite;
        public boolean freed;

        BufferReference(long address, int length, StackTraceElement[] allocationSite) {
            this.address = address;
            this.length = length;
            this.allocationSite = allocationSite;
        }

        private void checkFreed() {
            if (this.freed) {
                throw new IllegalStateException("Buffer has been deleted");
            }
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_common_util_NativeBuffer$BufferReference$checkFreed() {
            this.checkFreed();
        }
    }
}

