/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.functions;

import org.embeddedt.embeddium.impl.gl.buffer.GlBufferStorageFlags;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferTarget;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gl.util.EnumBitField;
import org.lwjgl.opengl.ARBBufferStorage;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL44;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j17.PermittedSubClasses;

@PermittedSubClasses(value={1.class, 2.class, 3.class})
@NestMembers(value={3.class, 2.class, 1.class})
public enum BufferStorageFunctions {
    NONE{

        @Override
        public void createBufferStorage(GlBufferTarget target, long length, EnumBitField<GlBufferStorageFlags> flags) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CORE{

        @Override
        public void createBufferStorage(GlBufferTarget target, long length, EnumBitField<GlBufferStorageFlags> flags) {
            GL44.glBufferStorage((int)target.getTargetParameter(), (long)length, (int)flags.getBitField());
        }
    }
    ,
    ARB{

        @Override
        public void createBufferStorage(GlBufferTarget target, long length, EnumBitField<GlBufferStorageFlags> flags) {
            ARBBufferStorage.glBufferStorage((int)target.getTargetParameter(), (long)length, (int)flags.getBitField());
        }
    };


    public static BufferStorageFunctions pickBest(RenderDevice device) {
        ContextCapabilities capabilities = device.getCapabilities();
        if (capabilities.OpenGL44) {
            return CORE;
        }
        if (capabilities.GL_ARB_buffer_storage) {
            return ARB;
        }
        return NONE;
    }

    public abstract void createBufferStorage(GlBufferTarget var1, long var2, EnumBitField<GlBufferStorageFlags> var4);
}

