/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.lwjgl2;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.embeddedt.embeddium.impl.lwjgl2.MemoryAdapter;
import org.embeddedt.embeddium.impl.lwjgl2.UnsafeUtil;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;

final class LegacyMemoryAdapter
implements MemoryAdapter {
    private static final int BB_INIT_MARK = -1;
    private static final long NULL_ADDR = 0L;
    private static final Class<? extends ByteBuffer> BB = ByteBuffer.allocateDirect(0).getClass();
    private static final Unsafe unsafe = UnsafeUtil.unsafe;
    private static final long BB_mark = UnsafeUtil.findFieldOffset(BB, Integer.TYPE, "mark");
    private static final long BB_position = UnsafeUtil.findFieldOffset(BB, Integer.TYPE, "position");
    private static final long BB_limit = UnsafeUtil.findFieldOffset(BB, Integer.TYPE, "limit");
    private static final long BB_capacity = UnsafeUtil.findFieldOffset(BB, Integer.TYPE, "capacity");
    private static final long BB_address = UnsafeUtil.findFieldOffset(BB, Long.TYPE, "address");

    @Override
    public long nmemAlloc(long size) {
        return unsafe.allocateMemory(size);
    }

    @Override
    public long nmemCalloc(long count, long size) {
        long addr = unsafe.allocateMemory(size *= count);
        unsafe.setMemory(addr, size, (byte)0);
        return addr;
    }

    @Override
    public long nmemAlignedAlloc(long align, long size) {
        long prefixLength;
        long capacity;
        long addr;
        int required = 8;
        long shiftBy = (align = Math.max(align, 8L)) - (addr = unsafe.allocateMemory(capacity = size + (prefixLength = Math.max(align, (long)required) + (long)required))) % align;
        if (shiftBy < (long)required) {
            shiftBy += align;
        }
        long finalAddr = addr + shiftBy;
        unsafe.putLong(finalAddr - 8L, addr);
        return finalAddr;
    }

    @Override
    public long nmemRealloc(long addr, long size) {
        return unsafe.reallocateMemory(addr, size);
    }

    @Override
    public void nmemFree(long addr) {
        unsafe.freeMemory(addr);
    }

    @Override
    public void nmemAlignedFree(long addr) {
        long realAddr = unsafe.getLong(addr - 8L);
        unsafe.freeMemory(realAddr);
    }

    @Override
    public ByteBuffer memAlloc(int size) {
        long addr = this.nmemAlloc(size);
        return this.memByteBuffer(addr, size);
    }

    @Override
    public ByteBuffer memRealloc(@Nullable ByteBuffer buf, int size) {
        if (buf != null) {
            long addr = this.nmemRealloc(unsafe.getLong(buf, BB_address), size);
            ByteBuffer newBuf = this.memByteBuffer(addr, size);
            ByteBuffer cfr_ignored_0 = (ByteBuffer)J_N_Buffer.position((Buffer)newBuf, (int)Math.min(buf.position(), size));
            return newBuf;
        }
        return this.memAlloc(size);
    }

    @Override
    public void memFree(@Nullable Buffer buf) {
        if (buf == null) {
            return;
        }
        long addr = unsafe.getLong(buf, BB_address);
        if (addr != 0L) {
            this.nmemFree(addr);
            unsafe.putLong(buf, BB_address, 0L);
        }
    }

    @Override
    public ByteBuffer memByteBuffer(long addr, int size) {
        ByteBuffer buf = LegacyMemoryAdapter.createBuffer();
        unsafe.putLong(buf, BB_address, addr);
        unsafe.putInt(buf, BB_mark, -1);
        unsafe.putInt(buf, BB_position, 0);
        unsafe.putInt(buf, BB_limit, size);
        unsafe.putInt(buf, BB_capacity, size);
        return buf;
    }

    @Override
    public long memAddress(@Nullable Buffer buf) {
        if (buf == null) {
            return 0L;
        }
        long addr = unsafe.getLong(buf, BB_address);
        return addr + (long)buf.position();
    }

    @Override
    public long memAddress(@Nullable Buffer buf, int offset) {
        if (buf == null) {
            return offset;
        }
        long addr = unsafe.getLong(buf, BB_address);
        return addr + (long)offset;
    }

    @Override
    public void memSet(long addr, byte value, long size) {
        unsafe.setMemory(addr, size, value);
    }

    @Override
    public void memCopy(long from, long to, long size) {
        unsafe.copyMemory(from, to, size);
    }

    @Override
    public void memPutFloat(long addr, float value) {
        unsafe.putFloat(addr, value);
    }

    @Override
    public void memPutByte(long addr, byte value) {
        unsafe.putByte(addr, value);
    }

    @Override
    public void memPutShort(long addr, short value) {
        unsafe.putShort(addr, value);
    }

    @Override
    public void memPutInt(long addr, int value) {
        unsafe.putInt(addr, value);
    }

    @Override
    public void memPutAddress(long addr, long value) {
        unsafe.putAddress(addr, value);
    }

    @Override
    public float memGetFloat(long addr) {
        return unsafe.getFloat(addr);
    }

    @Override
    public byte memGetByte(long addr) {
        return unsafe.getByte(addr);
    }

    @Override
    public short memGetShort(long addr) {
        return unsafe.getShort(addr);
    }

    @Override
    public int memGetInt(long addr) {
        return unsafe.getInt(addr);
    }

    @Override
    public long memGetAddress(long addr) {
        return unsafe.getAddress(addr);
    }

    private static ByteBuffer createBuffer() {
        ByteBuffer buf = (ByteBuffer)unsafe.allocateInstance(BB);
        return buf.order(ByteOrder.nativeOrder());
    }

    LegacyMemoryAdapter() {
    }
}

