/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.lwjgl2;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.embeddedt.embeddium.impl.lwjgl2.LegacyMemoryAdapter;
import org.embeddedt.embeddium.impl.lwjgl2.MemoryAdapter;

public final class MemoryUtil {
    private static final MemoryAdapter MEMORY_ADAPTER = MemoryUtil.selectMemoryAdapter();
    public static final long NULL = 0L;

    public static long nmemAlloc(long size) {
        return MEMORY_ADAPTER.nmemAlloc(size);
    }

    public static long nmemCalloc(long count, long size) {
        return MEMORY_ADAPTER.nmemCalloc(count, size);
    }

    public static long nmemAlignedAlloc(long align, long size) {
        return MEMORY_ADAPTER.nmemAlignedAlloc(align, size);
    }

    public static long nmemRealloc(long addr, long size) {
        return MEMORY_ADAPTER.nmemRealloc(addr, size);
    }

    public static void nmemFree(long addr) {
        MEMORY_ADAPTER.nmemFree(addr);
    }

    public static void nmemAlignedFree(long addr) {
        MEMORY_ADAPTER.nmemAlignedFree(addr);
    }

    public static ByteBuffer memAlloc(int size) {
        return MEMORY_ADAPTER.memAlloc(size);
    }

    public static ByteBuffer memRealloc(ByteBuffer buf, int size) {
        return MEMORY_ADAPTER.memRealloc(buf, size);
    }

    public static void memFree(Buffer buf) {
        MEMORY_ADAPTER.memFree(buf);
    }

    public static ByteBuffer memByteBuffer(long addr, int capacity) {
        return MEMORY_ADAPTER.memByteBuffer(addr, capacity);
    }

    public static ByteBuffer memSlice(ByteBuffer buf, int offset, int length) {
        long addr = MEMORY_ADAPTER.memAddress(buf);
        return MemoryUtil.memByteBuffer(addr + (long)offset, length);
    }

    public static long memAddress(ByteBuffer buf) {
        return MEMORY_ADAPTER.memAddress(buf);
    }

    public static long memAddress(FloatBuffer buf) {
        return MEMORY_ADAPTER.memAddress(buf);
    }

    public static long memAddress(ByteBuffer buf, int offset) {
        return MEMORY_ADAPTER.memAddress(buf, offset);
    }

    public static void memSet(long addr, int value, long size) {
        MEMORY_ADAPTER.memSet(addr, (byte)value, size);
    }

    public static void memCopy(long from, long to, long size) {
        MEMORY_ADAPTER.memCopy(from, to, size);
    }

    public static void memCopy(ByteBuffer from, ByteBuffer to) {
        long fromAddr = MemoryUtil.memAddress(from, from.position());
        long toAddr = MemoryUtil.memAddress(to, to.position());
        MemoryUtil.memCopy(fromAddr, toAddr, Math.min(from.remaining(), to.remaining()));
    }

    public static void memPutFloat(long addr, float value) {
        MEMORY_ADAPTER.memPutFloat(addr, value);
    }

    public static void memPutByte(long addr, byte value) {
        MEMORY_ADAPTER.memPutByte(addr, value);
    }

    public static void memPutShort(long addr, short value) {
        MEMORY_ADAPTER.memPutShort(addr, value);
    }

    public static void memPutInt(long addr, int value) {
        MEMORY_ADAPTER.memPutInt(addr, value);
    }

    public static void memPutAddress(long addr, long value) {
        MEMORY_ADAPTER.memPutAddress(addr, value);
    }

    public static float memGetFloat(long addr) {
        return MEMORY_ADAPTER.memGetFloat(addr);
    }

    public static byte memGetByte(long addr) {
        return MEMORY_ADAPTER.memGetByte(addr);
    }

    public static short memGetShort(long addr) {
        return MEMORY_ADAPTER.memGetShort(addr);
    }

    public static int memGetInt(long addr) {
        return MEMORY_ADAPTER.memGetInt(addr);
    }

    public static long memGetAddress(long addr) {
        return MEMORY_ADAPTER.memGetAddress(addr);
    }

    private static MemoryAdapter selectMemoryAdapter() {
        return new LegacyMemoryAdapter();
    }

    private MemoryUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

