/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.light.smooth;

import org.embeddedt.embeddium.impl.model.light.data.LightDataAccess;
import org.embeddedt.embeddium.impl.model.light.smooth.AoNeighborInfo;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;

class AoFaceData {
    public final int[] lm = new int[4];
    public final float[] ao = new float[4];
    public final float[] bl = new float[4];
    public final float[] sl = new float[4];
    private int flags;

    AoFaceData() {
    }

    public void initLightData(LightDataAccess cache, int x, int y, int z, ModelQuadFacing direction, boolean offset) {
        boolean c3em;
        float c3ao;
        int c3lm;
        boolean c2em;
        float c2ao;
        int c2lm;
        boolean c1em;
        float c1ao;
        int c1lm;
        boolean c0em;
        float c0ao;
        int c0lm;
        boolean caem;
        int calm;
        int adjZ;
        int adjY;
        int adjX;
        if (offset) {
            adjX = x + direction.getStepX();
            adjY = y + direction.getStepY();
            adjZ = z + direction.getStepZ();
        } else {
            adjX = x;
            adjY = y;
            adjZ = z;
        }
        int adjWord = cache.get(adjX, adjY, adjZ);
        if (offset && LightDataAccess.unpackFO(adjWord)) {
            int originWord = cache.get(x, y, z);
            calm = LightDataAccess.getLightmap(originWord);
            caem = LightDataAccess.unpackEM(originWord);
        } else {
            calm = LightDataAccess.getLightmap(adjWord);
            caem = LightDataAccess.unpackEM(adjWord);
        }
        float caao = LightDataAccess.unpackAO(adjWord);
        ModelQuadFacing[] faces = AoNeighborInfo.get((ModelQuadFacing)direction).faces;
        int e0 = cache.get(adjX, adjY, adjZ, faces[0]);
        int e0lm = LightDataAccess.getLightmap(e0);
        float e0ao = LightDataAccess.unpackAO(e0);
        boolean e0op = LightDataAccess.unpackOP(e0);
        boolean e0em = LightDataAccess.unpackEM(e0);
        int e1 = cache.get(adjX, adjY, adjZ, faces[1]);
        int e1lm = LightDataAccess.getLightmap(e1);
        float e1ao = LightDataAccess.unpackAO(e1);
        boolean e1op = LightDataAccess.unpackOP(e1);
        boolean e1em = LightDataAccess.unpackEM(e1);
        int e2 = cache.get(adjX, adjY, adjZ, faces[2]);
        int e2lm = LightDataAccess.getLightmap(e2);
        float e2ao = LightDataAccess.unpackAO(e2);
        boolean e2op = LightDataAccess.unpackOP(e2);
        boolean e2em = LightDataAccess.unpackEM(e2);
        int e3 = cache.get(adjX, adjY, adjZ, faces[3]);
        int e3lm = LightDataAccess.getLightmap(e3);
        float e3ao = LightDataAccess.unpackAO(e3);
        boolean e3op = LightDataAccess.unpackOP(e3);
        boolean e3em = LightDataAccess.unpackEM(e3);
        if (e2op && e0op) {
            c0lm = e0lm;
            c0ao = e0ao;
            c0em = e0em;
        } else {
            int d0 = cache.get(adjX, adjY, adjZ, faces[0], faces[2]);
            c0lm = LightDataAccess.getLightmap(d0);
            c0ao = LightDataAccess.unpackAO(d0);
            c0em = LightDataAccess.unpackEM(d0);
        }
        if (e3op && e0op) {
            c1lm = e0lm;
            c1ao = e0ao;
            c1em = e0em;
        } else {
            int d1 = cache.get(adjX, adjY, adjZ, faces[0], faces[3]);
            c1lm = LightDataAccess.getLightmap(d1);
            c1ao = LightDataAccess.unpackAO(d1);
            c1em = LightDataAccess.unpackEM(d1);
        }
        if (e2op && e1op) {
            c2lm = e1lm;
            c2ao = e1ao;
            c2em = e1em;
        } else {
            int d2 = cache.get(adjX, adjY, adjZ, faces[1], faces[2]);
            c2lm = LightDataAccess.getLightmap(d2);
            c2ao = LightDataAccess.unpackAO(d2);
            c2em = LightDataAccess.unpackEM(d2);
        }
        if (e3op && e1op) {
            c3lm = e1lm;
            c3ao = e1ao;
            c3em = e1em;
        } else {
            int d3 = cache.get(adjX, adjY, adjZ, faces[1], faces[3]);
            c3lm = LightDataAccess.getLightmap(d3);
            c3ao = LightDataAccess.unpackAO(d3);
            c3em = LightDataAccess.unpackEM(d3);
        }
        float[] ao = this.ao;
        ao[0] = (e3ao + e0ao + c1ao + caao) * 0.25f;
        ao[1] = (e2ao + e0ao + c0ao + caao) * 0.25f;
        ao[2] = (e2ao + e1ao + c2ao + caao) * 0.25f;
        ao[3] = (e3ao + e1ao + c3ao + caao) * 0.25f;
        int[] cb = this.lm;
        cb[0] = AoFaceData.calculateCornerBrightness(e3lm, e0lm, c1lm, calm, e3em, e0em, c1em, caem);
        cb[1] = AoFaceData.calculateCornerBrightness(e2lm, e0lm, c0lm, calm, e2em, e0em, c0em, caem);
        cb[2] = AoFaceData.calculateCornerBrightness(e2lm, e1lm, c2lm, calm, e2em, e1em, c2em, caem);
        cb[3] = AoFaceData.calculateCornerBrightness(e3lm, e1lm, c3lm, calm, e3em, e1em, c3em, caem);
        this.flags |= 1;
    }

    public void unpackLightData() {
        int[] lm = this.lm;
        float[] bl = this.bl;
        float[] sl = this.sl;
        bl[0] = AoFaceData.unpackBlockLight(lm[0]);
        bl[1] = AoFaceData.unpackBlockLight(lm[1]);
        bl[2] = AoFaceData.unpackBlockLight(lm[2]);
        bl[3] = AoFaceData.unpackBlockLight(lm[3]);
        sl[0] = AoFaceData.unpackSkyLight(lm[0]);
        sl[1] = AoFaceData.unpackSkyLight(lm[1]);
        sl[2] = AoFaceData.unpackSkyLight(lm[2]);
        sl[3] = AoFaceData.unpackSkyLight(lm[3]);
        this.flags |= 2;
    }

    public float getBlendedSkyLight(float[] w) {
        return AoFaceData.weightedSum(this.sl, w);
    }

    public float getBlendedBlockLight(float[] w) {
        return AoFaceData.weightedSum(this.bl, w);
    }

    public float getBlendedShade(float[] w) {
        return AoFaceData.weightedSum(this.ao, w);
    }

    private static float weightedSum(float[] v, float[] w) {
        float t0 = v[0] * w[0];
        float t1 = v[1] * w[1];
        float t2 = v[2] * w[2];
        float t3 = v[3] * w[3];
        return t0 + t1 + t2 + t3;
    }

    private static float unpackSkyLight(int i) {
        return i >> 16 & 0xFF;
    }

    private static float unpackBlockLight(int i) {
        return i & 0xFF;
    }

    private static int calculateCornerBrightness(int a, int b, int c, int d, boolean aem, boolean bem, boolean cem, boolean dem) {
        if (a == 0 || b == 0 || c == 0 || d == 0) {
            int min = AoFaceData.minNonZero(AoFaceData.minNonZero(a, b), AoFaceData.minNonZero(c, d));
            a = Math.max(a, min);
            b = Math.max(b, min);
            c = Math.max(c, min);
            d = Math.max(d, min);
        }
        if (aem) {
            a = LightDataAccess.FULL_BRIGHT;
        }
        if (bem) {
            b = LightDataAccess.FULL_BRIGHT;
        }
        if (cem) {
            c = LightDataAccess.FULL_BRIGHT;
        }
        if (dem) {
            d = LightDataAccess.FULL_BRIGHT;
        }
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    private static int minNonZero(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return Math.min(a, b);
    }

    public boolean hasLightData() {
        return (this.flags & 1) != 0;
    }

    public boolean hasUnpackedLightData() {
        return (this.flags & 2) != 0;
    }

    public void reset() {
        this.flags = 0;
    }
}

