/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.quad.properties;

import java.util.Arrays;
import org.embeddedt.embeddium.api.util.NormI8;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Axis.class})
public enum ModelQuadFacing {
    POS_X(1, 0, 0, Axis.X),
    POS_Y(0, 1, 0, Axis.Y),
    POS_Z(0, 0, 1, Axis.Z),
    NEG_X(-1, 0, 0, Axis.X),
    NEG_Y(0, -1, 0, Axis.Y),
    NEG_Z(0, 0, -1, Axis.Z),
    UNASSIGNED(0, 0, 0, null);

    public static final ModelQuadFacing[] VALUES;
    public static final ModelQuadFacing[] DIRECTIONS;
    public static final Axis[] AXES;
    public static final int COUNT;
    public static final int NONE = 0;
    public static final int ALL;
    private final int packedNormal;
    private final int stepX;
    private final int stepY;
    private final int stepZ;
    private final Axis axis;

    private ModelQuadFacing(int stepX, int stepY, int stepZ, Axis axis) {
        this.stepX = stepX;
        this.stepY = stepY;
        this.stepZ = stepZ;
        this.axis = axis;
        this.packedNormal = NormI8.pack(stepX, stepY, stepZ);
    }

    public ModelQuadFacing getOpposite() {
        ModelQuadFacing modelQuadFacing;
        switch (this.ordinal()) {
            case 1: {
                modelQuadFacing = NEG_Y;
                break;
            }
            case 4: {
                modelQuadFacing = POS_Y;
                break;
            }
            case 0: {
                modelQuadFacing = NEG_X;
                break;
            }
            case 3: {
                modelQuadFacing = POS_X;
                break;
            }
            case 2: {
                modelQuadFacing = NEG_Z;
                break;
            }
            case 5: {
                modelQuadFacing = POS_Z;
                break;
            }
            default: {
                modelQuadFacing = UNASSIGNED;
            }
        }
        return modelQuadFacing;
    }

    public boolean isDirection() {
        return this != UNASSIGNED;
    }

    public int getPackedNormal() {
        return this.packedNormal;
    }

    public int getStepX() {
        return this.stepX;
    }

    public int getStepY() {
        return this.stepY;
    }

    public int getStepZ() {
        return this.stepZ;
    }

    public Axis getAxis() {
        return this.axis;
    }

    static {
        VALUES = ModelQuadFacing.values();
        DIRECTIONS = (ModelQuadFacing[])Arrays.stream(VALUES).filter(facing -> facing != UNASSIGNED).toArray(ModelQuadFacing[]::new);
        AXES = Axis.values();
        COUNT = VALUES.length;
        ALL = (1 << COUNT) - 1;
    }

    @NestHost(value=ModelQuadFacing.class)
    public static enum Axis {
        X,
        Y,
        Z;


        public ModelQuadFacing getFacing(boolean positive) {
            ModelQuadFacing modelQuadFacing;
            switch (this.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    if (positive) {
                        modelQuadFacing = POS_X;
                        break;
                    }
                    modelQuadFacing = NEG_X;
                    break;
                }
                case 1: {
                    if (positive) {
                        modelQuadFacing = POS_Y;
                        break;
                    }
                    modelQuadFacing = NEG_Y;
                    break;
                }
                case 2: {
                    modelQuadFacing = positive ? POS_Z : NEG_Z;
                }
            }
            return modelQuadFacing;
        }
    }
}

