/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttribute;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gl.shader.GlProgram;
import org.embeddedt.embeddium.impl.gl.shader.GlShader;
import org.embeddedt.embeddium.impl.gl.shader.ShaderBindingContext;
import org.embeddedt.embeddium.impl.gl.shader.ShaderConstants;
import org.embeddedt.embeddium.impl.gl.shader.ShaderType;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderer;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderComponent;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderFogComponent;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderOptions;
import org.embeddedt.embeddium.impl.render.chunk.shader.DefaultChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.shader.ShaderLoader;
import org.jetbrains.annotations.Nullable;

public abstract class ShaderChunkRenderer
implements ChunkRenderer {
    private static final Logger LOGGER = LogManager.getLogger(ShaderChunkRenderer.class);
    private final Map<ChunkShaderOptions, @Nullable GlProgram<ChunkShaderInterface>> programs = new Object2ObjectOpenHashMap();
    protected final RenderPassConfiguration<?> renderPassConfiguration;
    protected final RenderDevice device;
    protected GlProgram<ChunkShaderInterface> activeProgram;

    public ShaderChunkRenderer(RenderDevice device, RenderPassConfiguration<?> renderPassConfiguration) {
        this.device = device;
        this.renderPassConfiguration = renderPassConfiguration;
    }

    @Nullable
    protected GlProgram<ChunkShaderInterface> compileProgram(ChunkShaderOptions options) {
        GlProgram<ChunkShaderInterface> program = this.programs.get((Object)options);
        if (program == null && !this.programs.containsKey((Object)options)) {
            try {
                program = this.createShader("blocks/block_layer_opaque", options);
            }
            catch (Exception e) {
                LOGGER.error("There was an error creating a chunk program. Terrain will not render until this is fixed.", (Throwable)e);
            }
            this.programs.put(options, program);
        }
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GlProgram<ChunkShaderInterface> createShader(String path, ChunkShaderOptions options) {
        ShaderConstants constants = options.constants();
        ArrayList<GlShader> loadedShaders = new ArrayList<GlShader>();
        loadedShaders.add(ShaderLoader.loadShader(ShaderType.VERTEX, ShaderChunkRenderer.jvmdowngrader$concat$createShader$1(path), constants));
        loadedShaders.add(ShaderLoader.loadShader(ShaderType.FRAGMENT, ShaderChunkRenderer.jvmdowngrader$concat$createShader$2(path), constants));
        try {
            GlProgram.Builder builder = GlProgram.builder("sodium:chunk_shader");
            loadedShaders.forEach(builder::attachShader);
            int i = 0;
            for (GlVertexAttribute attr : options.pass().vertexType().getVertexFormat().getAttributes()) {
                builder.bindAttribute(attr.getName(), i++);
            }
            builder.bindFragmentData("fragColor", 0);
            GlProgram<ChunkShaderInterface> glProgram = builder.link(shader -> new DefaultChunkShaderInterface((ShaderBindingContext)shader, options));
            return glProgram;
        }
        finally {
            loadedShaders.forEach(GlObject::delete);
        }
    }

    protected List<ChunkShaderComponent.Factory<?>> getShaderComponents() {
        ArrayList componentFactories = new ArrayList(4);
        componentFactories.add(ChunkShaderFogComponent.FOG_SERVICE.getFogMode());
        return componentFactories;
    }

    protected void begin(TerrainRenderPass pass) {
        pass.startDrawing();
        ChunkShaderOptions options = new ChunkShaderOptions(this.getShaderComponents(), pass);
        this.activeProgram = this.compileProgram(options);
        if (this.activeProgram != null) {
            this.activeProgram.bind();
            this.activeProgram.getInterface().setupState(pass);
        }
    }

    protected void end(TerrainRenderPass pass) {
        if (this.activeProgram != null) {
            this.activeProgram.getInterface().restoreState();
            this.activeProgram.unbind();
            this.activeProgram = null;
        }
        pass.endDrawing();
    }

    @Override
    public void delete(CommandList commandList) {
        this.programs.values().stream().filter(Objects::nonNull).forEach(GlObject::delete);
    }

    @Override
    public RenderPassConfiguration<?> getRenderPassConfiguration() {
        return this.renderPassConfiguration;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShader$1(String string) {
        return "sodium:" + string + ".vsh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShader$2(String string) {
        return "sodium:" + string + ".fsh";
    }
}

