/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.tasks;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import org.embeddedt.embeddium.impl.common.util.NativeBuffer;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkSortOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.ChunkPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;

public class ChunkBuilderSortTask
extends ChunkBuilderTask<ChunkSortOutput> {
    private final RenderSection render;
    private final float cameraX;
    private final float cameraY;
    private final float cameraZ;
    private final int frame;
    private final Map<TerrainRenderPass, TranslucentQuadAnalyzer.SortState> translucentMeshes;
    private final RenderPassConfiguration<?> renderPassConfiguration;

    public ChunkBuilderSortTask(RenderSection render, float cameraX, float cameraY, float cameraZ, int frame, Map<TerrainRenderPass, TranslucentQuadAnalyzer.SortState> translucentMeshes, RenderPassConfiguration<?> renderPassConfiguration) {
        this.render = render;
        this.cameraX = cameraX;
        this.cameraY = cameraY;
        this.cameraZ = cameraZ;
        this.frame = frame;
        this.translucentMeshes = translucentMeshes;
        this.renderPassConfiguration = renderPassConfiguration;
    }

    @Override
    public ChunkSortOutput execute(ChunkBuildContext context, CancellationToken cancellationSource) {
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        for (Map.Entry<TerrainRenderPass, TranslucentQuadAnalyzer.SortState> entry : this.translucentMeshes.entrySet()) {
            TranslucentQuadAnalyzer.SortState sortInfo = entry.getValue();
            ChunkPrimitiveType primitiveType = this.renderPassConfiguration.getPrimitiveTypeForPass(entry.getKey());
            NativeBuffer newIndexBuffer = new NativeBuffer(primitiveType.getIndexBufferSize(sortInfo.centersLength() / 3));
            primitiveType.generateSortedIndexBuffer(newIndexBuffer.getDirectBuffer(), sortInfo.centersLength() / 3, sortInfo, this.cameraX - (float)this.render.getOriginX(), this.cameraY - (float)this.render.getOriginY(), this.cameraZ - (float)this.render.getOriginZ());
            meshes.put((Object)entry.getKey(), (Object)new ChunkSortOutput.SortedMesh(newIndexBuffer));
        }
        return new ChunkSortOutput(this.render, this.frame, (Reference2ReferenceMap<TerrainRenderPass, ChunkSortOutput.SortedMesh>)meshes);
    }
}

