/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.data;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.embeddedt.embeddium.impl.common.util.NativeBuffer;
import org.embeddedt.embeddium.impl.gl.util.VertexRange;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildBuffers;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

@RecordComponents(value={@RecordComponents.Value(name="vertexBuffer", type=NativeBuffer.class), @RecordComponents.Value(name="indexBuffer", type=NativeBuffer.class), @RecordComponents.Value(name="sortState", type=TranslucentQuadAnalyzer.SortState.class), @RecordComponents.Value(name="ranges", type=Map.class)})
public final class BuiltSectionMeshParts
extends J_L_Record {
    private final NativeBuffer vertexBuffer;
    @Nullable
    private final NativeBuffer indexBuffer;
    @Nullable
    private final TranslucentQuadAnalyzer.SortState sortState;
    private final Map<ModelQuadFacing, VertexRange> ranges;

    public BuiltSectionMeshParts(NativeBuffer vertexBuffer, @Nullable NativeBuffer indexBuffer, @Nullable TranslucentQuadAnalyzer.SortState sortState, Map<ModelQuadFacing, VertexRange> ranges) {
        this.vertexBuffer = vertexBuffer;
        this.indexBuffer = indexBuffer;
        this.sortState = sortState;
        this.ranges = ranges;
    }

    public void free() {
        this.vertexBuffer.free();
        if (this.indexBuffer != null) {
            this.indexBuffer.free();
        }
    }

    public static Reference2ReferenceMap<TerrainRenderPass, BuiltSectionMeshParts> groupFromBuildBuffers(ChunkBuildBuffers buffers, float relativeCameraX, float relativeCameraY, float relativeCameraZ) {
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        for (TerrainRenderPass pass : buffers.getBuilderPasses()) {
            BuiltSectionMeshParts mesh = buffers.createMesh(pass, relativeCameraX, relativeCameraY, relativeCameraZ);
            if (mesh == null) continue;
            meshes.put((Object)pass, (Object)mesh);
        }
        return meshes;
    }

    public final String toString() {
        return BuiltSectionMeshParts.jvmdowngrader$toString$toString(this);
    }

    public final int hashCode() {
        return BuiltSectionMeshParts.jvmdowngrader$hashCode$hashCode(this);
    }

    public final boolean equals(Object o) {
        return BuiltSectionMeshParts.jvmdowngrader$equals$equals(this, o);
    }

    public NativeBuffer vertexBuffer() {
        return this.vertexBuffer;
    }

    @Nullable
    public NativeBuffer indexBuffer() {
        return this.indexBuffer;
    }

    @Nullable
    public TranslucentQuadAnalyzer.SortState sortState() {
        return this.sortState;
    }

    public Map<ModelQuadFacing, VertexRange> ranges() {
        return this.ranges;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(BuiltSectionMeshParts builtSectionMeshParts) {
        BuiltSectionMeshParts builtSectionMeshParts2 = builtSectionMeshParts;
        return "BuiltSectionMeshParts[" + "vertexBuffer=" + builtSectionMeshParts.vertexBuffer + ", " + "indexBuffer=" + builtSectionMeshParts.indexBuffer + ", " + "sortState=" + (Object)((Object)builtSectionMeshParts.sortState) + ", " + "ranges=" + builtSectionMeshParts.ranges + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(BuiltSectionMeshParts builtSectionMeshParts) {
        Object[] objectArray = new Object[]{builtSectionMeshParts.vertexBuffer, builtSectionMeshParts.indexBuffer, builtSectionMeshParts.sortState, builtSectionMeshParts.ranges};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(BuiltSectionMeshParts builtSectionMeshParts, Object object) {
        if (builtSectionMeshParts == object) {
            return true;
        }
        if (object != null && object instanceof BuiltSectionMeshParts) {
            BuiltSectionMeshParts builtSectionMeshParts2 = (BuiltSectionMeshParts)((Object)object);
            if (Objects.equals(builtSectionMeshParts.vertexBuffer, builtSectionMeshParts2.vertexBuffer) && Objects.equals(builtSectionMeshParts.indexBuffer, builtSectionMeshParts2.indexBuffer) && Objects.equals((Object)builtSectionMeshParts.sortState, (Object)builtSectionMeshParts2.sortState) && Objects.equals(builtSectionMeshParts.ranges, builtSectionMeshParts2.ranges)) {
                return true;
            }
        }
        return false;
    }
}

