/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.terrain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.ChunkPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Map;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={TerrainRenderPassBuilder.class, PipelineState.class, PipelineState.1.class})
public class TerrainRenderPass {
    private final String name;
    private final PipelineState pipelineState;
    private final boolean useReverseOrder;
    private final boolean fragmentDiscard;
    private final boolean useTranslucencySorting;
    private final boolean hasNoLightmap;
    @NotNull
    private final ChunkPrimitiveType primitiveType;
    @NotNull
    private final ChunkVertexType vertexType;
    private final Map<String, String> extraDefines;

    public TerrainRenderPass(String name, PipelineState pipelineState, boolean useReverseOrder, boolean fragmentDiscard, boolean useTranslucencySorting, boolean hasNoLightmap, @NotNull ChunkVertexType vertexType, @NotNull ChunkPrimitiveType primitiveType, Map<String, String> extraDefines) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name not specified for terrain pass");
        }
        Objects.requireNonNull(vertexType);
        Objects.requireNonNull(primitiveType);
        this.name = name;
        this.pipelineState = pipelineState;
        this.useReverseOrder = useReverseOrder;
        this.fragmentDiscard = fragmentDiscard;
        this.useTranslucencySorting = useTranslucencySorting;
        this.hasNoLightmap = hasNoLightmap;
        this.primitiveType = primitiveType;
        this.vertexType = vertexType;
        this.extraDefines = J_U_Map.copyOf(extraDefines);
    }

    public boolean isReverseOrder() {
        return this.useReverseOrder;
    }

    public boolean isSorted() {
        return this.useTranslucencySorting;
    }

    public boolean hasNoLightmap() {
        return this.hasNoLightmap;
    }

    public void startDrawing() {
        this.pipelineState.setup();
    }

    public void endDrawing() {
        this.pipelineState.clear();
    }

    public boolean supportsFragmentDiscard() {
        return this.fragmentDiscard;
    }

    public ChunkPrimitiveType primitiveType() {
        return this.primitiveType;
    }

    public ChunkVertexType vertexType() {
        return this.vertexType;
    }

    public Map<String, String> extraDefines() {
        return this.extraDefines;
    }

    public String toString() {
        return TerrainRenderPass.jvmdowngrader$concat$toString$1(this.name);
    }

    public static TerrainRenderPassBuilder builder() {
        return new TerrainRenderPassBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TerrainRenderPass)) {
            return false;
        }
        TerrainRenderPass other = (TerrainRenderPass)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.useReverseOrder != other.useReverseOrder) {
            return false;
        }
        if (this.fragmentDiscard != other.fragmentDiscard) {
            return false;
        }
        if (this.useTranslucencySorting != other.useTranslucencySorting) {
            return false;
        }
        if (this.hasNoLightmap() != other.hasNoLightmap()) {
            return false;
        }
        PipelineState this$pipelineState = this.pipelineState;
        PipelineState other$pipelineState = other.pipelineState;
        if (this$pipelineState == null ? other$pipelineState != null : !this$pipelineState.equals(other$pipelineState)) {
            return false;
        }
        ChunkPrimitiveType this$primitiveType = this.primitiveType();
        ChunkPrimitiveType other$primitiveType = other.primitiveType();
        if (this$primitiveType == null ? other$primitiveType != null : !this$primitiveType.equals(other$primitiveType)) {
            return false;
        }
        ChunkVertexType this$vertexType = this.vertexType();
        ChunkVertexType other$vertexType = other.vertexType();
        if (this$vertexType == null ? other$vertexType != null : !this$vertexType.equals(other$vertexType)) {
            return false;
        }
        Map<String, String> this$extraDefines = this.extraDefines();
        Map<String, String> other$extraDefines = other.extraDefines();
        return !(this$extraDefines == null ? other$extraDefines != null : !((Object)this$extraDefines).equals(other$extraDefines));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TerrainRenderPass;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.useReverseOrder ? 79 : 97);
        result = result * 59 + (this.fragmentDiscard ? 79 : 97);
        result = result * 59 + (this.useTranslucencySorting ? 79 : 97);
        result = result * 59 + (this.hasNoLightmap() ? 79 : 97);
        PipelineState $pipelineState = this.pipelineState;
        result = result * 59 + ($pipelineState == null ? 43 : $pipelineState.hashCode());
        ChunkPrimitiveType $primitiveType = this.primitiveType();
        result = result * 59 + ($primitiveType == null ? 43 : $primitiveType.hashCode());
        ChunkVertexType $vertexType = this.vertexType();
        result = result * 59 + ($vertexType == null ? 43 : $vertexType.hashCode());
        Map<String, String> $extraDefines = this.extraDefines();
        result = result * 59 + ($extraDefines == null ? 43 : ((Object)$extraDefines).hashCode());
        return result;
    }

    public String name() {
        return this.name;
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string) {
        return "TerrainRenderPass[name=" + string + "]";
    }

    @NestHost(value=TerrainRenderPass.class)
    public static interface PipelineState {
        public static final PipelineState DEFAULT = new PipelineState(){

            @Override
            public void setup() {
            }

            @Override
            public void clear() {
            }
        };

        public void setup();

        public void clear();
    }

    @NestHost(value=TerrainRenderPass.class)
    public static class TerrainRenderPassBuilder {
        private String name;
        private PipelineState pipelineState;
        private boolean useReverseOrder;
        private boolean fragmentDiscard;
        private boolean useTranslucencySorting;
        private boolean hasNoLightmap;
        private ChunkVertexType vertexType;
        private ChunkPrimitiveType primitiveType;
        private ArrayList<String> extraDefines$key;
        private ArrayList<String> extraDefines$value;

        TerrainRenderPassBuilder() {
        }

        public TerrainRenderPassBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TerrainRenderPassBuilder pipelineState(PipelineState pipelineState) {
            this.pipelineState = pipelineState;
            return this;
        }

        public TerrainRenderPassBuilder useReverseOrder(boolean useReverseOrder) {
            this.useReverseOrder = useReverseOrder;
            return this;
        }

        public TerrainRenderPassBuilder fragmentDiscard(boolean fragmentDiscard) {
            this.fragmentDiscard = fragmentDiscard;
            return this;
        }

        public TerrainRenderPassBuilder useTranslucencySorting(boolean useTranslucencySorting) {
            this.useTranslucencySorting = useTranslucencySorting;
            return this;
        }

        public TerrainRenderPassBuilder hasNoLightmap(boolean hasNoLightmap) {
            this.hasNoLightmap = hasNoLightmap;
            return this;
        }

        public TerrainRenderPassBuilder vertexType(@NotNull ChunkVertexType vertexType) {
            if (vertexType == null) {
                throw new NullPointerException("vertexType is marked non-null but is null");
            }
            this.vertexType = vertexType;
            return this;
        }

        public TerrainRenderPassBuilder primitiveType(@NotNull ChunkPrimitiveType primitiveType) {
            if (primitiveType == null) {
                throw new NullPointerException("primitiveType is marked non-null but is null");
            }
            this.primitiveType = primitiveType;
            return this;
        }

        public TerrainRenderPassBuilder extraDefine(String extraDefineKey, String extraDefineValue) {
            if (this.extraDefines$key == null) {
                this.extraDefines$key = new ArrayList();
                this.extraDefines$value = new ArrayList();
            }
            this.extraDefines$key.add(extraDefineKey);
            this.extraDefines$value.add(extraDefineValue);
            return this;
        }

        public TerrainRenderPassBuilder extraDefines(Map<? extends String, ? extends String> extraDefines) {
            if (extraDefines == null) {
                throw new NullPointerException("extraDefines cannot be null");
            }
            if (this.extraDefines$key == null) {
                this.extraDefines$key = new ArrayList();
                this.extraDefines$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : extraDefines.entrySet()) {
                this.extraDefines$key.add($lombokEntry.getKey());
                this.extraDefines$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TerrainRenderPassBuilder clearExtraDefines() {
            if (this.extraDefines$key != null) {
                this.extraDefines$key.clear();
                this.extraDefines$value.clear();
            }
            return this;
        }

        public TerrainRenderPass build() {
            Map<String, String> extraDefines;
            switch (this.extraDefines$key == null ? 0 : this.extraDefines$key.size()) {
                case 0: {
                    extraDefines = Collections.emptyMap();
                    break;
                }
                case 1: {
                    extraDefines = Collections.singletonMap(this.extraDefines$key.get(0), this.extraDefines$value.get(0));
                    break;
                }
                default: {
                    extraDefines = new LinkedHashMap(this.extraDefines$key.size() < 0x40000000 ? 1 + this.extraDefines$key.size() + (this.extraDefines$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.extraDefines$key.size(); ++$i) {
                        extraDefines.put(this.extraDefines$key.get($i), this.extraDefines$value.get($i));
                    }
                    extraDefines = Collections.unmodifiableMap(extraDefines);
                }
            }
            return new TerrainRenderPass(this.name, this.pipelineState, this.useReverseOrder, this.fragmentDiscard, this.useTranslucencySorting, this.hasNoLightmap, this.vertexType, this.primitiveType, extraDefines);
        }

        public String toString() {
            return TerrainRenderPassBuilder.jvmdowngrader$concat$toString$1(this.name, String.valueOf(this.pipelineState), this.useReverseOrder, this.fragmentDiscard, this.useTranslucencySorting, this.hasNoLightmap, String.valueOf(this.vertexType), String.valueOf(this.primitiveType), String.valueOf(this.extraDefines$key), String.valueOf(this.extraDefines$value));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3, String string4, String string5, String string6) {
            return "TerrainRenderPass.TerrainRenderPassBuilder(name=" + string + ", pipelineState=" + string2 + ", useReverseOrder=" + bl + ", fragmentDiscard=" + bl2 + ", useTranslucencySorting=" + bl3 + ", hasNoLightmap=" + bl4 + ", vertexType=" + string3 + ", primitiveType=" + string4 + ", extraDefines$key=" + string5 + ", extraDefines$value=" + string6 + ")";
        }
    }
}

