/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.util.collections.map;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Set;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;

public class StampedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> backingMap;
    private final StampedLock lock;

    public StampedMap(Map<K, V> backingMap) {
        this.backingMap = backingMap;
        this.lock = new StampedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long readStamp = this.lock.readLock();
        try {
            int n = this.backingMap.size();
            return n;
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        long readStamp = this.lock.readLock();
        try {
            boolean bl = this.backingMap.containsKey(key);
            return bl;
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        long readStamp = this.lock.readLock();
        try {
            boolean bl = this.backingMap.containsValue(value);
            return bl;
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        long readStamp = this.lock.readLock();
        try {
            V v = this.backingMap.get(key);
            return v;
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V put(K key, V value) {
        long stamp = this.lock.writeLock();
        try {
            V v = this.backingMap.put(key, value);
            return v;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        long stamp = this.lock.writeLock();
        try {
            V v = this.backingMap.remove(key);
            return v;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        long stamp = this.lock.writeLock();
        try {
            this.backingMap.putAll(m);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.backingMap.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<K> keySet() {
        long readStamp = this.lock.readLock();
        try {
            Set set = J_U_Set.copyOf(this.backingMap.keySet());
            return set;
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return J_U_List.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        long readStamp = this.lock.readLock();
        try {
            Set<Map.Entry<K, V>> set = this.backingMap.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), entry.getValue())).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        long readStamp = this.lock.readLock();
        try {
            boolean bl = this.backingMap.equals(obj);
            return bl;
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        long readStamp = this.lock.readLock();
        try {
            int n = this.backingMap.hashCode();
            return n;
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
    }
}

