/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.util.rand;

import it.unimi.dsi.fastutil.HashCommon;
import org.embeddedt.embeddium.impl.util.rand.XoRoShiRoRandom;

public class SplitMixRandom {
    private static final long PHI = -7046029254386353131L;
    private long x;

    public SplitMixRandom() {
        this(XoRoShiRoRandom.randomSeed());
    }

    public SplitMixRandom(long seed) {
        this.setSeed(seed);
    }

    private static long staffordMix13(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    private static int staffordMix4Upper32(long z) {
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    public long nextLong() {
        return SplitMixRandom.staffordMix13(this.x += -7046029254386353131L);
    }

    public int nextInt() {
        return SplitMixRandom.staffordMix4Upper32(this.x += -7046029254386353131L);
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException(SplitMixRandom.jvmdowngrader$concat$nextLong$1(n));
        }
        long t = SplitMixRandom.staffordMix13(this.x += -7046029254386353131L);
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t & nMinus1;
        }
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = SplitMixRandom.staffordMix13(this.x += -7046029254386353131L) >>> 1;
        }
        return t;
    }

    public double nextDouble() {
        return (double)(SplitMixRandom.staffordMix13(this.x += -7046029254386353131L) >>> 11) * (double)1.110223E-16f;
    }

    public float nextFloat() {
        return (float)(SplitMixRandom.staffordMix4Upper32(this.x += -7046029254386353131L) >>> 8) * 5.9604645E-8f;
    }

    public boolean nextBoolean() {
        return SplitMixRandom.staffordMix4Upper32(this.x += -7046029254386353131L) < 0;
    }

    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        while (i != 0) {
            int n = Math.min(i, 8);
            long bits = SplitMixRandom.staffordMix13(this.x += -7046029254386353131L);
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    public void setSeed(long seed) {
        this.x = HashCommon.murmurHash3((long)seed);
    }

    public void setState(long state) {
        this.x = state;
    }

    private static /* synthetic */ String jvmdowngrader$concat$nextLong$1(long l) {
        return "illegal bound " + l + " (must be positive)";
    }
}

