/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.api.task;

import com.ventooth.beddium.Compat;
import com.ventooth.beddium.Share;
import com.ventooth.beddium.api.cache.StateAwareCache;
import com.ventooth.beddium.api.task.WorldRenderRegion;
import com.ventooth.beddium.config.TerrainRenderingConfig;
import com.ventooth.beddium.mixin.mixins.client.TerrainRendering.ForgeHooksClientMixin;
import com.ventooth.beddium.modules.BiomeColorCache.BiomeColorCacheModule;
import com.ventooth.beddium.modules.MEGAChunks.MEGASectionVisibilityBuilder;
import com.ventooth.beddium.modules.TerrainRendering.ArchaicRenderSectionManager;
import com.ventooth.beddium.modules.TerrainRendering.CeleritasWorldRenderer;
import com.ventooth.beddium.modules.TerrainRendering.TerrainRenderingModule;
import com.ventooth.beddium.modules.TerrainRendering.compile.ArchaicChunkBuildContext;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import mega.fluidlogged.api.FLBlockAccess;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ReportedException;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildBuffers;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.data.MinecraftBuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.SectionVisibilityBuilder;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={MainThreadWork.class, FluidLoggedCompat.class})
public abstract class SimpleChunkBuilderMeshingTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    protected final RenderSection render;
    protected final int buildTime;
    protected final Vector3d camera;
    protected final WorldRenderRegion region;
    protected final ChunkCache chunkCache;

    public SimpleChunkBuilderMeshingTask(RenderSection render, WorldRenderRegion region, int time, Vector3d camera) {
        this.render = render;
        this.buildTime = time;
        this.camera = camera;
        this.region = region;
        this.chunkCache = this.createChunkCache(region);
    }

    protected abstract ChunkCache createChunkCache(WorldRenderRegion var1);

    protected abstract Tessellator getTessellator();

    protected abstract void setRenderPass(int var1);

    protected static void setForgeRenderPass(int pass) {
        ForgeHooksClientMixin.setWorldRenderPass(pass);
    }

    public static void incrementChunkUpdateCounter() {
        TerrainRenderingModule.incrementChunkUpdateCounter();
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext context, CancellationToken cancellationToken) {
        ArchaicChunkBuildContext buildContext = (ArchaicChunkBuildContext)context;
        MinecraftBuiltRenderSectionData renderData = new MinecraftBuiltRenderSectionData();
        boolean megaChunks = TerrainRenderingConfig.MEGAChunks != 0;
        Object occluder = megaChunks ? new MEGASectionVisibilityBuilder() : new SectionVisibilityBuilder();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getSectionIndex());
        int minX = this.region.minX;
        int minY = this.region.minY;
        int minZ = this.region.minZ;
        int maxX = this.region.maxX;
        int maxY = this.region.maxY;
        int maxZ = this.region.maxZ;
        int blockX = minX;
        int blockY = minY;
        int blockZ = minZ;
        ChunkCache chunkCache = this.chunkCache;
        if (chunkCache instanceof StateAwareCache) {
            StateAwareCache state = (StateAwareCache)chunkCache;
            state.renderStart();
        }
        BiomeColorCacheModule.update((IBlockAccess)chunkCache, this.render.getChunkX(), this.render.getChunkY(), this.render.getChunkZ());
        RenderBlocks renderBlocks = new RenderBlocks((IBlockAccess)chunkCache);
        Tessellator tessellator = this.getTessellator();
        tessellator.func_78373_b((double)(-minX), (double)(-minY), (double)(-minZ));
        BiomeColorCacheModule.toggleCacheActive(true);
        try {
            boolean threaded = this.isThreaded();
            IntArrayList deferredWork = null;
            boolean hasDeferredWork = false;
            for (int y = minY; y < maxY; ++y) {
                if (cancellationToken.isCancelled()) {
                    ChunkBuildOutput chunkBuildOutput = null;
                    return chunkBuildOutput;
                }
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        TileEntity tileEntity;
                        blockX = x;
                        blockY = y;
                        blockZ = z;
                        Block block = chunkCache.func_147439_a(x, y, z);
                        if (block.func_149688_o() == Material.field_151579_a) continue;
                        if (block.hasTileEntity(chunkCache.func_72805_g(x, y, z)) && TileEntityRendererDispatcher.field_147556_a.func_147545_a(tileEntity = chunkCache.func_147438_o(x, y, z))) {
                            renderData.globalBlockEntities.add(tileEntity);
                        }
                        if (!threaded || this.canRenderOffThread(0, block, x, y, z)) {
                            this.tryRenderBlock(tessellator, renderBlocks, 0, block, x, y, z);
                        } else {
                            if (deferredWork == null) {
                                deferredWork = new IntArrayList(384);
                            }
                            deferredWork.add(x);
                            deferredWork.add(y);
                            deferredWork.add(z);
                            hasDeferredWork = true;
                        }
                        if (!block.func_149662_c()) continue;
                        if (megaChunks) {
                            ((MEGASectionVisibilityBuilder)occluder).markOpaque(blockX, blockY, blockZ);
                            continue;
                        }
                        ((SectionVisibilityBuilder)occluder).markOpaque(blockX, blockY, blockZ);
                    }
                }
            }
            if (threaded && hasDeferredWork) {
                this.runWorkOnMainThread(0, (IntList)deferredWork, tessellator, renderBlocks, cancellationToken);
                if (cancellationToken.isCancelled()) {
                    ChunkBuildOutput y = null;
                    return y;
                }
                hasDeferredWork = false;
                deferredWork.clear();
            }
            if (tessellator.field_78415_z) {
                buildContext.copyRawBuffer(tessellator.field_78405_h, tessellator.field_78406_i, buffers, buffers.getRenderPassConfiguration().getMaterialForRenderType(0));
                tessellator.field_78415_z = false;
                tessellator.func_78379_d();
                this.setRenderPass(-1);
            }
            for (int pass = 1; pass < 2; ++pass) {
                for (int y = minY; y < maxY; ++y) {
                    if (cancellationToken.isCancelled()) {
                        ChunkBuildOutput x = null;
                        return x;
                    }
                    for (int z = minZ; z < maxZ; ++z) {
                        for (int x = minX; x < maxX; ++x) {
                            blockX = x;
                            blockY = y;
                            blockZ = z;
                            Block block = chunkCache.func_147439_a(x, y, z);
                            if (block.func_149688_o() == Material.field_151579_a) continue;
                            if (!threaded || this.canRenderOffThread(pass, block, x, y, z)) {
                                this.tryRenderBlock(tessellator, renderBlocks, pass, block, x, y, z);
                                continue;
                            }
                            if (deferredWork == null) {
                                deferredWork = new IntArrayList(384);
                            }
                            deferredWork.add(x);
                            deferredWork.add(y);
                            deferredWork.add(z);
                            hasDeferredWork = true;
                        }
                    }
                }
                if (threaded && hasDeferredWork) {
                    this.runWorkOnMainThread(pass, (IntList)deferredWork, tessellator, renderBlocks, cancellationToken);
                    if (cancellationToken.isCancelled()) {
                        ChunkBuildOutput chunkBuildOutput = null;
                        return chunkBuildOutput;
                    }
                    hasDeferredWork = false;
                    deferredWork.clear();
                }
                if (!tessellator.field_78415_z) continue;
                buildContext.copyRawBuffer(tessellator.field_78405_h, tessellator.field_78406_i, buffers, buffers.getRenderPassConfiguration().getMaterialForRenderType(pass));
                tessellator.field_78415_z = false;
                tessellator.func_78379_d();
                this.setRenderPass(-1);
            }
        }
        catch (ReportedException ex) {
            throw this.fillCrashInfo(ex.func_71575_a(), (IBlockAccess)chunkCache, blockX, blockY, blockZ);
        }
        catch (Throwable ex) {
            throw this.fillCrashInfo(CrashReport.func_85055_a((Throwable)ex, (String)"Encountered exception while building chunk meshes"), (IBlockAccess)chunkCache, blockX, blockY, blockZ);
        }
        finally {
            BiomeColorCacheModule.toggleCacheActive(false);
            tessellator.func_78373_b(0.0, 0.0, 0.0);
            if (chunkCache instanceof StateAwareCache) {
                StateAwareCache state = (StateAwareCache)chunkCache;
                state.renderFinish();
            }
            if (tessellator.field_78415_z) {
                tessellator.field_78415_z = false;
                tessellator.func_78379_d();
                this.setRenderPass(-1);
            }
        }
        Reference2ReferenceMap<TerrainRenderPass, BuiltSectionMeshParts> meshes = BuiltSectionMeshParts.groupFromBuildBuffers(buffers, (float)this.camera.x - (float)minX, (float)this.camera.y - (float)minY, (float)this.camera.z - (float)minZ);
        if (!meshes.isEmpty()) {
            renderData.hasBlockGeometry = true;
        }
        renderData.visibilityData = megaChunks ? ((MEGASectionVisibilityBuilder)occluder).computeVisibilityEncoding() : ((SectionVisibilityBuilder)occluder).computeVisibilityEncoding();
        SimpleChunkBuilderMeshingTask.incrementChunkUpdateCounter();
        return new ChunkBuildOutput(this.render, renderData, meshes, this.buildTime);
    }

    protected MainThreadWork createMainThreadWork(int pass, IntList coords, Tessellator tessellator, RenderBlocks renderBlocks, CancellationToken cancellationToken) {
        return new MainThreadWork(pass, coords, cancellationToken, tessellator, renderBlocks);
    }

    protected void runWorkOnMainThread(int pass, IntList coords, Tessellator tessellator, RenderBlocks renderBlocks, CancellationToken cancellationToken) {
        MainThreadWork work = this.createMainThreadWork(pass, coords, tessellator, renderBlocks, cancellationToken);
        ArchaicRenderSectionManager manager = CeleritasWorldRenderer.instance().getRenderSectionManager();
        CompletableFuture<Void> task = CompletableFuture.runAsync(work, manager::scheduleAsyncTask);
        while (!cancellationToken.isCancelled()) {
            try {
                task.get(2L, TimeUnit.SECONDS);
                break;
            }
            catch (InterruptedException | TimeoutException exception) {
            }
            catch (ExecutionException e) {
                throw new CompletionException(e);
            }
        }
    }

    protected boolean isThreaded() {
        return false;
    }

    protected boolean canRenderOffThread(int pass, Block block, int x, int y, int z) {
        return false;
    }

    protected void tryRenderBlock(Tessellator tessellator, RenderBlocks renderBlocks, int pass, Block block, int x, int y, int z) {
        try {
            Block fluidBlock = this.getFluidBlock(x, y, z);
            boolean canFluidBlockRender = fluidBlock != null && fluidBlock.canRenderInPass(pass);
            boolean canBlockRender = block.canRenderInPass(pass);
            if (!canFluidBlockRender && !canBlockRender) {
                return;
            }
            if (!tessellator.field_78415_z) {
                this.setRenderPass(pass);
                tessellator.func_78382_b();
            }
            if (canFluidBlockRender) {
                renderBlocks.func_147805_b(fluidBlock, x, y, z);
            }
            if (canBlockRender) {
                renderBlocks.func_147805_b(block, x, y, z);
            }
        }
        catch (Exception e) {
            Share.log.error("Failed to render block at ({} {} {})", new Object[]{x, y, z});
            Share.log.error("Stacktrace:", (Throwable)e);
        }
    }

    protected ReportedException fillCrashInfo(CrashReport report, IBlockAccess slice, int x, int y, int z) {
        CrashReportCategory crashReportSection = report.func_85058_a("Block being rendered");
        Block state = Blocks.field_150350_a;
        int meta = 0;
        try {
            state = slice.func_147439_a(x, y, z);
            meta = slice.func_72805_g(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrashReportCategory.func_147153_a((CrashReportCategory)crashReportSection, (int)x, (int)y, (int)z, (Block)state, (int)meta);
        crashReportSection.func_71507_a("Chunk section", (Object)this.render);
        return new ReportedException(report);
    }

    @Nullable
    protected Block getFluidBlock(int x, int y, int z) {
        if (Compat.fluidloggedInstalled()) {
            return FluidLoggedCompat.getFluidBlock(this.chunkCache, x, y, z);
        }
        return null;
    }

    @NestHost(value=SimpleChunkBuilderMeshingTask.class)
    protected class MainThreadWork
    implements Runnable {
        protected final int pass;
        protected final IntList coords;
        protected final CancellationToken cancellationToken;
        protected final Tessellator tessellator;
        protected final RenderBlocks renderBlocks;

        @Override
        public void run() {
            int len = this.coords.size();
            for (int i = 0; i < len; i += 3) {
                if (this.cancellationToken.isCancelled()) {
                    return;
                }
                int x = this.coords.getInt(i);
                int y = this.coords.getInt(i + 1);
                int z = this.coords.getInt(i + 2);
                Block block = SimpleChunkBuilderMeshingTask.this.chunkCache.func_147439_a(x, y, z);
                SimpleChunkBuilderMeshingTask.this.tryRenderBlock(this.tessellator, this.renderBlocks, this.pass, block, x, y, z);
            }
        }

        @Generated
        public MainThreadWork(int pass, IntList coords, CancellationToken cancellationToken, Tessellator tessellator, RenderBlocks renderBlocks) {
            this.pass = pass;
            this.coords = coords;
            this.cancellationToken = cancellationToken;
            this.tessellator = tessellator;
            this.renderBlocks = renderBlocks;
        }
    }

    @NestHost(value=SimpleChunkBuilderMeshingTask.class)
    private static class FluidLoggedCompat {
        private FluidLoggedCompat() {
        }

        @Nullable
        public static Block getFluidBlock(ChunkCache chunkCache, int x, int y, int z) {
            Fluid fluid = FLBlockAccess.of((ChunkCache)chunkCache).fl$getFluid(x, y, z);
            if (fluid == null) {
                return null;
            }
            return fluid.getBlock();
        }
    }
}

