/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.mixin.mixins.client.TerrainRendering;

import com.falsepattern.lib.util.MathUtil;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.ventooth.beddium.config.TerrainRenderingConfig;
import com.ventooth.beddium.modules.TerrainRendering.fog.FogStateTracker;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.EntityRenderer;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin {
    @Shadow
    private float field_78530_s;

    @Inject(method={"setupFog"}, at={@At(value="RETURN")})
    private void applyFogBias(CallbackInfo ci) {
        float fogStart;
        float fogEnd;
        float fogBias = (float)TerrainRenderingConfig.FastChunkDrawModeFogBias;
        if (TerrainRenderingConfig.ChunkDrawMode != TerrainRenderingConfig.DrawModeEnum.Fast || MathUtil.epsilonEquals((float)fogBias, (float)0.0f)) {
            return;
        }
        if (TerrainRenderingConfig.FastFog) {
            fogEnd = FogStateTracker.end;
            fogStart = FogStateTracker.start;
        } else {
            fogEnd = GL11.glGetInteger((int)2916);
            fogStart = GL11.glGetInteger((int)2915);
        }
        float maxFogEnd = this.field_78530_s + fogBias;
        if (maxFogEnd >= fogEnd || fogStart > fogEnd) {
            return;
        }
        float biasRatio = maxFogEnd / fogEnd;
        fogEnd = maxFogEnd;
        GL11.glFogf((int)2916, (float)fogEnd);
        GL11.glFogf((int)2915, (float)(fogStart *= biasRatio));
        if (TerrainRenderingConfig.FastFog) {
            FogStateTracker.end = fogEnd;
            FogStateTracker.start = fogStart;
        }
    }

    @WrapOperation(method={"setupFog"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glFog(ILjava/nio/FloatBuffer;)V")})
    private void track_glFog(int pname, FloatBuffer params, Operation<Void> original) {
        if (TerrainRenderingConfig.FastFog) {
            FogStateTracker.glFog(pname, params);
        }
        original.call(new Object[]{pname, params});
    }

    @WrapOperation(method={"setupFog"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glFogf(IF)V")})
    private void track_glFogf(int pname, float param, Operation<Void> original) {
        if (TerrainRenderingConfig.FastFog) {
            FogStateTracker.glFogf(pname, param);
        }
        original.call(new Object[]{pname, Float.valueOf(param)});
    }

    @WrapOperation(method={"setupFog"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glFogi(II)V")})
    private void track_glFogi(int pname, int param, Operation<Void> original) {
        if (TerrainRenderingConfig.FastFog) {
            FogStateTracker.glFogi(pname, param);
        }
        original.call(new Object[]{pname, param});
    }

    @WrapOperation(method={"renderWorld"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glEnable(I)V")})
    private void track_glEnable(int cap, Operation<Void> original) {
        if (TerrainRenderingConfig.FastFog) {
            FogStateTracker.glEnable(cap);
        }
        original.call(new Object[]{cap});
    }

    @WrapOperation(method={"renderWorld"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glDisable(I)V")})
    private void track_glDisable(int cap, Operation<Void> original) {
        if (TerrainRenderingConfig.FastFog) {
            FogStateTracker.glDisable(cap);
        }
        original.call(new Object[]{cap});
    }
}

