/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering;

import com.google.common.collect.ImmutableListMultimap;
import com.ventooth.beddium.modules.TerrainRendering.vertex.CompatibleChunkVertex;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.QuadPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.parameters.AlphaCutoffParameter;
import org.lwjgl.opengl.GL11;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

@NestMembers(value={ArchaicPipelineState.class})
public class ArchaicRenderPassConfigurationBuilder {
    public static TerrainRenderPass SOLID_PASS;
    public static TerrainRenderPass CUTOUT_MIPPED_PASS;
    public static TerrainRenderPass TRANSLUCENT_PASS;
    public static Material SOLID_MATERIAL;
    public static Material CUTOUT_MIPPED_MATERIAL;
    public static Material TRANSLUCENT_MATERIAL;

    private static TerrainRenderPass.TerrainRenderPassBuilder builderForRenderType(int pass, boolean disableBlend) {
        return TerrainRenderPass.builder().pipelineState(new ArchaicPipelineState(pass, disableBlend)).vertexType(CompatibleChunkVertex.get()).primitiveType(QuadPrimitiveType.TRIANGULATED);
    }

    public static RenderPassConfiguration<Integer> build() {
        ImmutableListMultimap.Builder vanillaRenderStages = ImmutableListMultimap.builder();
        SOLID_PASS = ArchaicRenderPassConfigurationBuilder.builderForRenderType(0, true).name("solid").fragmentDiscard(false).useReverseOrder(false).build();
        CUTOUT_MIPPED_PASS = ArchaicRenderPassConfigurationBuilder.builderForRenderType(0, false).name("cutout_mipped").fragmentDiscard(true).useReverseOrder(false).build();
        TRANSLUCENT_PASS = ArchaicRenderPassConfigurationBuilder.builderForRenderType(1, false).name("translucent").fragmentDiscard(false).useReverseOrder(true).useTranslucencySorting(true).build();
        TRANSLUCENT_MATERIAL = new Material(TRANSLUCENT_PASS, AlphaCutoffParameter.ZERO, true);
        SOLID_MATERIAL = new Material(SOLID_PASS, AlphaCutoffParameter.ZERO, true);
        CUTOUT_MIPPED_MATERIAL = new Material(CUTOUT_MIPPED_PASS, AlphaCutoffParameter.ONE_TENTH, true);
        vanillaRenderStages.put((Object)1, (Object)TRANSLUCENT_PASS);
        vanillaRenderStages.put((Object)0, (Object)SOLID_PASS);
        vanillaRenderStages.put((Object)0, (Object)CUTOUT_MIPPED_PASS);
        Reference2ReferenceOpenHashMap renderTypeToMaterialMap = new Reference2ReferenceOpenHashMap(4, 0.25f);
        renderTypeToMaterialMap.put(0, CUTOUT_MIPPED_MATERIAL);
        renderTypeToMaterialMap.put(1, TRANSLUCENT_MATERIAL);
        ImmutableListMultimap vanillaRenderStageMap = vanillaRenderStages.build();
        return new RenderPassConfiguration<Integer>((Map<Integer, Material>)renderTypeToMaterialMap, (Map<Integer, Collection<TerrainRenderPass>>)vanillaRenderStageMap.asMap(), CUTOUT_MIPPED_MATERIAL, CUTOUT_MIPPED_MATERIAL, TRANSLUCENT_MATERIAL);
    }

    @RecordComponents(value={@RecordComponents.Value(name="pass", type=int.class), @RecordComponents.Value(name="disableBlend", type=boolean.class)})
    @NestHost(value=ArchaicRenderPassConfigurationBuilder.class)
    private static final class ArchaicPipelineState
    extends J_L_Record
    implements TerrainRenderPass.PipelineState {
        private final int pass;
        private final boolean disableBlend;

        ArchaicPipelineState(int pass, boolean disableBlend) {
            this.pass = pass;
            this.disableBlend = disableBlend;
        }

        @Override
        public void setup() {
            if (this.pass == 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
            if (this.disableBlend) {
                GL11.glDisable((int)3008);
            }
        }

        @Override
        public void clear() {
            if (this.disableBlend) {
                GL11.glEnable((int)3008);
            }
        }

        public final String toString() {
            return ArchaicPipelineState.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return ArchaicPipelineState.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return ArchaicPipelineState.jvmdowngrader$equals$equals(this, o);
        }

        public int pass() {
            return this.pass;
        }

        public boolean disableBlend() {
            return this.disableBlend;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(ArchaicPipelineState archaicPipelineState) {
            ArchaicPipelineState archaicPipelineState2 = archaicPipelineState;
            return "ArchaicRenderPassConfigurationBuilder$ArchaicPipelineState[" + "pass=" + archaicPipelineState.pass + ", " + "disableBlend=" + archaicPipelineState.disableBlend + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(ArchaicPipelineState archaicPipelineState) {
            Object[] objectArray = new Object[]{archaicPipelineState.pass, archaicPipelineState.disableBlend};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(ArchaicPipelineState archaicPipelineState, Object object) {
            if (archaicPipelineState == object) {
                return true;
            }
            if (object != null && object instanceof ArchaicPipelineState) {
                ArchaicPipelineState archaicPipelineState2 = (ArchaicPipelineState)object;
                if (archaicPipelineState.pass == archaicPipelineState2.pass && archaicPipelineState.disableBlend == archaicPipelineState2.disableBlend) {
                    return true;
                }
            }
            return false;
        }
    }
}

