/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.fog;

import com.ventooth.beddium.Share;
import com.ventooth.beddium.config.ModuleConfig;
import java.nio.FloatBuffer;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkFogMode;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class FogStateTracker {
    static final FloatBuffer color = BufferUtils.createFloatBuffer((int)16);
    public static float end = 1000.0f;
    public static float start = 1000.0f;
    static float density = 0.1f;
    static boolean isEnabled = false;
    @NotNull
    static ChunkFogMode mode = ChunkFogMode.NONE;

    private FogStateTracker() {
        throw new UnsupportedOperationException();
    }

    public static void setFromGl() {
        GL11.glGetFloat((int)2918, (FloatBuffer)color);
        isEnabled = GL11.glGetBoolean((int)2912);
        mode = FogStateTracker.fromGLMode(GL11.glGetInteger((int)2917));
        end = GL11.glGetInteger((int)2916);
        start = GL11.glGetInteger((int)2915);
        density = GL11.glGetInteger((int)2914);
    }

    public static void glFog(int pname, FloatBuffer params) {
        if (pname == 2918) {
            color.put(0, params.get(0));
            color.put(1, params.get(1));
            color.put(2, params.get(2));
            color.put(3, params.get(3));
        }
    }

    public static void glFogf(int pname, float param) {
        switch (pname) {
            case 2916: {
                end = param;
                break;
            }
            case 2915: {
                start = param;
                break;
            }
            case 2914: {
                density = param;
            }
        }
    }

    public static void glEnable(int cap) {
        if (cap == 2912) {
            isEnabled = true;
        }
    }

    public static void glDisable(int cap) {
        if (cap == 2912) {
            isEnabled = false;
        }
    }

    public static void glFogi(int pname, int param) {
        if (pname == 2917) {
            mode = FogStateTracker.fromGLMode(param);
        }
    }

    static ChunkFogMode fromGLMode(int glEnum) {
        try {
            return ChunkFogMode.fromGLMode(glEnum);
        }
        catch (RuntimeException e) {
            if (ModuleConfig.Debug) {
                Share.log.warn("Failed to set fog:", (Throwable)e);
            }
            return ChunkFogMode.NONE;
        }
    }
}

