/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.common.util;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class TimeUtil {
    private static final TimeUnit[] UNITS = TimeUnit.values();

    private static TimeUnit chooseUnit(long duration, TimeUnit unit) {
        for (int i = UNITS.length - 1; i > unit.ordinal(); --i) {
            if (UNITS[i].convert(duration, unit) <= 0L) continue;
            return UNITS[i];
        }
        return unit;
    }

    private static String abbreviateTime(TimeUnit unit) {
        String string;
        switch (unit) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NANOSECONDS: {
                string = "ns";
                break;
            }
            case MICROSECONDS: {
                string = "us";
                break;
            }
            case MILLISECONDS: {
                string = "ms";
                break;
            }
            case SECONDS: {
                string = "s";
                break;
            }
            case MINUTES: {
                string = "min";
                break;
            }
            case HOURS: {
                string = "h";
                break;
            }
            case DAYS: {
                string = "d";
            }
        }
        return string;
    }

    public static String stringifyTime(long duration, TimeUnit unit) {
        return TimeUtil.stringifyTime(duration, unit, TimeUtil.chooseUnit(duration, unit));
    }

    public static String stringifyTime(long duration, TimeUnit unit, TimeUnit displayUnit) {
        double displayDuration = (double)duration / (double)unit.convert(1L, displayUnit);
        return String.format(Locale.ROOT, "%.4g %s", displayDuration, TimeUtil.abbreviateTime(displayUnit));
    }
}

