/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.arena.staging;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.embeddedt.embeddium.impl.common.util.MathUtil;
import org.embeddedt.embeddium.impl.gl.arena.staging.FallbackStagingBuffer;
import org.embeddedt.embeddium.impl.gl.arena.staging.StagingBuffer;
import org.embeddedt.embeddium.impl.gl.buffer.GlBuffer;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferMapFlags;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferMapping;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferStorageFlags;
import org.embeddedt.embeddium.impl.gl.buffer.GlImmutableBuffer;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gl.functions.BufferStorageFunctions;
import org.embeddedt.embeddium.impl.gl.sync.GlFence;
import org.embeddedt.embeddium.impl.gl.util.EnumBitField;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j13.stub.java_base.J_N_Buffer;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

@NestMembers(value={FencedMemoryRegion.class, MappedBuffer.class, CopyCommand.class})
public class MappedStagingBuffer
implements StagingBuffer {
    private static final EnumBitField<GlBufferStorageFlags> STORAGE_FLAGS = EnumBitField.of((Enum[])new GlBufferStorageFlags[]{GlBufferStorageFlags.PERSISTENT, GlBufferStorageFlags.CLIENT_STORAGE, GlBufferStorageFlags.MAP_WRITE});
    private static final EnumBitField<GlBufferMapFlags> MAP_FLAGS = EnumBitField.of((Enum[])new GlBufferMapFlags[]{GlBufferMapFlags.PERSISTENT, GlBufferMapFlags.INVALIDATE_BUFFER, GlBufferMapFlags.WRITE, GlBufferMapFlags.EXPLICIT_FLUSH});
    private final FallbackStagingBuffer fallbackStagingBuffer;
    private final MappedBuffer mappedBuffer;
    private final List<CopyCommand> pendingCopies = new ArrayList<CopyCommand>();
    private final PriorityQueue<FencedMemoryRegion> fencedRegions = new ObjectArrayFIFOQueue();
    private int start = 0;
    private int pos = 0;
    private final int capacity;
    private int remaining;

    public MappedStagingBuffer(CommandList commandList) {
        this(commandList, 0x1000000);
    }

    public MappedStagingBuffer(CommandList commandList, int capacity) {
        GlImmutableBuffer buffer = commandList.createImmutableBuffer(capacity, STORAGE_FLAGS);
        GlBufferMapping map = commandList.mapBuffer(buffer, 0L, capacity, MAP_FLAGS);
        this.mappedBuffer = new MappedBuffer(buffer, map);
        this.fallbackStagingBuffer = new FallbackStagingBuffer(commandList);
        this.remaining = this.capacity = capacity;
    }

    public static boolean isSupported(RenderDevice instance) {
        return instance.getDeviceFunctions().bufferStorageFunctions() != BufferStorageFunctions.NONE;
    }

    @Override
    public void enqueueCopy(CommandList commandList, ByteBuffer data, GlBuffer dst, long writeOffset) {
        int length = data.remaining();
        if (length > this.remaining) {
            this.fallbackStagingBuffer.enqueueCopy(commandList, data, dst, writeOffset);
            return;
        }
        int remaining = this.capacity - this.pos;
        if (length > remaining) {
            int split = length - remaining;
            this.addTransfer((ByteBuffer)J_N_Buffer.slice((Buffer)data, (int)0, (int)remaining), dst, this.pos, writeOffset);
            this.addTransfer((ByteBuffer)J_N_Buffer.slice((Buffer)data, (int)remaining, (int)split), dst, 0L, writeOffset + (long)remaining);
            this.pos = split;
        } else {
            this.addTransfer(data, dst, this.pos, writeOffset);
            this.pos += length;
        }
        this.remaining -= length;
    }

    private void addTransfer(ByteBuffer data, GlBuffer dst, long readOffset, long writeOffset) {
        this.mappedBuffer.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$MappedBuffer$get$map().write(data, (int)readOffset);
        this.pendingCopies.add(new CopyCommand(dst, readOffset, writeOffset, data.remaining()));
    }

    @Override
    public void flush(CommandList commandList) {
        if (this.pendingCopies.isEmpty()) {
            return;
        }
        if (this.pos < this.start) {
            commandList.flushMappedRange(this.mappedBuffer.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$MappedBuffer$get$map(), this.start, this.capacity - this.start);
            commandList.flushMappedRange(this.mappedBuffer.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$MappedBuffer$get$map(), 0, this.pos);
        } else {
            commandList.flushMappedRange(this.mappedBuffer.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$MappedBuffer$get$map(), this.start, this.pos - this.start);
        }
        int bytes = 0;
        for (CopyCommand command : MappedStagingBuffer.consolidateCopies(this.pendingCopies)) {
            bytes = (int)((long)bytes + command.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$bytes());
            commandList.copyBufferSubData(this.mappedBuffer.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$MappedBuffer$get$buffer(), command.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$buffer(), command.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$readOffset(), command.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$writeOffset(), command.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$bytes());
        }
        this.fencedRegions.enqueue((Object)new FencedMemoryRegion(commandList.createFence(), bytes));
        this.start = this.pos;
    }

    private static List<CopyCommand> consolidateCopies(List<CopyCommand> queue) {
        ArrayList<CopyCommand> merged = new ArrayList<CopyCommand>();
        CopyCommand last = null;
        int numCommands = queue.size();
        for (int i = 0; i < numCommands; ++i) {
            CopyCommand command = queue.get(i);
            if (last != null && last.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$buffer() == command.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$buffer() && last.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$writeOffset() + last.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$bytes() == command.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$writeOffset() && last.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$readOffset() + last.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$bytes() == command.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$readOffset()) {
                CopyCommand copyCommand = last;
                copyCommand.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$set$bytes(copyCommand.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$bytes() + command.jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$bytes());
                continue;
            }
            last = new CopyCommand(command);
            merged.add(last);
        }
        queue.clear();
        return merged;
    }

    @Override
    public void delete(CommandList commandList) {
        this.mappedBuffer.delete(commandList);
        this.fallbackStagingBuffer.delete(commandList);
        this.pendingCopies.clear();
    }

    @Override
    public void flip() {
        FencedMemoryRegion region;
        GlFence fence;
        while (!this.fencedRegions.isEmpty() && (fence = (region = (FencedMemoryRegion)((Object)this.fencedRegions.first())).fence()).isCompleted()) {
            fence.delete();
            this.fencedRegions.dequeue();
            this.remaining += region.length();
        }
    }

    public String toString() {
        return J_L_String.formatted((String)"Mapped (%s/%s MiB)", (Object[])new Object[]{MathUtil.toMib(this.remaining), MathUtil.toMib(this.capacity)});
    }

    @RecordComponents(value={@RecordComponents.Value(name="buffer", type=GlImmutableBuffer.class), @RecordComponents.Value(name="map", type=GlBufferMapping.class)})
    @NestHost(value=MappedStagingBuffer.class)
    private static final class MappedBuffer
    extends J_L_Record {
        private final GlImmutableBuffer buffer;
        private final GlBufferMapping map;

        MappedBuffer(GlImmutableBuffer buffer, GlBufferMapping map) {
            this.buffer = buffer;
            this.map = map;
        }

        public void delete(CommandList commandList) {
            commandList.unmap(this.map);
            commandList.deleteBuffer(this.buffer);
        }

        public final String toString() {
            return MappedBuffer.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return MappedBuffer.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return MappedBuffer.jvmdowngrader$equals$equals(this, o);
        }

        public GlImmutableBuffer buffer() {
            return this.buffer;
        }

        public GlBufferMapping map() {
            return this.map;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(MappedBuffer mappedBuffer) {
            MappedBuffer mappedBuffer2 = mappedBuffer;
            return "MappedStagingBuffer$MappedBuffer[" + "buffer=" + mappedBuffer.buffer + ", " + "map=" + mappedBuffer.map + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(MappedBuffer mappedBuffer) {
            Object[] objectArray = new Object[]{mappedBuffer.buffer, mappedBuffer.map};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(MappedBuffer mappedBuffer, Object object) {
            if (mappedBuffer == object) {
                return true;
            }
            if (object != null && object instanceof MappedBuffer) {
                MappedBuffer mappedBuffer2 = (MappedBuffer)((Object)object);
                if (Objects.equals(mappedBuffer.buffer, mappedBuffer2.buffer) && Objects.equals(mappedBuffer.map, mappedBuffer2.map)) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ GlBufferMapping jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$MappedBuffer$get$map() {
            return this.map;
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$MappedBuffer$set$map(GlBufferMapping glBufferMapping) {
            this.map = glBufferMapping;
        }

        public /* synthetic */ GlImmutableBuffer jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$MappedBuffer$get$buffer() {
            return this.buffer;
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$MappedBuffer$set$buffer(GlImmutableBuffer glImmutableBuffer) {
            this.buffer = glImmutableBuffer;
        }
    }

    @NestHost(value=MappedStagingBuffer.class)
    private static final class CopyCommand {
        private final GlBuffer buffer;
        private final long readOffset;
        private final long writeOffset;
        private long bytes;

        CopyCommand(GlBuffer buffer, long readOffset, long writeOffset, long bytes) {
            this.buffer = buffer;
            this.readOffset = readOffset;
            this.writeOffset = writeOffset;
            this.bytes = bytes;
        }

        public CopyCommand(CopyCommand command) {
            this.buffer = command.buffer;
            this.writeOffset = command.writeOffset;
            this.readOffset = command.readOffset;
            this.bytes = command.bytes;
        }

        public /* synthetic */ long jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$readOffset() {
            return this.readOffset;
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$set$readOffset(long l) {
            this.readOffset = l;
        }

        public /* synthetic */ GlBuffer jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$buffer() {
            return this.buffer;
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$set$buffer(GlBuffer glBuffer) {
            this.buffer = glBuffer;
        }

        public /* synthetic */ long jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$writeOffset() {
            return this.writeOffset;
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$set$writeOffset(long l) {
            this.writeOffset = l;
        }

        public /* synthetic */ long jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$get$bytes() {
            return this.bytes;
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_arena_staging_MappedStagingBuffer$CopyCommand$set$bytes(long l) {
            this.bytes = l;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="fence", type=GlFence.class), @RecordComponents.Value(name="length", type=int.class)})
    @NestHost(value=MappedStagingBuffer.class)
    private static final class FencedMemoryRegion
    extends J_L_Record {
        private final GlFence fence;
        private final int length;

        FencedMemoryRegion(GlFence fence, int length) {
            this.fence = fence;
            this.length = length;
        }

        public final String toString() {
            return FencedMemoryRegion.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return FencedMemoryRegion.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return FencedMemoryRegion.jvmdowngrader$equals$equals(this, o);
        }

        public GlFence fence() {
            return this.fence;
        }

        public int length() {
            return this.length;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(FencedMemoryRegion fencedMemoryRegion) {
            FencedMemoryRegion fencedMemoryRegion2 = fencedMemoryRegion;
            return "MappedStagingBuffer$FencedMemoryRegion[" + "fence=" + fencedMemoryRegion.fence + ", " + "length=" + fencedMemoryRegion.length + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(FencedMemoryRegion fencedMemoryRegion) {
            Object[] objectArray = new Object[]{fencedMemoryRegion.fence, fencedMemoryRegion.length};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(FencedMemoryRegion fencedMemoryRegion, Object object) {
            if (fencedMemoryRegion == object) {
                return true;
            }
            if (object != null && object instanceof FencedMemoryRegion) {
                FencedMemoryRegion fencedMemoryRegion2 = (FencedMemoryRegion)((Object)object);
                if (Objects.equals(fencedMemoryRegion.fence, fencedMemoryRegion2.fence) && fencedMemoryRegion.length == fencedMemoryRegion2.length) {
                    return true;
                }
            }
            return false;
        }
    }
}

