/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.functions;

import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.lwjgl2.MemoryUtil;
import org.embeddedt.embeddium.impl.lwjgl2.Pointer;
import org.lwjgl.opengl.ARBDrawElementsBaseVertex;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL32;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j17.PermittedSubClasses;

@PermittedSubClasses(value={1.class, 2.class, 3.class})
@NestMembers(value={3.class, 2.class, 1.class})
public enum MultidrawFunctions {
    NONE{

        @Override
        public void multiDrawElementsBaseVertex(int mode, long pCount, int type, long pIndices, int size, long pBaseVertex) {
            throw new UnsupportedOperationException("Platform does not support DrawElementsBaseVertex");
        }
    }
    ,
    FALLBACK{

        @Override
        public void multiDrawElementsBaseVertex(int mode, long pCount, int type, long pIndices, int size, long pBaseVertex) {
            for (int i = 0; i < size; ++i) {
                long off = (long)i * 4L;
                int count = MemoryUtil.memGetInt(pCount + off);
                if (count <= 0) continue;
                ARBDrawElementsBaseVertex.glDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)MemoryUtil.memGetAddress(pIndices + (long)i * (long)Pointer.POINTER_SIZE), (int)MemoryUtil.memGetInt(pBaseVertex + off));
            }
        }
    }
    ,
    CORE{

        @Override
        public void multiDrawElementsBaseVertex(int mode, long pCount, int type, long pIndices, int size, long pBaseVertex) {
            for (int i = 0; i < size; ++i) {
                long off = (long)i * 4L;
                int count = MemoryUtil.memGetInt(pCount + off);
                if (count <= 0) continue;
                GL32.glDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)MemoryUtil.memGetAddress(pIndices + (long)i * (long)Pointer.POINTER_SIZE), (int)MemoryUtil.memGetInt(pBaseVertex + off));
            }
        }
    };


    public static MultidrawFunctions pickBest(RenderDevice device) {
        ContextCapabilities capabilities = device.getCapabilities();
        if (capabilities.OpenGL32) {
            return CORE;
        }
        if (capabilities.GL_ARB_draw_elements_base_vertex) {
            return FALLBACK;
        }
        return NONE;
    }

    public abstract void multiDrawElementsBaseVertex(int var1, long var2, int var4, long var5, int var7, long var8);
}

