/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.profiling;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.io.Closeable;
import java.util.Arrays;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL33;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

@NestMembers(value={InFlightQuery.class})
public class TimerQueryManager
implements Closeable {
    private static final int INVALID_ID = -1;
    private static final int QUERY_FRAME_LAG_COUNT = 3;
    private final ObjectArrayFIFOQueue<InFlightQuery> inFlightQueries = new ObjectArrayFIFOQueue();
    private int startQueryId = -1;
    private static final IntArrayFIFOQueue QUERY_POOL = new IntArrayFIFOQueue();
    private long lastTime;

    private static int allocateQuery() {
        if (!QUERY_POOL.isEmpty()) {
            return QUERY_POOL.dequeueInt();
        }
        return GL15.glGenQueries();
    }

    private static void releaseQuery(int id) {
        QUERY_POOL.enqueue(id);
    }

    public void startProfiling() {
        if (this.startQueryId != -1) {
            throw new IllegalStateException("Query already started but not ended");
        }
        int id = TimerQueryManager.allocateQuery();
        GL33.glQueryCounter((int)id, (int)36392);
        this.startQueryId = id;
    }

    public void finishProfiling() {
        if (this.startQueryId == -1) {
            throw new IllegalStateException("Trying to end query that hasn't started yet");
        }
        int id = TimerQueryManager.allocateQuery();
        GL33.glQueryCounter((int)id, (int)36392);
        this.inFlightQueries.enqueue((Object)new InFlightQuery(this.startQueryId, id));
        this.startQueryId = -1;
    }

    public void updateTime() {
        if (this.inFlightQueries.size() < 3) {
            return;
        }
        InFlightQuery query = (InFlightQuery)((Object)this.inFlightQueries.dequeue());
        this.lastTime = query.getTimeDelta();
        query.delete();
    }

    @Override
    public void close() {
        while (!this.inFlightQueries.isEmpty()) {
            ((InFlightQuery)((Object)this.inFlightQueries.dequeue())).delete();
        }
        if (this.startQueryId != -1) {
            TimerQueryManager.releaseQuery(this.startQueryId);
            this.startQueryId = -1;
        }
    }

    public long getLastTime() {
        return this.lastTime;
    }

    @RecordComponents(value={@RecordComponents.Value(name="startTime", type=int.class), @RecordComponents.Value(name="endTime", type=int.class)})
    @NestHost(value=TimerQueryManager.class)
    private static final class InFlightQuery
    extends J_L_Record {
        private final int startTime;
        private final int endTime;

        InFlightQuery(int startTime, int endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        long getTimeDelta() {
            long startTime = GL33.glGetQueryObjectui64((int)this.startTime, (int)34918);
            long endTime = GL33.glGetQueryObjectui64((int)this.endTime, (int)34918);
            return endTime - startTime;
        }

        void delete() {
            TimerQueryManager.releaseQuery(this.startTime);
            TimerQueryManager.releaseQuery(this.endTime);
        }

        public final String toString() {
            return InFlightQuery.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return InFlightQuery.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return InFlightQuery.jvmdowngrader$equals$equals(this, o);
        }

        public int startTime() {
            return this.startTime;
        }

        public int endTime() {
            return this.endTime;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(InFlightQuery inFlightQuery) {
            InFlightQuery inFlightQuery2 = inFlightQuery;
            return "TimerQueryManager$InFlightQuery[" + "startTime=" + inFlightQuery.startTime + ", " + "endTime=" + inFlightQuery.endTime + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(InFlightQuery inFlightQuery) {
            Object[] objectArray = new Object[]{inFlightQuery.startTime, inFlightQuery.endTime};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(InFlightQuery inFlightQuery, Object object) {
            if (inFlightQuery == object) {
                return true;
            }
            if (object != null && object instanceof InFlightQuery) {
                InFlightQuery inFlightQuery2 = (InFlightQuery)((Object)object);
                if (inFlightQuery.startTime == inFlightQuery2.startTime && inFlightQuery.endTime == inFlightQuery2.endTime) {
                    return true;
                }
            }
            return false;
        }
    }
}

