/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.shader;

import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.embeddedt.embeddium.impl.gl.debug.GLDebug;
import org.embeddedt.embeddium.impl.gl.shader.GlShader;
import org.embeddedt.embeddium.impl.gl.shader.ShaderBindingContext;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniform;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniformBlock;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Builder.class})
public class GlProgram<T>
extends GlObject
implements ShaderBindingContext {
    private static final Logger LOGGER = LogManager.getLogger(GlProgram.class);
    private final T shaderInterface;

    protected GlProgram(int program, Function<ShaderBindingContext, T> interfaceFactory) {
        this.setHandle(program);
        this.shaderInterface = interfaceFactory.apply(this);
    }

    public T getInterface() {
        return this.shaderInterface;
    }

    public static Builder builder(String identifier) {
        return new Builder(identifier);
    }

    public void bind() {
        GL20.glUseProgram((int)this.handle());
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    @Override
    protected void destroyInternal() {
        GL20.glDeleteProgram((int)this.handle());
    }

    @Override
    @Nullable
    public <U extends GlUniform<?>> U bindUniformIfPresent(String name, IntFunction<U> factory) {
        int index = GL20.glGetUniformLocation((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            return null;
        }
        return (U)((GlUniform)factory.apply(index));
    }

    @Override
    @Nullable
    public GlUniformBlock bindUniformBlockIfPresent(String name, int bindingPoint) {
        int index = GL31.glGetUniformBlockIndex((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            return null;
        }
        GL31.glUniformBlockBinding((int)this.handle(), (int)index, (int)bindingPoint);
        return new GlUniformBlock(bindingPoint);
    }

    public static /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_gl_shader_GlProgram$set$LOGGER(Logger logger) {
        LOGGER = logger;
    }

    @NestHost(value=GlProgram.class)
    public static class Builder {
        private final String name;
        private final int program;

        public Builder(String name) {
            this.name = name;
            this.program = GL20.glCreateProgram();
        }

        public Builder attachShader(GlShader shader) {
            GL20.glAttachShader((int)this.program, (int)shader.handle());
            return this;
        }

        public <U> GlProgram<U> link(Function<ShaderBindingContext, U> factory) {
            int result;
            GL20.glLinkProgram((int)this.program);
            String log = GL20.glGetProgramInfoLog((int)this.program, (int)4096);
            if (!log.isEmpty()) {
                LOGGER.warn(Builder.jvmdowngrader$concat$link$1(this.name, log));
            }
            if ((result = GL20.glGetProgrami((int)this.program, (int)35714)) != 1) {
                throw new RuntimeException("Shader program linking failed, see log for details");
            }
            GLDebug.nameObject(33506, this.program, this.name);
            return new GlProgram<U>(this.program, factory);
        }

        public Builder bindAttribute(String name, int index) {
            GL20.glBindAttribLocation((int)this.program, (int)index, (CharSequence)name);
            return this;
        }

        public Builder bindFragmentData(String name, int index) {
            GL30.glBindFragDataLocation((int)this.program, (int)index, (CharSequence)name);
            return this;
        }

        private static /* synthetic */ String jvmdowngrader$concat$link$1(String string, String string2) {
            return "Program link log for " + string + ": " + string2;
        }
    }
}

