/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.shader;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.embeddedt.embeddium.impl.gl.debug.GLDebug;
import org.embeddedt.embeddium.impl.gl.shader.ShaderType;
import org.embeddedt.embeddium.impl.gl.shader.ShaderWorkarounds;
import org.lwjgl.opengl.GL20;

public class GlShader
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final String name;

    public GlShader(ShaderType type, String name, String src) {
        int result;
        this.name = name;
        int handle = GL20.glCreateShader((int)type.id);
        ShaderWorkarounds.safeShaderSource(handle, src);
        GL20.glCompileShader((int)handle);
        String log = GL20.glGetShaderInfoLog((int)handle, (int)4096);
        if (!log.isEmpty()) {
            LOGGER.warn(GlShader.jvmdowngrader$concat$$init$$1(this.name, log));
        }
        if ((result = GL20.glGetShaderi((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        this.setHandle(handle);
        GLDebug.nameObject(33505, handle, name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void destroyInternal() {
        GL20.glDeleteShader((int)this.handle());
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string, String string2) {
        return "Shader compilation log for " + string + ": " + string2;
    }
}

