/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.shader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.embeddedt.embeddium.impl.gl.shader.ShaderConstants;

public class ShaderParser {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("#import <(?<namespace>.*):(?<path>.*)>");

    public static String parseShader(String src, Function<String, String> sourceProvider, ShaderConstants constants) {
        List<String> lines = ShaderParser.parseShader(src, sourceProvider);
        lines.addAll(1, constants.getDefineStrings());
        return String.join((CharSequence)"\n", lines);
    }

    public static List<String> parseShader(String src, Function<String, String> sourceProvider) {
        LinkedList<String> builder = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(src));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#import")) {
                    builder.addAll(ShaderParser.resolveImport(line, sourceProvider));
                    continue;
                }
                builder.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read shader sources", e);
        }
        return builder;
    }

    private static List<String> resolveImport(String line, Function<String, String> sourceProvider) {
        Matcher matcher = IMPORT_PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(ShaderParser.jvmdowngrader$concat$resolveImport$1(String.valueOf(IMPORT_PATTERN)));
        }
        String namespace = matcher.group("namespace");
        String path = matcher.group("path");
        String source = sourceProvider.apply(ShaderParser.jvmdowngrader$concat$resolveImport$1(namespace, path));
        return ShaderParser.parseShader(source, sourceProvider);
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolveImport$1(String string) {
        return "Malformed import statement (expected format: " + string + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolveImport$1(String string, String string2) {
        return string + ":" + string2;
    }
}

