/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.embeddedt.embeddium.impl.gui.frame.AbstractFrame;
import org.embeddedt.embeddium.impl.gui.frame.BasicFrame;
import org.embeddedt.embeddium.impl.gui.frame.tab.Tab;
import org.embeddedt.embeddium.impl.gui.frame.tab.TabFrame;
import org.embeddedt.embeddium.impl.gui.framework.DrawContext;
import org.embeddedt.embeddium.impl.gui.framework.Renderable;
import org.embeddedt.embeddium.impl.gui.framework.TextComponent;
import org.embeddedt.embeddium.impl.gui.widgets.FlatButtonWidget;
import org.embeddedt.embeddium.impl.util.Dim2i;
import org.taumc.celeritas.api.OptionGUIConstructionEvent;
import org.taumc.celeritas.api.options.structure.Option;
import org.taumc.celeritas.api.options.structure.OptionFlag;
import org.taumc.celeritas.api.options.structure.OptionPage;
import org.taumc.celeritas.api.options.structure.OptionStorage;

public class CeleritasVideoOptionsController
implements Renderable {
    private static final float ASPECT_RATIO = 1.25f;
    private static final int MINIMUM_WIDTH = 550;
    private static final AtomicReference<TextComponent> tabFrameSelectedTab = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> tabFrameScrollBarOffset = new AtomicReference<Integer>(0);
    private final AtomicReference<Integer> optionPageScrollBarOffset = new AtomicReference<Integer>(0);
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private final Runnable onClose;
    private final DrawContext font;
    private AbstractFrame frame;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private boolean hasPendingChanges;
    private boolean firstInit = true;
    private int width;
    private int height;

    public CeleritasVideoOptionsController(Runnable onClose, List<OptionPage> pages, DrawContext font) {
        this.onClose = onClose;
        this.pages.addAll(pages);
        OptionGUIConstructionEvent.BUS.post(new OptionGUIConstructionEvent(this.pages));
        this.font = font;
    }

    public void init(int width, int height) {
        this.width = width;
        this.height = height;
        this.frame = this.parentFrameBuilder().build();
    }

    protected BasicFrame.Builder parentFrameBuilder() {
        int newWidth = this.width;
        if (newWidth > 550 && (float)this.width / (float)this.height > 1.25f) {
            newWidth = Math.max(550, (int)((float)this.height * 1.25f));
        }
        Dim2i basicFrameDim = new Dim2i((this.width - newWidth) / 2, 0, newWidth, this.height);
        Dim2i tabFrameDim = new Dim2i(basicFrameDim.x() + basicFrameDim.width() / 20 / 2, basicFrameDim.y() + basicFrameDim.height() / 4 / 2, basicFrameDim.width() - basicFrameDim.width() / 20, basicFrameDim.height() / 4 * 3);
        Dim2i undoButtonDim = new Dim2i(tabFrameDim.getLimitX() - 203, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i applyButtonDim = new Dim2i(tabFrameDim.getLimitX() - 134, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i closeButtonDim = new Dim2i(tabFrameDim.getLimitX() - 65, tabFrameDim.getLimitY() + 5, 65, 20);
        this.undoButton = new FlatButtonWidget(undoButtonDim, TextComponent.translatable("sodium.options.buttons.undo", new Object[0]), this::undoChanges);
        this.applyButton = new FlatButtonWidget(applyButtonDim, TextComponent.translatable("sodium.options.buttons.apply", new Object[0]), this::applyChanges);
        this.closeButton = new FlatButtonWidget(closeButtonDim, TextComponent.translatable("gui.done", new Object[0]), this.onClose);
        BasicFrame.Builder basicFrameBuilder = this.parentBasicFrameBuilder(basicFrameDim, tabFrameDim);
        return basicFrameBuilder;
    }

    @Override
    public void render(DrawContext drawContext, int mouseX, int mouseY, float partialTicks) {
        this.updateControls();
        this.frame.render(drawContext, mouseX, mouseY, partialTicks);
    }

    private void updateControls() {
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        for (OptionStorage storage : dirtyStorages) {
            storage.save(flags);
        }
        this.applyFlagSideEffects(Collections.unmodifiableSet(flags));
    }

    protected void applyFlagSideEffects(Set<OptionFlag> flags) {
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    private boolean canShowPage(OptionPage page) {
        return !page.getGroups().isEmpty();
    }

    protected void createExtraTabs(Map<String, List<Tab<?>>> tabs) {
    }

    private AbstractFrame createTabFrame(Dim2i tabFrameDim) {
        return TabFrame.createBuilder().setDimension(tabFrameDim).shouldRenderOutline(false).setTabSectionScrollBarOffset(this.tabFrameScrollBarOffset).setTabSectionSelectedTab(tabFrameSelectedTab).addTabs(tabs -> this.pages.stream().filter(this::canShowPage).forEach(page -> tabs.computeIfAbsent(page.getId().getModId(), $ -> new ArrayList()).add(Tab.from(page, o -> true, this.optionPageScrollBarOffset)))).addTabs(this::createExtraTabs).onSetTab(() -> this.optionPageScrollBarOffset.set(0)).build(this.font);
    }

    public BasicFrame.Builder parentBasicFrameBuilder(Dim2i parentBasicFrameDim, Dim2i tabFrameDim) {
        return BasicFrame.createBuilder().setDimension(parentBasicFrameDim).shouldRenderOutline(false).addChild(parentDim -> this.createTabFrame(tabFrameDim)).addChild(dim -> this.undoButton).addChild(dim -> this.applyButton).addChild(dim -> this.closeButton);
    }

    public AbstractFrame getFrame() {
        return this.frame;
    }

    public boolean isHasPendingChanges() {
        return this.hasPendingChanges;
    }
}

