/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.executor;

import java.util.function.Consumer;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkBuilder;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJob;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobResult;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

public class ChunkJobTyped<TASK extends ChunkBuilderTask<OUTPUT>, OUTPUT>
implements ChunkJob {
    private final TASK task;
    private final Consumer<ChunkJobResult<OUTPUT>> consumer;
    private volatile boolean cancelled;
    private volatile boolean started;

    ChunkJobTyped(TASK task, Consumer<ChunkJobResult<OUTPUT>> consumer) {
        this.task = task;
        this.consumer = consumer;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled() {
        this.cancelled = true;
    }

    @Override
    public void execute(ChunkBuildContext context) {
        J_L_Record result;
        if (this.cancelled) {
            return;
        }
        this.started = true;
        long startTime = System.nanoTime();
        try {
            Object output = ((ChunkBuilderTask)this.task).execute(context, this);
            if (output == null) {
                return;
            }
            result = new ChunkJobResult.Success(output, System.nanoTime() - startTime);
        }
        catch (Throwable throwable) {
            result = new ChunkJobResult.Failure(throwable);
            ChunkBuilder.LOGGER.error("Chunk build failed", throwable);
        }
        try {
            this.consumer.accept((ChunkJobResult<OUTPUT>)result);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Exception while consuming result", throwable);
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }
}

