/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.lists;

import org.embeddedt.embeddium.impl.render.chunk.LocalSectionIndex;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.util.iterator.ByteArrayIterator;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;
import org.embeddedt.embeddium.impl.util.iterator.ReversibleByteArrayIterator;
import org.jetbrains.annotations.Nullable;

public class ChunkRenderList {
    private final RenderRegion region;
    private final byte[] sectionsWithGeometry = new byte[256];
    private int sectionsWithGeometryCount = 0;
    private final byte[] sectionsWithSprites = new byte[256];
    private int sectionsWithSpritesCount = 0;
    private final byte[] sectionsWithEntities = new byte[256];
    private int sectionsWithEntitiesCount = 0;
    private int size;

    public ChunkRenderList(RenderRegion region) {
        this.region = region;
    }

    public void add(RenderSection render) {
        if (this.size >= 256) {
            throw new ArrayIndexOutOfBoundsException("Render list is full");
        }
        ++this.size;
        int index = render.getSectionIndex();
        int flags = render.getVisualsServiceFlags();
        this.sectionsWithGeometry[this.sectionsWithGeometryCount] = (byte)index;
        this.sectionsWithGeometryCount += flags >>> 0 & 1;
        this.sectionsWithSprites[this.sectionsWithSpritesCount] = (byte)index;
        this.sectionsWithSpritesCount += flags >>> 1 & 1;
        this.sectionsWithEntities[this.sectionsWithEntitiesCount] = (byte)index;
        this.sectionsWithEntitiesCount += flags >>> 2 & 1;
    }

    @Nullable
    public ByteIterator sectionsWithGeometryIterator(boolean reverse) {
        if (this.sectionsWithGeometryCount == 0) {
            return null;
        }
        return new ReversibleByteArrayIterator(this.sectionsWithGeometry, this.sectionsWithGeometryCount, reverse);
    }

    @Nullable
    public ByteIterator sectionsWithSpritesIterator() {
        if (this.sectionsWithSpritesCount == 0) {
            return null;
        }
        return new ByteArrayIterator(this.sectionsWithSprites, this.sectionsWithSpritesCount);
    }

    @Nullable
    public ByteIterator sectionsWithEntitiesIterator() {
        if (this.sectionsWithEntitiesCount == 0) {
            return null;
        }
        return new ByteArrayIterator(this.sectionsWithEntities, this.sectionsWithEntitiesCount);
    }

    public int getSectionsWithGeometryCount() {
        return this.sectionsWithGeometryCount;
    }

    public int getSectionsWithSpritesCount() {
        return this.sectionsWithSpritesCount;
    }

    public int getSectionsWithEntitiesCount() {
        return this.sectionsWithEntitiesCount;
    }

    public RenderRegion getRegion() {
        return this.region;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        ByteIterator iterator = this.sectionsWithGeometryIterator(false);
        if (iterator == null) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        int originX = this.region.getChunkX();
        int originY = this.region.getChunkY();
        int originZ = this.region.getChunkZ();
        while (iterator.hasNext()) {
            int sectionIndex = iterator.nextByteAsInt();
            int chunkX = originX + LocalSectionIndex.unpackX(sectionIndex);
            int chunkY = originY + LocalSectionIndex.unpackY(sectionIndex);
            int chunkZ = originZ + LocalSectionIndex.unpackZ(sectionIndex);
            sb.append("(").append(chunkX).append(", ").append(chunkY).append(", ").append(chunkZ).append(")");
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

