/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.region;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.embeddedt.embeddium.impl.common.util.MathUtil;
import org.embeddedt.embeddium.impl.gl.arena.GlBufferArena;
import org.embeddedt.embeddium.impl.gl.arena.staging.StagingBuffer;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.gl.buffer.GlBuffer;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.tessellation.GlTessellation;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataStorage;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.util.PositionUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_List;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={DeviceResources.class})
public class RenderRegion {
    public static final int REGION_WIDTH = 8;
    public static final int REGION_HEIGHT = 4;
    public static final int REGION_LENGTH = 8;
    private static final int REGION_WIDTH_M = 7;
    private static final int REGION_HEIGHT_M = 3;
    private static final int REGION_LENGTH_M = 7;
    protected static final int REGION_WIDTH_SH = Integer.bitCount(7);
    protected static final int REGION_HEIGHT_SH = Integer.bitCount(3);
    protected static final int REGION_LENGTH_SH = Integer.bitCount(7);
    public static final int REGION_SIZE = 256;
    private final StagingBuffer stagingBuffer;
    private final int x;
    private final int y;
    private final int z;
    private final int id;
    private final RenderSection[] sections = new RenderSection[256];
    private final long[] sectionLoadTimes = new long[256];
    private long newestSectionLoadTime;
    private int sectionCount;
    private final Map<TerrainRenderPass, SectionRenderDataStorage> sectionRenderData = new Reference2ReferenceOpenHashMap();
    private @Unmodifiable List<DeviceResources> allDeviceResources = xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List.of();
    private int passSetUpdateCount = 0;

    RenderRegion(int x, int y, int z, int id, StagingBuffer stagingBuffer) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.id = id;
        this.stagingBuffer = stagingBuffer;
    }

    public static long key(int x, int y, int z) {
        return PositionUtil.packSection(x, y, z);
    }

    public int getChunkX() {
        return this.x << REGION_WIDTH_SH;
    }

    public int getChunkY() {
        return this.y << REGION_HEIGHT_SH;
    }

    public int getChunkZ() {
        return this.z << REGION_LENGTH_SH;
    }

    public int getOriginX() {
        return this.getChunkX() << 4;
    }

    public int getOriginY() {
        return this.getChunkY() << 4;
    }

    public int getOriginZ() {
        return this.getChunkZ() << 4;
    }

    public int getCenterX() {
        return this.getChunkX() + 4 << 4;
    }

    public int getCenterY() {
        return this.getChunkY() + 2 << 4;
    }

    public int getCenterZ() {
        return this.getChunkZ() + 4 << 4;
    }

    public void delete(CommandList commandList) {
        for (SectionRenderDataStorage storage : this.sectionRenderData.values()) {
            storage.delete();
        }
        this.sectionRenderData.clear();
        this.allDeviceResources.forEach(resources -> resources.delete(commandList));
        this.allDeviceResources = xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List.of();
        Arrays.fill(this.sections, null);
        Arrays.fill(this.sectionLoadTimes, 0L);
    }

    public boolean isEmpty() {
        return this.sectionCount == 0;
    }

    public SectionRenderDataStorage getStorage(TerrainRenderPass pass) {
        return this.sectionRenderData.get(pass);
    }

    public SectionRenderDataStorage createStorage(TerrainRenderPass pass, RenderPassConfiguration<?> renderPassConfiguration) {
        SectionRenderDataStorage storage = this.sectionRenderData.get(pass);
        if (storage == null) {
            storage = new SectionRenderDataStorage(renderPassConfiguration.getPrimitiveTypeForPass(pass));
            this.sectionRenderData.put(pass, storage);
            ++this.passSetUpdateCount;
        }
        return storage;
    }

    public void removeEmptyStorages() {
        if (this.sectionRenderData.isEmpty()) {
            return;
        }
        boolean anyRemoved = this.sectionRenderData.values().removeIf(s -> {
            if (s.isEmpty()) {
                s.delete();
                return true;
            }
            return false;
        });
        if (anyRemoved) {
            ++this.passSetUpdateCount;
        }
    }

    public void removeMeshes(int sectionIndex) {
        if (this.sectionRenderData.isEmpty()) {
            return;
        }
        for (SectionRenderDataStorage storage : this.sectionRenderData.values()) {
            storage.removeMeshes(sectionIndex);
        }
    }

    public boolean hasSectionsInPass(TerrainRenderPass pass) {
        return this.sectionRenderData.containsKey(pass);
    }

    public Set<TerrainRenderPass> getPasses() {
        return this.sectionRenderData.keySet();
    }

    public void refresh(CommandList commandList) {
        this.allDeviceResources.forEach(resources -> resources.deleteTessellations(commandList));
        for (SectionRenderDataStorage storage : this.sectionRenderData.values()) {
            storage.onBufferResized();
        }
    }

    public void addSection(RenderSection section) {
        int sectionIndex = section.getSectionIndex();
        RenderSection prev = this.sections[sectionIndex];
        if (prev != null) {
            throw new IllegalStateException("Section has already been added to the region");
        }
        this.sections[sectionIndex] = section;
        this.sectionLoadTimes[sectionIndex] = 0L;
        ++this.sectionCount;
    }

    public void removeSection(RenderSection section) {
        int sectionIndex = section.getSectionIndex();
        RenderSection prev = this.sections[sectionIndex];
        if (prev == null) {
            throw new IllegalStateException("Section was not loaded within the region");
        }
        if (prev != section) {
            throw new IllegalStateException("Tried to remove the wrong section");
        }
        for (SectionRenderDataStorage storage : this.sectionRenderData.values()) {
            storage.removeMeshes(sectionIndex);
        }
        this.sections[sectionIndex] = null;
        this.sectionLoadTimes[sectionIndex] = 0L;
        --this.sectionCount;
    }

    public void updateSectionLoadTime(RenderSection section) {
        long timestamp;
        this.sectionLoadTimes[section.getSectionIndex()] = timestamp = System.nanoTime();
        this.newestSectionLoadTime = timestamp;
    }

    @Nullable
    public RenderSection getSection(int id) {
        return this.sections[id];
    }

    public Collection<DeviceResources> getAllResources() {
        return this.allDeviceResources;
    }

    public DeviceResources getResources(GlVertexFormat format) {
        int stride = format.getStride();
        List<DeviceResources> list = this.allDeviceResources;
        for (int i = 0; i < list.size(); ++i) {
            DeviceResources resources = list.get(i);
            if (resources.jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_region_RenderRegion$DeviceResources$get$stride() != stride) continue;
            return resources;
        }
        return null;
    }

    public DeviceResources createResources(GlVertexFormat format, CommandList commandList) {
        DeviceResources resources = this.getResources(format);
        if (resources == null) {
            resources = new DeviceResources(commandList, this.stagingBuffer, format.getStride());
            ArrayList<DeviceResources> newList = new ArrayList<DeviceResources>(this.allDeviceResources);
            newList.add(resources);
            this.allDeviceResources = J_U_List.copyOf(newList);
        }
        return resources;
    }

    public void update(CommandList commandList) {
        List<DeviceResources> oldList = this.allDeviceResources;
        boolean needListUpdate = false;
        for (int i = 0; i < oldList.size(); ++i) {
            DeviceResources resources = oldList.get(i);
            if (resources.shouldDelete()) {
                resources.delete(commandList);
                needListUpdate = true;
                continue;
            }
            resources.deleteIndexArenaIfPossible(commandList);
        }
        if (needListUpdate) {
            ArrayList<DeviceResources> newList = new ArrayList<DeviceResources>(this.allDeviceResources);
            newList.removeIf(DeviceResources::isDeleted);
            this.allDeviceResources = J_U_List.copyOf(newList);
        }
    }

    public int getId() {
        return this.id;
    }

    public long[] getSectionLoadTimes() {
        return this.sectionLoadTimes;
    }

    public long getNewestSectionLoadTime() {
        return this.newestSectionLoadTime;
    }

    public int getPassSetUpdateCount() {
        return this.passSetUpdateCount;
    }

    static {
        if (!(MathUtil.isPowerOfTwo(8) && MathUtil.isPowerOfTwo(4) && MathUtil.isPowerOfTwo(8))) {
            throw new IllegalStateException("Region width/height/length are not powers of two");
        }
    }

    @NestHost(value=RenderRegion.class)
    public static class DeviceResources {
        private final GlBufferArena geometryArena;
        private final StagingBuffer stagingBuffer;
        private final int stride;
        private GlBufferArena indexArena;
        private GlTessellation tessellation;
        private GlTessellation indexedTessellation;

        public DeviceResources(CommandList commandList, StagingBuffer stagingBuffer, int stride) {
            this.geometryArena = new GlBufferArena(commandList, 193536, stride, stagingBuffer);
            this.stagingBuffer = stagingBuffer;
            this.stride = stride;
        }

        public void updateTessellation(CommandList commandList, GlTessellation tessellation) {
            if (this.tessellation != null) {
                this.tessellation.delete(commandList);
            }
            this.tessellation = tessellation;
        }

        public GlTessellation getTessellation() {
            return this.tessellation;
        }

        public void updateIndexedTessellation(CommandList commandList, GlTessellation tessellation) {
            if (this.indexedTessellation != null) {
                this.indexedTessellation.delete(commandList);
            }
            this.indexedTessellation = tessellation;
        }

        public GlTessellation getIndexedTessellation() {
            return this.indexedTessellation;
        }

        public void deleteTessellations(CommandList commandList) {
            if (this.tessellation != null) {
                this.tessellation.delete(commandList);
                this.tessellation = null;
            }
            if (this.indexedTessellation != null) {
                this.indexedTessellation.delete(commandList);
                this.indexedTessellation = null;
            }
        }

        public GlBuffer getVertexBuffer() {
            return this.geometryArena.getBufferObject();
        }

        public GlBuffer getIndexBuffer() {
            if (this.indexArena == null) {
                throw new IllegalStateException("Attempted to retrieve index buffer for a non-indexed region");
            }
            return this.indexArena.getBufferObject();
        }

        public void delete(CommandList commandList) {
            this.deleteTessellations(commandList);
            this.geometryArena.delete(commandList);
            if (this.indexArena != null) {
                this.indexArena.delete(commandList);
            }
        }

        public boolean isDeleted() {
            return this.geometryArena.isDeleted();
        }

        public GlBufferArena getGeometryArena() {
            return this.geometryArena;
        }

        public GlBufferArena getIndexArena() {
            return this.indexArena;
        }

        public GlBufferArena getOrCreateIndexArena(CommandList commandList) {
            if (this.indexArena == null) {
                this.indexArena = new GlBufferArena(commandList, 48384, 4, this.stagingBuffer);
            }
            return this.indexArena;
        }

        public boolean shouldDelete() {
            return this.geometryArena.isEmpty();
        }

        public void deleteIndexArenaIfPossible(CommandList commandList) {
            if (this.indexArena != null && this.indexArena.isEmpty()) {
                this.updateIndexedTessellation(commandList, null);
                this.indexArena.delete(commandList);
                this.indexArena = null;
            }
        }

        public /* synthetic */ int jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_region_RenderRegion$DeviceResources$get$stride() {
            return this.stride;
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_region_RenderRegion$DeviceResources$set$stride(int n) {
            this.stride = n;
        }
    }
}

