/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.shader;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.embeddedt.embeddium.impl.gl.shader.ShaderConstants;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.ChunkPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderComponent;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

@RecordComponents(value={@RecordComponents.Value(name="components", type=List.class), @RecordComponents.Value(name="pass", type=TerrainRenderPass.class)})
public final class ChunkShaderOptions
extends J_L_Record {
    private final List<ChunkShaderComponent.Factory<?>> components;
    private final TerrainRenderPass pass;

    public ChunkShaderOptions(List<ChunkShaderComponent.Factory<?>> components, TerrainRenderPass pass) {
        this.components = components;
        this.pass = pass;
    }

    public ShaderConstants constants() {
        ShaderConstants.Builder constants = ShaderConstants.builder();
        for (ChunkShaderComponent.Factory<?> component : this.components) {
            constants.addAll(component.getDefines());
        }
        if (this.pass.supportsFragmentDiscard()) {
            constants.add("USE_FRAGMENT_DISCARD");
        }
        if (this.pass.hasNoLightmap()) {
            constants.add("CELERITAS_NO_LIGHTMAP");
        }
        constants.addAll(this.pass.extraDefines());
        ChunkVertexType vertexType = this.pass.vertexType();
        ChunkPrimitiveType primitiveType = this.pass.primitiveType();
        vertexType.getDefines().forEach(constants::add);
        constants.addAll(primitiveType.getDefines());
        return constants.build();
    }

    public final String toString() {
        return ChunkShaderOptions.jvmdowngrader$toString$toString(this);
    }

    public final int hashCode() {
        return ChunkShaderOptions.jvmdowngrader$hashCode$hashCode(this);
    }

    public final boolean equals(Object o) {
        return ChunkShaderOptions.jvmdowngrader$equals$equals(this, o);
    }

    public List<ChunkShaderComponent.Factory<?>> components() {
        return this.components;
    }

    public TerrainRenderPass pass() {
        return this.pass;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(ChunkShaderOptions chunkShaderOptions) {
        ChunkShaderOptions chunkShaderOptions2 = chunkShaderOptions;
        return "ChunkShaderOptions[" + "components=" + chunkShaderOptions.components + ", " + "pass=" + chunkShaderOptions.pass + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(ChunkShaderOptions chunkShaderOptions) {
        Object[] objectArray = new Object[]{chunkShaderOptions.components, chunkShaderOptions.pass};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(ChunkShaderOptions chunkShaderOptions, Object object) {
        if (chunkShaderOptions == object) {
            return true;
        }
        if (object != null && object instanceof ChunkShaderOptions) {
            ChunkShaderOptions chunkShaderOptions2 = (ChunkShaderOptions)((Object)object);
            if (Objects.equals(chunkShaderOptions.components, chunkShaderOptions2.components) && Objects.equals(chunkShaderOptions.pass, chunkShaderOptions2.pass)) {
                return true;
            }
        }
        return false;
    }
}

