/*
 * Decompiled with CFR 0.152.
 */
package net.michaelsebero.noworldgen5you;

import java.lang.reflect.Field;
import net.michaelsebero.noworldgen5you.WorldgenConfig;
import net.michaelsebero.noworldgen5you.world.gen.MapGenCaveEmpty;
import net.michaelsebero.noworldgen5you.world.gen.MapGenEmpty;
import net.michaelsebero.noworldgen5you.world.gen.MapGenEndCityEmpty;
import net.michaelsebero.noworldgen5you.world.gen.MapGenFortressEmpty;
import net.michaelsebero.noworldgen5you.world.gen.MapGenMineshaftEmpty;
import net.michaelsebero.noworldgen5you.world.gen.MapGenOceanMonumentEmpty;
import net.michaelsebero.noworldgen5you.world.gen.MapGenScatteredFeaturesEmpty;
import net.michaelsebero.noworldgen5you.world.gen.MapGenStrongholdEmpty;
import net.michaelsebero.noworldgen5you.world.gen.MapGenVillageEmpty;
import net.michaelsebero.noworldgen5you.world.gen.MapGenWoodlandMansion;
import net.minecraft.world.World;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="noworldgen5you", name="No Worldgen 5 You", version="1.0.0", certificateFingerprint="@FINGERPRINT@", acceptedMinecraftVersions="[1.12.2]")
public class NoWorldgen5You {
    private static final Logger LOG = LogManager.getLogger((String)"No Worldgen 5 You");
    private static MapGenScatteredFeaturesEmpty SCATTERED_GEN;
    private static int lastDimensionLoaded;
    private static int dimensionLoadCounter;
    private static String currentWorldName;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        WorldgenConfig.initConfig(event.getSuggestedConfigurationFile());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        SCATTERED_GEN = new MapGenScatteredFeaturesEmpty();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load loadEvent) {
        if (!loadEvent.getWorld().field_72995_K) {
            int dimension = loadEvent.getWorld().field_73011_w.getDimension();
            if (dimension == 0) {
                String worldName = null;
                if (loadEvent.getWorld().func_72860_G() != null && loadEvent.getWorld().func_72860_G().func_75765_b() != null) {
                    worldName = loadEvent.getWorld().func_72860_G().func_75765_b().getName();
                }
                if (worldName != null && !worldName.equals(currentWorldName)) {
                    LOG.info("New world session detected: {} (previous: {})", (Object)worldName, (Object)currentWorldName);
                    dimensionLoadCounter = 0;
                    currentWorldName = worldName;
                }
            }
            lastDimensionLoaded = dimension;
            LOG.info("World loaded - Dimension ID: {}, Name: {}, Load counter: {}", (Object)lastDimensionLoaded, (Object)loadEvent.getWorld().field_73011_w.func_186058_p().func_186065_b(), (Object)dimensionLoadCounter);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload unloadEvent) {
        int dimension;
        if (!unloadEvent.getWorld().field_72995_K && (dimension = unloadEvent.getWorld().field_73011_w.getDimension()) == 0) {
            LOG.info("Dimension 0 unloaded, resetting counter for next session");
            dimensionLoadCounter = 0;
            currentWorldName = null;
        }
    }

    @SubscribeEvent
    public void onChunkPopulated(PopulateChunkEvent.Populate event) {
        if (WorldgenConfig.isPopulateDisabled(event.getType().name().toLowerCase())) {
            event.setResult(Event.Result.DENY);
        }
    }

    private String getWorldIdentifier(InitMapGenEvent event) {
        try {
            World world;
            Field worldField = event.getOriginalGen().getClass().getSuperclass().getDeclaredField("world");
            worldField.setAccessible(true);
            Object worldObj = worldField.get(event.getOriginalGen());
            if (worldObj != null && worldObj instanceof World && (world = (World)worldObj).func_72860_G() != null && world.func_72860_G().func_75765_b() != null) {
                return world.func_72860_G().func_75765_b().getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentWorldName;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMapGen(InitMapGenEvent event) {
        LOG.info("InitMapGenEvent fired - Type: {}, Original: {}, NewGen: {}", (Object)event.getType(), (Object)event.getOriginalGen().getClass().getName(), (Object)event.getNewGen().getClass().getName());
        if (WorldgenConfig.isStructureDisabled(event.getType().name().toLowerCase())) {
            LOG.info("Replacing {} generator", (Object)event.getType());
            switch (event.getType()) {
                case CAVE: {
                    boolean isVanillaCaves = event.getNewGen() instanceof MapGenCaves;
                    String packageName = event.getNewGen().getClass().getPackage().getName();
                    boolean isMinecraftPackage = packageName.startsWith("net.minecraft");
                    boolean isOurEmpty = event.getNewGen() instanceof MapGenCaveEmpty;
                    boolean isBetterCaves = packageName.contains("bettercaves");
                    ++dimensionLoadCounter;
                    if (isVanillaCaves && isMinecraftPackage && !isOurEmpty) {
                        LOG.info("Vanilla caves detected, replacing with empty generator");
                        event.setNewGen((MapGenBase)new MapGenCaveEmpty());
                        break;
                    }
                    if (isBetterCaves) {
                        if (dimensionLoadCounter <= 3) {
                            LOG.info("Better Caves in primary dimensions, keeping it (load count: {})", (Object)dimensionLoadCounter);
                            break;
                        }
                        LOG.info("Better Caves in OTG secondary dimension, disabling (load count: {})", (Object)dimensionLoadCounter);
                        event.setNewGen((MapGenBase)new MapGenCaveEmpty());
                        break;
                    }
                    if (isOurEmpty) {
                        LOG.info("Already using empty cave generator");
                        break;
                    }
                    LOG.info("Other cave generator detected ({}), leaving it alone", (Object)event.getNewGen().getClass().getName());
                    break;
                }
                case CUSTOM: {
                    LOG.info("Attempting to replace {} with an empty map generator. If this causes a ClassCastException report it to the author of that mod and not the author of NoWorldgen5You");
                    event.setNewGen((MapGenBase)new MapGenEmpty());
                    break;
                }
                case MINESHAFT: {
                    event.setNewGen((MapGenBase)new MapGenMineshaftEmpty());
                    break;
                }
                case NETHER_BRIDGE: {
                    event.setNewGen((MapGenBase)new MapGenFortressEmpty());
                    break;
                }
                case NETHER_CAVE: {
                    event.setNewGen((MapGenBase)new MapGenEmpty());
                    break;
                }
                case OCEAN_MONUMENT: {
                    event.setNewGen((MapGenBase)new MapGenOceanMonumentEmpty());
                    break;
                }
                case RAVINE: {
                    event.setNewGen((MapGenBase)new MapGenEmpty());
                    break;
                }
                case SCATTERED_FEATURE: {
                    event.setNewGen((MapGenBase)SCATTERED_GEN);
                    break;
                }
                case STRONGHOLD: {
                    event.setNewGen((MapGenBase)new MapGenStrongholdEmpty());
                    break;
                }
                case VILLAGE: {
                    event.setNewGen((MapGenBase)new MapGenVillageEmpty());
                    break;
                }
                case END_CITY: {
                    event.setNewGen((MapGenBase)new MapGenEndCityEmpty());
                    break;
                }
                case WOODLAND_MANSION: {
                    event.setNewGen((MapGenBase)new MapGenWoodlandMansion());
                }
            }
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOG.warn("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    static {
        lastDimensionLoaded = Integer.MIN_VALUE;
        dimensionLoadCounter = 0;
        currentWorldName = null;
    }
}

