/*
 * Decompiled with CFR 0.152.
 */
package dev.grosik.create_snt.base;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.grosik.create_snt.init.Blocks;
import dev.grosik.create_snt.init.CreativeTab;
import dev.grosik.create_snt.init.Fluids;
import dev.grosik.create_snt.init.Items;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FluidContainer {
    public final RegistryObject<FluidType> type;
    public final FluidType.Properties typeProperties;
    public final RegistryObject<LiquidBlock> block;
    public final RegistryObject<BucketItem> bucket;
    private ForgeFlowingFluid.Properties properties;
    public final RegistryObject<ForgeFlowingFluid.Source> source;
    public final RegistryObject<ForgeFlowingFluid.Flowing> flowing;

    public FluidContainer(String name, FluidType.Properties typeProperties, final Supplier<IClientFluidTypeExtensions> clientExtensions, @Nullable AdditionalProperties additionalProperties, BlockBehaviour.Properties blockProperties, Item.Properties itemProperties) {
        this.typeProperties = typeProperties;
        this.type = Fluids.FLUID_TYPES.register(name, () -> new FluidType(this.typeProperties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept((IClientFluidTypeExtensions)clientExtensions.get());
            }
        });
        this.source = Fluids.FLUIDS.register(name, () -> new ForgeFlowingFluid.Source(this.properties));
        this.flowing = Fluids.FLUIDS.register(name + "_flowing", () -> new ForgeFlowingFluid.Flowing(this.properties));
        this.properties = new ForgeFlowingFluid.Properties(this.type, this.source, this.flowing);
        if (additionalProperties != null) {
            this.properties.explosionResistance(additionalProperties.explosionResistance).levelDecreasePerBlock(additionalProperties.levelDecreasePerBlock).slopeFindDistance(additionalProperties.slopeFindDistance).tickRate(additionalProperties.tickRate);
        }
        this.block = Blocks.BLOCKS.register(name, () -> new LiquidBlock(this.source, blockProperties));
        this.properties.block(this.block);
        this.bucket = Items.ITEMS.register(name + "_bucket", () -> new BucketItem(this.source, itemProperties));
        CreativeTab.addToTab(this.bucket);
        this.properties.bucket(this.bucket);
    }

    public FluidContainer(String name, FluidType.Properties typeProperties, Supplier<IClientFluidTypeExtensions> clientExtensions, BlockBehaviour.Properties blockProperties, Item.Properties itemProperties) {
        this(name, typeProperties, clientExtensions, null, blockProperties, itemProperties);
    }

    public FluidContainer(String name, FluidType.Properties typeProperties, Supplier<IClientFluidTypeExtensions> clientExtensions, BlockBehaviour.Properties blockProperties) {
        this(name, typeProperties, clientExtensions, null, blockProperties, new Item.Properties().m_41487_(1));
    }

    public ForgeFlowingFluid.Properties getProperties() {
        return this.properties;
    }

    public static IClientFluidTypeExtensions createExtension(final ClientExtensions extensions) {
        return new IClientFluidTypeExtensions(){

            public ResourceLocation getFlowingTexture() {
                return extensions.flowing;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return extensions.overlay;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft minecraft) {
                return extensions.renderOverlay;
            }

            public ResourceLocation getStillTexture() {
                return extensions.still;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return extensions.tintFunction == null ? -1 : (Integer)extensions.tintFunction.apply((Object)state, (Object)getter, (Object)pos);
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return extensions.fogColor == null ? super.modifyFogColor(camera, partialTick, level, renderDistance, darkenWorldAmount, fluidFogColor) : extensions.fogColor;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)1.0f);
                RenderSystem.setShaderFogEnd((float)6.0f);
            }
        };
    }

    public static class AdditionalProperties {
        private int levelDecreasePerBlock = 1;
        private float explosionResistance = 1.0f;
        private int slopeFindDistance = 4;
        private int tickRate = 5;

        public AdditionalProperties explosionResistance(float resistance) {
            this.explosionResistance = resistance;
            return this;
        }

        public AdditionalProperties levelDecreasePerBlock(int decrease) {
            this.levelDecreasePerBlock = decrease;
            return this;
        }

        public AdditionalProperties slopeFindDistance(int distance) {
            this.slopeFindDistance = distance;
            return this;
        }

        public AdditionalProperties tickRate(int rate) {
            this.tickRate = rate;
            return this;
        }
    }

    public static class ClientExtensions {
        private ResourceLocation still;
        private ResourceLocation flowing;
        private ResourceLocation overlay;
        private ResourceLocation renderOverlay;
        private Vector3f fogColor;
        private TriFunction<FluidState, BlockAndTintGetter, BlockPos, Integer> tintFunction;
        private final String modid;

        public ClientExtensions(String modid, String fluidName) {
            this.modid = modid;
            this.still(fluidName);
            this.flowing(fluidName);
            this.overlay(fluidName);
        }

        public ClientExtensions flowing(String name) {
            return this.flowing(name, "block");
        }

        public ClientExtensions flowing(String name, String folder) {
            this.flowing = new ResourceLocation(this.modid, folder + "/" + name);
            return this;
        }

        public ClientExtensions fogColor(float red, float green, float blue) {
            this.fogColor = new Vector3f(red, green, blue);
            return this;
        }

        public ClientExtensions overlay(String name) {
            return this.overlay(name, "blocks");
        }

        public ClientExtensions overlay(String name, String folder) {
            this.overlay = new ResourceLocation(this.modid, folder + "/" + name);
            return this.renderOverlay(new ResourceLocation(this.modid, "textures/" + folder + "/" + name + ".png"));
        }

        public ClientExtensions renderOverlay(ResourceLocation path) {
            this.renderOverlay = path;
            return this;
        }

        public ClientExtensions still(String name) {
            return this.still(name, "block");
        }

        public ClientExtensions still(String name, String folder) {
            this.still = new ResourceLocation(this.modid, folder + "/" + name);
            return this;
        }

        public ClientExtensions tint(int tint) {
            this.tintFunction = ($0, $1, $2) -> tint;
            return this;
        }

        public ClientExtensions tint(TriFunction<FluidState, BlockAndTintGetter, BlockPos, Integer> tinter) {
            this.tintFunction = tinter;
            return this;
        }
    }
}

