/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.mojang.datafixers.util.Either;
import java.util.Objects;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.component.custom.CanSweep;
import net.atlas.combatify.config.ConfigurableEntityData;
import net.atlas.combatify.config.wrapper.EntityWrapper;
import net.atlas.combatify.config.wrapper.LivingEntityWrapper;
import net.atlas.combatify.config.wrapper.PlayerWrapper;
import net.atlas.combatify.extensions.PlayerExtensions;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.class_11368;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class}, priority=1400)
public abstract class PlayerMixin
extends class_1309
implements PlayerExtensions {
    @Unique
    private static final class_2940<Boolean> DATA_PLAYER_USES_SHIELD_CROUCH = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);
    @Shadow
    @Final
    protected static class_2940<Byte> field_7518;
    @Shadow
    protected int field_7494;
    @Unique
    protected int attackStrengthMaxValue;
    @Unique
    public boolean missedAttackRecovery;
    @Unique
    @Final
    public float baseValue = 1.0f;
    @Unique
    boolean attacked;
    @Unique
    public final class_1657 player = (class_1657)this;

    public PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract void method_5997(@NotNull class_1309 var1);

    @Shadow
    public abstract float method_7261(float var1);

    @Shadow
    public abstract float method_7279();

    @Shadow
    public abstract void method_7324(class_1297 var1);

    @Shadow
    public abstract double method_55755();

    @Shadow
    protected abstract float method_59903(class_1297 var1, float var2, class_1282 var3);

    @Shadow
    @NotNull
    public abstract class_1799 method_59958();

    @Shadow
    public abstract boolean method_45015();

    @Shadow
    public abstract void method_5773();

    @Shadow
    public abstract void method_7350();

    @Shadow
    public abstract Either<class_1657.class_1658, class_3902> method_7269(class_2338 var1);

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    public void appendShieldOnCrouch(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(DATA_PLAYER_USES_SHIELD_CROUCH, (Object)true);
    }

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")})
    public void injectSnowballKb(class_3218 serverLevel, class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> cir, @Share(value="originalDamage") LocalFloatRef originalDamage) {
        originalDamage.set(amount);
    }

    @Inject(method={"hurtServer"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true)
    public void changeReturn(class_3218 serverLevel, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir, @Share(value="originalDamage") LocalFloatRef originalDamage) {
        boolean bl;
        boolean bl2 = bl = amount == 0.0f && originalDamage.get() <= 0.0f;
        if (bl && Combatify.CONFIG.snowballKB().booleanValue()) {
            cir.setReturnValue((Object)super.method_64397(serverLevel, source, amount));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(class_11368 valueInput, CallbackInfo ci) {
        Objects.requireNonNull(this.player.method_5996(class_5134.field_23721)).method_6192(Combatify.CONFIG.fistDamage().doubleValue());
        Objects.requireNonNull(this.player.method_5996(class_5134.field_23723)).method_6192(Combatify.CONFIG.baseHandAttackSpeed() + 1.5);
        Objects.requireNonNull(this.player.method_5996(class_5134.field_47759)).method_6192(Combatify.CONFIG.attackReach() != false ? 2.5 : 3.0);
    }

    @ModifyExpressionValue(method={"createAttributes"}, at={@At(value="CONSTANT", args={"doubleValue=1.0"})})
    private static double changeAttack(double constant) {
        return Combatify.CONFIG.fistDamage();
    }

    @ModifyReturnValue(method={"createAttributes"}, at={@At(value="RETURN")})
    private static class_5132.class_5133 createAttributes(class_5132.class_5133 original) {
        return original.method_26868(class_5134.field_47759, Combatify.CONFIG.attackReach() != false ? 2.5 : 3.0).method_26868(class_5134.field_23723, Combatify.CONFIG.baseHandAttackSpeed() + 1.5);
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    public void addServerOnlyCheck(class_1799 itemStack, boolean bl, CallbackInfoReturnable<class_1542> cir) {
        if (Combatify.unmoddedPlayers.contains(this.player.method_5667())) {
            Combatify.isPlayerAttacking.put(this.player.method_5667(), false);
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;resetAttackStrengthTicker()V")})
    public void redirectDurability(class_1657 instance, Operation<Void> original) {
        block3: {
            block2: {
                if (Combatify.CONFIG.resetOnItemChange().booleanValue()) break block2;
                if (!Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) break block3;
            }
            this.resetAttackStrengthTicker(false, true, xva$0 -> {
                Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0});
            });
        }
    }

    @Inject(method={"blockUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemBlockingWith()Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    public void blockUsingShield(class_3218 serverLevel, class_1309 livingEntity, CallbackInfo ci) {
        ci.cancel();
    }

    public boolean combatify$hasEnabledShieldOnCrouch() {
        return (Boolean)this.field_6011.method_12789(DATA_PLAYER_USES_SHIELD_CROUCH);
    }

    @Override
    public void combatify$setShieldOnCrouch(boolean hasShieldOnCrouch) {
        this.field_6011.method_12778(DATA_PLAYER_USES_SHIELD_CROUCH, (Object)hasShieldOnCrouch);
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void attack(class_1297 target, CallbackInfo ci) {
        if (!this.combatify$isAttackAvailable(this.baseValue)) {
            ci.cancel();
        }
    }

    @Inject(method={"attack"}, at={@At(value="TAIL")})
    public void resetTicker(class_1297 target, CallbackInfo ci) {
        if (this.attacked) {
            boolean isMiscTarget = false;
            ConfigurableEntityData configurableEntityData = MethodHandler.forEntity(target);
            if (configurableEntityData != null && configurableEntityData.isMiscEntity() != null) {
                isMiscTarget = configurableEntityData.isMiscEntity();
            }
            this.combatify$resetAttackStrengthTicker(Combatify.CONFIG.improvedMiscEntityAttacks() == false || !isMiscTarget);
        }
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;resetAttackStrengthTicker()V")})
    public void stopReset(class_1657 instance, Operation<Void> original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            original.call(new Object[]{instance});
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)})
    public void doThings(class_1297 target, CallbackInfo ci, @Local(ordinal=0) LocalFloatRef attackDamage, @Local(ordinal=1) float attackDamageBonus) {
        this.attacked = true;
        if (Combatify.CONFIG.strengthAppliesToEnchants().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            attackDamage.set((float)(this.method_6123() ? MethodHandler.calculateValueFromBase(this.player.method_5996(class_5134.field_23721), this.field_51569 + attackDamageBonus) : MethodHandler.calculateValue(this.player.method_5996(class_5134.field_23721), attackDamageBonus)));
        }
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)})
    public float redirectStrengthCheck(float original) {
        original = (float)class_3532.method_15350((double)original, (double)Combatify.CONFIG.attackDecayMinCharge(), (double)Combatify.CONFIG.attackDecayMaxCharge());
        return (Combatify.CONFIG.attackDecay() == false || this.missedAttackRecovery && (float)this.field_6273 > 4.0f) && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 1.0f : original;
    }

    @Inject(method={"resetAttackStrengthTicker"}, at={@At(value="HEAD")}, cancellable=true)
    public void reset(CallbackInfo ci) {
        int chargeTicks = (int)this.method_7279() * (Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2 : 1);
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) || chargeTicks > this.attackStrengthMaxValue - this.field_6273) {
            if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                Combatify.LOGGER.info("Ticks for charge: " + chargeTicks);
            }
            this.attackStrengthMaxValue = chargeTicks;
        } else {
            ci.cancel();
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;")})
    public void injectCrit(class_1297 target, CallbackInfo ci, @Local(ordinal=0) float attackDamage, @Local(ordinal=1) float enchantDamage, @Local(ordinal=2) float strengthScale, @Local(ordinal=3) LocalFloatRef combinedDamage, @Local(ordinal=2) LocalBooleanRef bl3) {
        EntityWrapper wrapper;
        boolean strengthAppliesToEnchants;
        if (Combatify.CONFIG.attackDecay().booleanValue() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            float originalAttackDamage = Combatify.CONFIG.strengthAppliesToEnchants() != false ? (float)(this.method_6123() ? MethodHandler.calculateValueFromBase(this.player.method_5996(class_5134.field_23721), this.field_51569 + enchantDamage) : MethodHandler.calculateValue(this.player.method_5996(class_5134.field_23721), enchantDamage /= strengthScale)) : (this.method_6123() ? this.field_51569 : (float)this.method_45325(class_5134.field_23721));
            attackDamage -= (float)((0.2 + (double)(strengthScale * strengthScale) * 0.8) * (double)(originalAttackDamage *= bl3.get() ? 1.5f : 1.0f));
            float adjScale = (float)(((double)strengthScale - Combatify.CONFIG.attackDecayMinCharge()) / Combatify.CONFIG.attackDecayMaxChargeDiff());
            combinedDamage.set((attackDamage += (originalAttackDamage *= (float)(Combatify.CONFIG.attackDecayMinPercentageBase() + (double)(adjScale * adjScale) * Combatify.CONFIG.attackDecayMaxPercentageBaseDiff()))) + (enchantDamage *= (float)(Combatify.CONFIG.attackDecayMinPercentageEnchants() + ((double)strengthScale - Combatify.CONFIG.attackDecayMinCharge()) / Combatify.CONFIG.attackDecayMaxChargeDiff() * Combatify.CONFIG.attackDecayMaxPercentageEnchantsDiff())));
        }
        boolean bl = strengthAppliesToEnchants = Combatify.CONFIG.strengthAppliesToEnchants() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA);
        if (strengthAppliesToEnchants) {
            combinedDamage.set(attackDamage);
        }
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) || !Combatify.CONFIG.getCritImpl().execFunc("overrideCrit()", new Object[0])) {
            return;
        }
        if (bl3.get()) {
            if (strengthAppliesToEnchants) {
                combinedDamage.set(combinedDamage.get() / 1.5f);
            } else {
                attackDamage /= 1.5f;
            }
        }
        if (target instanceof class_1657) {
            class_1657 p = (class_1657)target;
            wrapper = new PlayerWrapper<class_1657>(p);
        } else if (target instanceof class_1309) {
            class_1309 l = (class_1309)target;
            wrapper = new LivingEntityWrapper<class_1309>(l);
        } else {
            wrapper = new EntityWrapper<class_1297>(target);
        }
        final MutableFloat finalAttackDamage = new MutableFloat(attackDamage);
        bl3.set(Combatify.CONFIG.getCritImpl().execFunc("runCrit(player, target, combinedDamage)", new PlayerWrapper<class_1657>(this.player), wrapper, strengthAppliesToEnchants ? combinedDamage : new LocalFloatRef(){

            public float get() {
                return finalAttackDamage.getValue().floatValue();
            }

            public void set(float v) {
                finalAttackDamage.setValue(v);
            }
        }));
        if (!strengthAppliesToEnchants) {
            combinedDamage.set(finalAttackDamage.getValue().floatValue() + enchantDamage);
        }
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    public void knockback(class_1309 instance, double d, double e, double f, Operation<Void> original, @Local(ordinal=0) class_1282 damageSource) {
        Combatify.CONFIG.knockbackMode().runKnockback(instance, damageSource, d, e, f, (xva$0, xva$1, xva$2, xva$3) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1, xva$2, xva$3});
        });
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;hurtOrSimulate(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    public void createSweep(class_1297 target, CallbackInfo ci, @Local(ordinal=1) boolean bl2, @Local(ordinal=2) boolean bl3, @Local(ordinal=3) LocalBooleanRef bl4, @Local(ordinal=0) float attackDamage, @Share(value="didSweep") LocalBooleanRef didSweep) {
        boolean isSweepPossible;
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return;
        }
        bl4.set(false);
        double d = this.method_60478().method_37268();
        double e = (double)this.method_6029() * 2.5;
        boolean bl = isSweepPossible = Combatify.CONFIG.sweepConditionsMatchMiss() != false || this.method_24828();
        if (!bl3 && !bl2 && isSweepPossible && d < class_3532.method_33723((double)e) && this.checkSweepAttack()) {
            class_238 box = target.method_5829().method_1009(1.0, 0.25, 1.0);
            MethodHandler.sweepAttack(this.player, box, (float)MethodHandler.getCurrentAttackReach(this.player, 1.0f), attackDamage, (TriFunction<class_1309, Float, class_1282, Float>)((TriFunction)(livingEntity, damage, damageSource) -> {
                float attackDamageBonus = this.method_59903((class_1297)livingEntity, damage.floatValue(), (class_1282)damageSource) - damage.floatValue();
                if (Combatify.CONFIG.strengthAppliesToEnchants().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                    attackDamageBonus = (float)MethodHandler.calculateValueFromBase(this.player.method_5996(class_5134.field_23721), attackDamageBonus);
                }
                if (Combatify.CONFIG.attackDecay().booleanValue() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                    attackDamageBonus *= (float)(Combatify.CONFIG.attackDecayMinPercentageEnchants() + ((double)this.method_7261(0.5f) - Combatify.CONFIG.attackDecayMinCharge()) / Combatify.CONFIG.attackDecayMaxChargeDiff() * Combatify.CONFIG.attackDecayMaxPercentageEnchantsDiff());
                }
                return Float.valueOf(damage.floatValue() + attackDamageBonus);
            }), target);
            didSweep.set(true);
        }
    }

    @Inject(method={"attack"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;hurtMarked:Z", shift=At.Shift.BEFORE, ordinal=0)})
    public void resweep(class_1297 target, CallbackInfo ci, @Local(ordinal=3) LocalBooleanRef bl4, @Share(value="didSweep") LocalBooleanRef didSweep) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return;
        }
        bl4.set(didSweep.get());
    }

    @Override
    public void combatify$attackAir() {
        if (this.combatify$isAttackAvailable(this.baseValue)) {
            this.combatify$customSwing(class_1268.field_5808);
            float attackDamage = (float)this.player.method_45325(class_5134.field_23721);
            if (attackDamage > 0.0f && this.checkSweepAttack() && Combatify.CONFIG.canSweepOnMiss().booleanValue()) {
                float currentAttackReach = (float)MethodHandler.getCurrentAttackReach(this.player, 1.0f);
                double dirX = (double)(-class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)))) * 2.0;
                double dirZ = (double)class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * 2.0;
                class_238 sweepBox = this.player.method_5829().method_1009(1.0, 0.25, 1.0).method_989(dirX, 0.0, dirZ);
                if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                    Combatify.LOGGER.info("Swept");
                }
                MethodHandler.sweepAttack(this.player, sweepBox, currentAttackReach, attackDamage, (TriFunction<class_1309, Float, class_1282, Float>)((TriFunction)(livingEntity, damage, damageSource) -> {
                    float attackDamageBonus = this.method_59903((class_1297)livingEntity, damage.floatValue(), (class_1282)damageSource) - damage.floatValue();
                    if (Combatify.CONFIG.strengthAppliesToEnchants().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                        attackDamageBonus = (float)MethodHandler.calculateValueFromBase(this.player.method_5996(class_5134.field_23721), attackDamageBonus);
                    }
                    if (Combatify.CONFIG.attackDecay().booleanValue() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                        attackDamageBonus *= (float)(Combatify.CONFIG.attackDecayMinPercentageEnchants() + ((double)this.method_7261(0.5f) - Combatify.CONFIG.attackDecayMinCharge()) / Combatify.CONFIG.attackDecayMaxChargeDiff() * Combatify.CONFIG.attackDecayMaxPercentageEnchantsDiff());
                    }
                    return Float.valueOf(damage.floatValue() + attackDamageBonus);
                }), null);
            }
            this.combatify$resetAttackStrengthTicker(false);
        }
    }

    @Override
    public void combatify$customSwing(class_1268 interactionHand) {
        this.method_23667(interactionHand, false);
    }

    public void combatify$resetAttackStrengthTicker(boolean hit) {
        this.resetAttackStrengthTicker(hit, false, class_1657::method_7350);
    }

    public void combatify$resetAttackStrengthTicker(boolean hit, boolean force) {
        this.resetAttackStrengthTicker(hit, force, class_1657::method_7350);
    }

    @Unique
    public void resetAttackStrengthTicker(boolean hit, boolean force, Consumer<class_1657> vanillaReset) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            vanillaReset.accept(this.player);
            return;
        }
        boolean bl = this.missedAttackRecovery = !hit && Combatify.CONFIG.missedAttackRecovery() != false;
        if (Combatify.CONFIG.attackSpeed() == false && this.method_45325(class_5134.field_23723) - 1.5 >= 20.0 || Combatify.CONFIG.instaAttack().booleanValue()) {
            return;
        }
        int chargeTicks = (int)this.method_7279() * (Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2 : 1);
        if (force || chargeTicks > this.attackStrengthMaxValue - this.field_6273) {
            if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                Combatify.LOGGER.info("Ticks for charge: " + chargeTicks);
            }
            this.attackStrengthMaxValue = chargeTicks;
            this.field_6273 = 0;
        }
    }

    @ModifyExpressionValue(method={"getCurrentItemAttackStrengthDelay"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D")})
    public double modifyAttackSpeed(double original, @Share(value="hasVanilla") LocalBooleanRef hasVanilla) {
        hasVanilla.set((this.method_5996(class_5134.field_23723).method_6199(class_1792.field_8001) != null || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) && !Combatify.getState().equals((Object)Combatify.CombatifyState.CTS_8C));
        double mod = Combatify.CONFIG.hasteFix() == false ? 1.5 : MethodHandler.calculateValueFromBase(this.method_5996(class_5134.field_23723), 1.5);
        double speed = original - mod;
        if (hasVanilla.get() || speed <= 0.0) {
            speed += mod;
        }
        return class_3532.method_15350((double)speed, (double)0.1, (double)1024.0);
    }

    @ModifyReturnValue(method={"getCurrentItemAttackStrengthDelay"}, at={@At(value="RETURN")})
    public float modifyAttackTicks(float original, @Share(value="hasVanilla") LocalBooleanRef hasVanilla) {
        return hasVanilla.get() ? original : (float)Math.round(original);
    }

    @ModifyExpressionValue(method={"getAttackStrengthScale"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getCurrentItemAttackStrengthDelay()F")})
    public float modifyMaxCharge(float original) {
        return Combatify.CONFIG.resetOnItemChange() != false || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? (float)((int)original * (Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2 : 1)) : (float)this.attackStrengthMaxValue;
    }

    @ModifyReturnValue(method={"getAttackStrengthScale"}, at={@At(value="RETURN")})
    public float modifyAttackStrengthScale(float original) {
        float charge;
        float f = charge = Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2.0f : 1.0f;
        if (this.attackStrengthMaxValue == 0) {
            return charge;
        }
        return charge * original;
    }

    public boolean combatify$isAttackAvailable(float baseTime) {
        if (this.method_7261(baseTime) < 1.0f && !Combatify.CONFIG.canAttackEarly().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return this.missedAttackRecovery && (float)this.field_6273 + baseTime > 4.0f;
        }
        return true;
    }

    @Unique
    protected boolean checkSweepAttack() {
        boolean sweep;
        float charge = Combatify.CONFIG.chargedAttacks() != false ? 1.95f : 0.9f;
        boolean sweepingItem = ((CanSweep)this.method_6047().method_58695(CustomDataComponents.CAN_SWEEP, (Object)CanSweep.DISABLED)).enabled();
        boolean bl = sweep = this.method_7261(this.baseValue) > charge && (this.method_45325(class_5134.field_51577) > 0.0 || sweepingItem);
        if (!Combatify.CONFIG.sweepWithSweeping().booleanValue()) {
            return sweepingItem && sweep;
        }
        return sweep;
    }

    @Override
    public boolean combatify$getMissedAttackRecovery() {
        return this.missedAttackRecovery;
    }

    @ModifyReturnValue(method={"entityInteractionRange"}, at={@At(value="RETURN")})
    public double getCurrentAttackReach(double original) {
        return MethodHandler.getCurrentAttackReach(this.player, 0.0f);
    }
}

