/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableEntityData;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.JSImpl;
import net.atlas.combatify.util.blocking.BlockingType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ItemConfig
extends AtlasConfig {
    public boolean isModifying = false;
    public AtlasConfig.TagHolder<List<RegistryConfigDataWrapper<class_1299<?>, ConfigurableEntityData>>> entities;
    public AtlasConfig.TagHolder<List<RegistryConfigDataWrapper<class_1792, ConfigurableItemData>>> items;
    public AtlasConfig.TagHolder<JSImpl> armourCalcs;
    public static final class_9139<class_9129, class_2960> RESOURCE_NAME_STREAM_CODEC = class_9139.method_56437(class_2540::method_10812, class_2540::method_10810);
    public static final MapCodec<RegistryConfigDataWrapper<class_1792, ConfigurableItemData>> ITEMS_CODEC = RegistryConfigDataWrapper.mapCodec(class_7923.field_41178, holder -> holder.method_55838((class_6880)class_1802.field_8162.method_40131()) ? DataResult.error(() -> "Item must not be minecraft:air", (Object)holder) : DataResult.success((Object)holder), ConfigurableItemData.CODEC);
    public static final MapCodec<RegistryConfigDataWrapper<class_1299<?>, ConfigurableEntityData>> ENTITIES_CODEC = RegistryConfigDataWrapper.mapCodec(class_7923.field_41177, DataResult::success, ConfigurableEntityData.CODEC);

    public ItemConfig() {
        super(Combatify.id("combatify-items-v3"));
    }

    public void reloadFromDefault() {
        super.reloadFromDefault();
    }

    public void handleExtraSync(AtlasCore.AtlasConfigPacket atlasConfigPacket, ClientPlayNetworking.Context context) {
        if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
            Combatify.LOGGER.info("Loading config details from buffer.");
        }
    }

    public void handleConfigInformation(AtlasCore.ClientInformPacket clientInformPacket, class_3222 serverPlayer, PacketSender packetSender) {
    }

    protected void loadExtra(JsonObject object) {
        this.isModifying = true;
        if (!object.has("blocking_types")) {
            object.add("blocking_types", (JsonElement)new JsonArray());
        }
        JsonElement defenders = object.get("blocking_types");
        Combatify.registeredTypes = new HashMap<class_2960, BlockingType>(Combatify.defaultTypes);
        List altered = (List)BlockingType.CODEC.listOf().orElse(Collections.emptyList()).parse((DynamicOps)JsonOps.INSTANCE, (Object)defenders).getOrThrow();
        altered.forEach(Combatify::registerBlockingType);
        this.isModifying = false;
    }

    public void defineConfigHolders() {
        this.items = this.createCodecBacked("items", new ArrayList(), ITEMS_CODEC.codec().listOf());
        this.entities = this.createCodecBacked("entities", new ArrayList(), ENTITIES_CODEC.codec().listOf());
        this.armourCalcs = this.createCodecBacked("armor_calculation", new JSImpl("armor_calculations"), JSImpl.CODEC);
    }

    public void resetExtraHolders() {
        Combatify.registeredTypes = new HashMap<class_2960, BlockingType>(Combatify.defaultTypes);
    }

    public <T> void alertChange(AtlasConfig.ConfigValue<T> tConfigValue, T newValue) {
    }

    public <T> void alertClientValue(AtlasConfig.ConfigValue<T> configValue, T t, T t1) {
    }

    public AtlasConfig readClientConfigInformation(class_9129 buf) {
        super.readClientConfigInformation(buf);
        ItemConfig.readMap(buf, RESOURCE_NAME_STREAM_CODEC, BlockingType.FULL_STREAM_CODEC);
        return this;
    }

    public ItemConfig loadFromNetwork(class_9129 buf) {
        super.loadFromNetwork(buf);
        Combatify.registeredTypes = ItemConfig.readMap(buf, RESOURCE_NAME_STREAM_CODEC, BlockingType.FULL_STREAM_CODEC);
        return this;
    }

    public void saveToNetwork(class_9129 buf) {
        super.saveToNetwork(buf);
        ItemConfig.writeMap(buf, Combatify.registeredTypes, RESOURCE_NAME_STREAM_CODEC, BlockingType.FULL_STREAM_CODEC);
    }

    public JsonElement saveExtra(JsonElement jsonElement) {
        JsonArray defenders = new JsonArray();
        ArrayList<BlockingType> blockingTypes = new ArrayList<BlockingType>(Combatify.registeredTypes.values());
        blockingTypes.removeIf(Combatify.defaultTypes::containsValue);
        defenders = (JsonElement)BlockingType.CODEC.listOf().encode(blockingTypes, (DynamicOps)JsonOps.INSTANCE, (Object)defenders).getOrThrow();
        JsonObject result = jsonElement.getAsJsonObject();
        result.add("blocking_types", (JsonElement)defenders);
        return result;
    }

    public static <B extends class_2540, K, V> Map<K, V> readMap(B buf, class_9139<B, K> keyCodec, class_9139<B, V> valueCodec) {
        return ItemConfig.readMap(buf, Maps::newHashMapWithExpectedSize, keyCodec, valueCodec);
    }

    public static <B extends class_2540, K, V, M extends Map<K, V>> M readMap(B buf, IntFunction<M> intFunction, class_9139<B, K> keyCodec, class_9139<B, V> valueCodec) {
        int size = buf.method_10816();
        Map map = (Map)intFunction.apply(size);
        for (int index = 0; index < size; ++index) {
            Object key = keyCodec.decode(buf);
            Object value = valueCodec.decode(buf);
            map.put(key, value);
        }
        return (M)map;
    }

    public static <B extends class_2540, K, V> void writeMap(B buf, Map<K, V> map, class_9139<B, K> keyCodec, class_9139<B, V> valueCodec) {
        buf.method_10804(map.size());
        map.forEach((key, value) -> {
            keyCodec.encode((Object)buf, key);
            valueCodec.encode((Object)buf, value);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public class_437 createScreen(class_437 prevScreen) {
        return null;
    }

    public static void noNamePresent(RegistryConfigDataWrapper<?, ?> invalid, String stage) {
        Combatify.LOGGER.error("No name is present: " + String.valueOf(invalid) + ", no changes will occur. This may be due to an incorrectly written config file. " + ItemConfig.errorStage(stage));
    }

    public static String errorStage(String stage) {
        return "[Config Stage]: " + stage;
    }

    public record RegistryConfigDataWrapper<T, U>(class_6885.class_6886<T> holders, List<class_6862<T>> tagKeys, U configurableData) implements ConfigDataWrapper<class_6880<T>, U>
    {
        public static final RegistryConfigDataWrapper<class_1792, ConfigurableItemData> EMPTY_ITEM = new RegistryConfigDataWrapper(class_6885.method_40246((class_6880[])new class_6880[0]), Collections.emptyList(), ConfigurableItemData.EMPTY);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(class_6880<T> test) {
            if (this.holders.method_40241(test)) return true;
            if (!this.tagKeys.stream().anyMatch(arg_0 -> test.method_40220(arg_0))) return false;
            return true;
        }

        public static <T, U> RegistryConfigDataWrapper<T, U> build(class_6885.class_6886<T> holders, List<class_6862<T>> tagKeys, U configurableData) {
            RegistryConfigDataWrapper<T, U> result = new RegistryConfigDataWrapper<T, U>(holders, tagKeys, configurableData);
            if (holders.method_40247() == 0 && tagKeys.isEmpty()) {
                ItemConfig.noNamePresent(result, "Configuring Registry");
            }
            return result;
        }

        public static <T, U> MapCodec<RegistryConfigDataWrapper<T, U>> mapCodec(class_2378<T> registry, Function<class_6880<T>, DataResult<class_6880<T>>> validator, MapCodec<U> mapCodec) {
            Codec holderCodec = registry.method_40294().validate(validator);
            Codec tagKeyCodec = Codec.withAlternative((Codec)class_6862.method_40090((class_5321)registry.method_46765()), (Codec)class_6862.method_40093((class_5321)registry.method_46765()));
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.withAlternative((Codec)holderCodec.listOf(), (Codec)holderCodec, Collections::singletonList).xmap(class_6885::method_40242, holders -> holders.method_40239().toList()).optionalFieldOf("name", (Object)class_6885.method_40246((class_6880[])new class_6880[0])).forGetter(RegistryConfigDataWrapper::holders), (App)Codec.withAlternative((Codec)tagKeyCodec.listOf(), (Codec)tagKeyCodec, Collections::singletonList).optionalFieldOf("tag", Collections.emptyList()).forGetter(RegistryConfigDataWrapper::tagKeys), (App)mapCodec.forGetter(RegistryConfigDataWrapper::configurableData)).apply((Applicative)instance, RegistryConfigDataWrapper::build));
        }

        public static <T, U> class_9139<class_9129, RegistryConfigDataWrapper<T, U>> streamCodec(class_5321<? extends class_2378<T>> registry, class_9139<? super ByteBuf, U> streamCodec) {
            return class_9139.method_56436((class_9139)class_9135.method_58001(registry).method_56432(holders -> (class_6885.class_6886)holders, holders -> holders), RegistryConfigDataWrapper::holders, (class_9139)class_9135.method_56376(ArrayList::new, (class_9139)class_6862.method_64143(registry)), RegistryConfigDataWrapper::tagKeys, streamCodec, RegistryConfigDataWrapper::configurableData, RegistryConfigDataWrapper::build);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RegistryConfigDataWrapper)) {
                return false;
            }
            RegistryConfigDataWrapper that = (RegistryConfigDataWrapper)o;
            return Objects.equals(this.holders, that.holders) && Objects.equals(this.tagKeys, that.tagKeys) && Objects.equals(this.configurableData, that.configurableData);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.holders, this.tagKeys, this.configurableData);
        }

        @Override
        public String toString() {
            return "RegistryConfigDataWrapper{holders=" + String.valueOf(this.holders) + ", tagKeys=" + String.valueOf(this.tagKeys) + ", configurableData=" + String.valueOf(this.configurableData) + "}";
        }
    }

    public record RawConfigDataWrapper<T, U>(List<T> objects, U configurableData) implements ConfigDataWrapper<T, U>
    {
        public static <T, U> MapCodec<RawConfigDataWrapper<T, U>> mapCodec(MapCodec<List<T>> codec, MapCodec<U> mapCodec) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)codec.forGetter(RawConfigDataWrapper::objects), (App)mapCodec.forGetter(RawConfigDataWrapper::configurableData)).apply((Applicative)instance, RawConfigDataWrapper::new));
        }

        public static <T, U> class_9139<class_9129, RawConfigDataWrapper<T, U>> streamCodec(class_9139<class_9129, T> inputCodec, class_9139<class_9129, U> dataCodec) {
            return class_9139.method_56435((class_9139)class_9135.method_56376(ArrayList::new, inputCodec), RawConfigDataWrapper::objects, dataCodec, RawConfigDataWrapper::configurableData, RawConfigDataWrapper::new);
        }

        @Override
        public boolean matches(T test) {
            return this.objects.contains(test);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RawConfigDataWrapper)) {
                return false;
            }
            RawConfigDataWrapper that = (RawConfigDataWrapper)o;
            return Objects.equals(this.objects, that.objects) && Objects.equals(this.configurableData, that.configurableData);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.objects, this.configurableData);
        }

        @Override
        public String toString() {
            return "RawConfigDataWrapper{objects=" + String.valueOf(this.objects) + ", configurableData=" + String.valueOf(this.configurableData) + "}";
        }
    }

    public static interface ConfigDataWrapper<V, U> {
        public boolean matches(V var1);

        default public U match(V test) {
            if (this.matches(test)) {
                return this.configurableData();
            }
            return null;
        }

        public U configurableData();
    }
}

