/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.util.Codecs;
import net.atlas.atlascore.util.ConfigRepresentable;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ArmourPiercingMode;
import net.atlas.combatify.config.ArrowDisableMode;
import net.atlas.combatify.config.AttackDecay;
import net.atlas.combatify.config.EatingInterruptionMode;
import net.atlas.combatify.config.JSImpl;
import net.atlas.combatify.config.ProjectileDamage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class CombatifyGeneralConfig
extends AtlasConfig {
    private AtlasConfig.BooleanHolder iFramesBasedOnWeapon;
    private AtlasConfig.BooleanHolder bowFatigue;
    private AtlasConfig.BooleanHolder bedrockBridging;
    private AtlasConfig.BooleanHolder chargedAttacks;
    private AtlasConfig.BooleanHolder canAttackEarly;
    private AtlasConfig.BooleanHolder canSweepOnMiss;
    private AtlasConfig.BooleanHolder chargedReach;
    private AtlasConfig.BooleanHolder creativeAttackReach;
    private AtlasConfig.BooleanHolder missedAttackRecovery;
    private AtlasConfig.BooleanHolder disableDuringShieldDelay;
    private AtlasConfig.BooleanHolder hasMissTime;
    private AtlasConfig.BooleanHolder canInteractWhenCrouchShield;
    private AtlasConfig.BooleanHolder bedrockImpaling;
    private AtlasConfig.BooleanHolder dispensableTridents;
    private AtlasConfig.BooleanHolder disableLoyaltyOnHitEntity;
    private AtlasConfig.BooleanHolder snowballKB;
    private AtlasConfig.BooleanHolder resetOnItemChange;
    private AtlasConfig.BooleanHolder sweepWithSweeping;
    private AtlasConfig.BooleanHolder sweepingNegatedForTamed;
    private AtlasConfig.BooleanHolder ctsMomentumPassedToProjectiles;
    private AtlasConfig.BooleanHolder swingThroughGrass;
    private AtlasConfig.BooleanHolder delayedEntityUpdates;
    private AtlasConfig.BooleanHolder strengthAppliesToEnchants;
    private AtlasConfig.BooleanHolder percentageDamageEffects;
    private AtlasConfig.BooleanHolder ctsKB;
    private AtlasConfig.BooleanHolder tierDamageNerf;
    private AtlasConfig.BooleanHolder tridentVoidReturn;
    private AtlasConfig.BooleanHolder midairKB;
    private AtlasConfig.BooleanHolder fishingHookKB;
    private AtlasConfig.BooleanHolder shieldOnlyWhenCharged;
    private AtlasConfig.BooleanHolder letVanillaConnect;
    private AtlasConfig.BooleanHolder projectilesHaveIFrames;
    private AtlasConfig.BooleanHolder magicHasIFrames;
    private AtlasConfig.BooleanHolder autoAttackAllowed;
    private AtlasConfig.BooleanHolder axesAreWeapons;
    private AtlasConfig.BooleanHolder configOnlyWeapons;
    private AtlasConfig.BooleanHolder tieredShields;
    private AtlasConfig.BooleanHolder attackReach;
    private AtlasConfig.BooleanHolder armorPiercingDisablesShields;
    private AtlasConfig.BooleanHolder attackSpeed;
    private AtlasConfig.BooleanHolder instaAttack;
    private AtlasConfig.BooleanHolder improvedMiscEntityAttacks;
    private AtlasConfig.BooleanHolder hasteFix;
    private AtlasConfig.BooleanHolder enableDebugLogging;
    private AtlasConfig.BooleanHolder mobsCanGuard;
    private AtlasConfig.BooleanHolder mobsCanSprint;
    private AtlasConfig.IntegerHolder shieldDelay;
    private AtlasConfig.IntegerHolder instantHealthBonus;
    private AtlasConfig.IntegerHolder shieldChargePercentage;
    private AtlasConfig.DoubleHolder fistDamage;
    private AtlasConfig.DoubleHolder instantTippedArrowEffectMultiplier;
    private AtlasConfig.DoubleHolder shieldDisableTime;
    private AtlasConfig.DoubleHolder shieldProtectionArc;
    private AtlasConfig.DoubleHolder baseHandAttackSpeed;
    private AtlasConfig.DoubleHolder minHitboxSize;
    private AtlasConfig.EnumHolder<EatingInterruptionMode> eatingInterruptionMode;
    private AtlasConfig.EnumHolder<ArrowDisableMode> arrowDisableMode;
    private AtlasConfig.EnumHolder<ArmourPiercingMode> armourPiercingMode;
    private AtlasConfig.ObjectHolder<AttackDecay> attackDecay;
    private AtlasConfig.ObjectHolder<ProjectileUncertainty> projectileUncertainty;
    private AtlasConfig.ObjectHolder<ProjectileDamage> projectileDamage;
    private AtlasConfig.TagHolder<JSImpl> critImpl;
    private AtlasConfig.TagHolder<JSImpl> foodImpl;
    private AtlasConfig.Category ctsB;
    private AtlasConfig.Category ctsI;
    private AtlasConfig.Category ctsD;
    private AtlasConfig.Category ctsE;
    private AtlasConfig.Category extraB;
    private AtlasConfig.Category extraI;
    private AtlasConfig.Category extraD;
    private AtlasConfig.Category extraE;
    private AtlasConfig.Category debug;

    public CombatifyGeneralConfig() {
        this(Combatify.id("combatify-general"));
        this.declareDefaultForMod("combatify");
    }

    public CombatifyGeneralConfig(class_2960 id) {
        super(id);
    }

    public class_2561 getFormattedName() {
        return class_2561.method_43471((String)("text.config." + this.name.method_12832() + ".title")).method_27696(class_2583.field_24360.method_36139(((Integer)AtlasCore.CONFIG.configNameDisplayColour.get()).intValue()));
    }

    public void handleExtraSync(AtlasCore.AtlasConfigPacket atlasConfigPacket, ClientPlayNetworking.Context context) {
    }

    public void handleConfigInformation(AtlasCore.ClientInformPacket clientInformPacket, class_3222 serverPlayer, PacketSender packetSender) {
    }

    public void defineConfigHolders() {
        this.attackDecay = this.createObject("attackDecay", AttackDecay.DEFAULT, AttackDecay.class, AttackDecay.STREAM_CODEC, false);
        this.attackDecay.tieToCategory(this.ctsB);
        this.attackReach = this.createBoolean("attackReach", true);
        this.attackReach.tieToCategory(this.ctsB);
        this.attackReach.setupTooltip(1);
        this.autoAttackAllowed = this.createBoolean("autoAttackAllowed", true);
        this.autoAttackAllowed.tieToCategory(this.ctsB);
        this.autoAttackAllowed.setupTooltip(1);
        this.axesAreWeapons = this.createBoolean("axesAreWeapons", true);
        this.axesAreWeapons.tieToCategory(this.ctsB);
        this.axesAreWeapons.setupTooltip(1);
        this.bedrockBridging = this.createBoolean("bedrockBridging", false);
        this.bedrockBridging.tieToCategory(this.ctsB);
        this.bedrockBridging.setupTooltip(1);
        this.bedrockImpaling = this.createBoolean("bedrockImpaling", true);
        this.bedrockImpaling.tieToCategory(this.ctsB);
        this.bedrockImpaling.setupTooltip(1);
        this.bowFatigue = this.createBoolean("bowFatigue", true);
        this.bowFatigue.tieToCategory(this.ctsB);
        this.bowFatigue.setupTooltip(4);
        this.canAttackEarly = this.createBoolean("canAttackEarly", false);
        this.canAttackEarly.tieToCategory(this.ctsB);
        this.canAttackEarly.setupTooltip(1);
        this.canSweepOnMiss = this.createBoolean("canSweepOnMiss", true);
        this.canSweepOnMiss.tieToCategory(this.ctsB);
        this.canSweepOnMiss.setupTooltip(1);
        this.chargedAttacks = this.createBoolean("chargedAttacks", true);
        this.chargedAttacks.tieToCategory(this.ctsB);
        this.chargedAttacks.setupTooltip(1);
        this.chargedReach = this.createBoolean("chargedReach", true);
        this.chargedReach.tieToCategory(this.ctsB);
        this.chargedReach.setupTooltip(1);
        this.creativeAttackReach = this.createBoolean("creativeAttackReach", false);
        this.creativeAttackReach.tieToCategory(this.ctsB);
        this.creativeAttackReach.setupTooltip(1);
        this.ctsKB = this.createBoolean("ctsKB", true);
        this.ctsKB.tieToCategory(this.ctsB);
        this.ctsKB.setupTooltip(1);
        this.ctsMomentumPassedToProjectiles = this.createBoolean("ctsMomentumPassedToProjectiles", true);
        this.ctsMomentumPassedToProjectiles.tieToCategory(this.ctsB);
        this.ctsMomentumPassedToProjectiles.setupTooltip(1);
        this.dispensableTridents = this.createBoolean("dispensableTridents", true);
        this.dispensableTridents.tieToCategory(this.ctsB);
        this.dispensableTridents.setupTooltip(1);
        this.hasMissTime = this.createBoolean("hasMissTime", false);
        this.hasMissTime.tieToCategory(this.ctsB);
        this.hasMissTime.setupTooltip(1);
        this.hasteFix = this.createBoolean("hasteFix", false);
        this.hasteFix.tieToCategory(this.ctsB);
        this.hasteFix.setupTooltip(1);
        this.iFramesBasedOnWeapon = this.createBoolean("iFramesBasedOnWeapon", true);
        this.iFramesBasedOnWeapon.tieToCategory(this.ctsB);
        this.iFramesBasedOnWeapon.setupTooltip(1);
        this.missedAttackRecovery = this.createBoolean("missedAttackRecovery", true);
        this.missedAttackRecovery.tieToCategory(this.ctsB);
        this.missedAttackRecovery.setupTooltip(1);
        this.percentageDamageEffects = this.createBoolean("percentageDamageEffects", true);
        this.percentageDamageEffects.tieToCategory(this.ctsB);
        this.percentageDamageEffects.setupTooltip(1);
        this.projectilesHaveIFrames = this.createBoolean("projectilesHaveIFrames", false);
        this.projectilesHaveIFrames.tieToCategory(this.ctsB);
        this.projectilesHaveIFrames.setupTooltip(1);
        this.resetOnItemChange = this.createBoolean("resetOnItemChange", false);
        this.resetOnItemChange.tieToCategory(this.ctsB);
        this.resetOnItemChange.setupTooltip(1);
        this.snowballKB = this.createBoolean("snowballKB", true);
        this.snowballKB.tieToCategory(this.ctsB);
        this.snowballKB.setupTooltip(1);
        this.strengthAppliesToEnchants = this.createBoolean("strengthAppliesToEnchants", true);
        this.strengthAppliesToEnchants.tieToCategory(this.ctsB);
        this.strengthAppliesToEnchants.setupTooltip(1);
        this.sweepWithSweeping = this.createBoolean("sweepWithSweeping", true);
        this.sweepWithSweeping.tieToCategory(this.ctsB);
        this.sweepWithSweeping.setupTooltip(1);
        this.swingThroughGrass = this.createBoolean("swingThroughGrass", true);
        this.swingThroughGrass.tieToCategory(this.ctsB);
        this.swingThroughGrass.setupTooltip(1);
        this.tierDamageNerf = this.createBoolean("tierDamageNerf", true);
        this.tierDamageNerf.tieToCategory(this.ctsB);
        this.tierDamageNerf.setupTooltip(1);
        this.tridentVoidReturn = this.createBoolean("tridentVoidReturn", true);
        this.tridentVoidReturn.tieToCategory(this.ctsB);
        this.tridentVoidReturn.setupTooltip(1);
        this.shieldDelay = this.createInRange("shieldDelay", 0, 0, 2000, false);
        this.shieldDelay.tieToCategory(this.ctsI);
        this.shieldDelay.setupTooltip(1);
        this.instantHealthBonus = this.createInRange("instantHealthBonus", 6, 1, 1000, false);
        this.instantHealthBonus.tieToCategory(this.ctsI);
        this.baseHandAttackSpeed = this.createInRange("baseHandAttackSpeed", 2.5, 2.5, 20.0);
        this.baseHandAttackSpeed.tieToCategory(this.ctsD);
        this.fistDamage = this.createInRange("fistDamage", 2.0, 1.0, 1024.0);
        this.fistDamage.tieToCategory(this.ctsD);
        this.fistDamage.setupTooltip(1);
        this.projectileUncertainty = this.createObject("projectileUncertainty", ProjectileUncertainty.DEFAULT, ProjectileUncertainty.class, ProjectileUncertainty.STREAM_CODEC, false);
        this.projectileUncertainty.tieToCategory(this.ctsD);
        this.instantTippedArrowEffectMultiplier = this.createInRange("instantTippedArrowEffectMultiplier", 0.125, 0.0, 4.0);
        this.instantTippedArrowEffectMultiplier.tieToCategory(this.ctsD);
        this.instantTippedArrowEffectMultiplier.setupTooltip(1);
        this.shieldDisableTime = this.createInRange("shieldDisableTime", 1.6, 0.0, 10.0);
        this.shieldDisableTime.tieToCategory(this.ctsD);
        this.shieldDisableTime.setupTooltip(1);
        this.shieldProtectionArc = this.createInRange("shieldProtectionArc", 73.8723797, 0.0, 180.0);
        this.shieldProtectionArc.tieToCategory(this.ctsD);
        this.shieldProtectionArc.setupTooltip(1);
        this.minHitboxSize = this.createInRange("minHitboxSize", 0.9, 0.0, 5.0);
        this.minHitboxSize.tieToCategory(this.ctsD);
        this.minHitboxSize.setupTooltip(1);
        this.critImpl = this.createCodecBacked("critImpl", new JSImpl("cts_crit_impl"), JSImpl.CODEC);
        this.critImpl.tieToCategory(this.ctsE);
        this.critImpl.setupTooltip(1);
        this.eatingInterruptionMode = this.createEnum("eatingInterruptionMode", EatingInterruptionMode.FULL_RESET, EatingInterruptionMode.class, EatingInterruptionMode.values(), e -> class_2561.method_43471((String)("text.config.combatify-general.option.eatingInterruptionMode." + e.name().toLowerCase(Locale.ROOT))));
        this.eatingInterruptionMode.tieToCategory(this.ctsE);
        this.eatingInterruptionMode.setupTooltip(4);
        this.foodImpl = this.createCodecBacked("foodImpl", new JSImpl("cts_food_impl"), JSImpl.CODEC);
        this.foodImpl.tieToCategory(this.ctsE);
        this.foodImpl.setupTooltip(1);
        this.armorPiercingDisablesShields = this.createBoolean("armorPiercingDisablesShields", false);
        this.armorPiercingDisablesShields.tieToCategory(this.extraB);
        this.armorPiercingDisablesShields.setupTooltip(1);
        this.attackSpeed = this.createBoolean("attackSpeed", true);
        this.attackSpeed.tieToCategory(this.extraB);
        this.attackSpeed.setupTooltip(1);
        this.canInteractWhenCrouchShield = this.createBoolean("canInteractWhenCrouchShield", true);
        this.canInteractWhenCrouchShield.tieToCategory(this.extraB);
        this.configOnlyWeapons = this.createBoolean("configOnlyWeapons", false);
        this.configOnlyWeapons.tieToCategory(this.extraB);
        this.configOnlyWeapons.setRestartRequired(AtlasConfig.RestartRequiredMode.RESTART_BOTH);
        this.configOnlyWeapons.setupTooltip(1);
        this.tieredShields = this.createBoolean("tieredShields", false);
        this.tieredShields.tieToCategory(this.extraB);
        this.tieredShields.setRestartRequired(AtlasConfig.RestartRequiredMode.RESTART_BOTH);
        this.tieredShields.setupTooltip(1);
        this.delayedEntityUpdates = this.createBoolean("delayedEntityUpdates", false);
        this.delayedEntityUpdates.tieToCategory(this.extraB);
        this.delayedEntityUpdates.setupTooltip(1);
        this.disableDuringShieldDelay = this.createBoolean("disableDuringShieldDelay", false);
        this.disableDuringShieldDelay.tieToCategory(this.extraB);
        this.disableDuringShieldDelay.setupTooltip(1);
        this.disableLoyaltyOnHitEntity = this.createBoolean("disableLoyaltyOnHitEntity", false);
        this.disableLoyaltyOnHitEntity.tieToCategory(this.extraB);
        this.fishingHookKB = this.createBoolean("fishingHookKB", false);
        this.fishingHookKB.tieToCategory(this.extraB);
        this.fishingHookKB.setupTooltip(1);
        this.improvedMiscEntityAttacks = this.createBoolean("improvedMiscEntityAttacks", false);
        this.improvedMiscEntityAttacks.tieToCategory(this.extraB);
        this.improvedMiscEntityAttacks.setupTooltip(1);
        this.instaAttack = this.createBoolean("instaAttack", false);
        this.instaAttack.tieToCategory(this.extraB);
        this.instaAttack.setupTooltip(1);
        this.letVanillaConnect = this.createBoolean("letVanillaConnect", true);
        this.letVanillaConnect.tieToCategory(this.extraB);
        this.letVanillaConnect.setupTooltip(1);
        this.magicHasIFrames = this.createBoolean("magicHasIFrames", true);
        this.magicHasIFrames.tieToCategory(this.extraB);
        this.magicHasIFrames.setupTooltip(1);
        this.midairKB = this.createBoolean("midairKB", false);
        this.midairKB.tieToCategory(this.extraB);
        this.midairKB.setupTooltip(2);
        this.mobsCanGuard = this.createBoolean("mobsCanGuard", false);
        this.mobsCanGuard.tieToCategory(this.extraB);
        this.mobsCanGuard.setupTooltip(1);
        this.mobsCanSprint = this.createBoolean("mobsCanSprint", false);
        this.mobsCanSprint.tieToCategory(this.extraB);
        this.mobsCanSprint.setupTooltip(1);
        this.shieldOnlyWhenCharged = this.createBoolean("shieldOnlyWhenCharged", false);
        this.shieldOnlyWhenCharged.tieToCategory(this.extraB);
        this.shieldOnlyWhenCharged.setupTooltip(2);
        this.sweepingNegatedForTamed = this.createBoolean("sweepingNegatedForTamed", false);
        this.sweepingNegatedForTamed.tieToCategory(this.extraB);
        this.sweepingNegatedForTamed.setupTooltip(1);
        this.shieldChargePercentage = this.createInRange("shieldChargePercentage", 195, 1, 200, true);
        this.shieldChargePercentage.tieToCategory(this.extraI);
        this.shieldChargePercentage.setupTooltip(1);
        this.projectileDamage = this.createObject("projectileDamage", ProjectileDamage.DEFAULT, ProjectileDamage.class, ProjectileDamage.STREAM_CODEC);
        this.projectileDamage.tieToCategory(this.extraD);
        this.arrowDisableMode = this.createEnum("arrowDisableMode", ArrowDisableMode.NONE, ArrowDisableMode.class, ArrowDisableMode.values(), e -> class_2561.method_43471((String)("text.config.combatify-general.option.arrowDisableMode." + e.name().toLowerCase(Locale.ROOT))));
        this.arrowDisableMode.tieToCategory(this.extraE);
        this.arrowDisableMode.setupTooltip(7);
        this.armourPiercingMode = this.createEnum("armourPiercingMode", ArmourPiercingMode.VANILLA, ArmourPiercingMode.class, ArmourPiercingMode.values(), e -> class_2561.method_43471((String)("text.config.combatify-general.option.armourPiercingMode." + e.name().toLowerCase(Locale.ROOT))));
        this.armourPiercingMode.tieToCategory(this.extraE);
        this.armourPiercingMode.setupTooltip(4);
        this.enableDebugLogging = this.createBoolean("enableDebugLogging", false);
        this.enableDebugLogging.tieToCategory(this.debug);
    }

    @NotNull
    public List<AtlasConfig.Category> createCategories() {
        List categoryList = super.createCategories();
        this.ctsB = new AtlasConfig.Category((AtlasConfig)this, "cts_booleans", new ArrayList());
        this.ctsI = new AtlasConfig.Category((AtlasConfig)this, "cts_integers", new ArrayList());
        this.ctsD = new AtlasConfig.Category((AtlasConfig)this, "cts_doubles", new ArrayList());
        this.ctsE = new AtlasConfig.Category((AtlasConfig)this, "cts_enums", new ArrayList());
        this.extraB = new AtlasConfig.Category((AtlasConfig)this, "extra_booleans", new ArrayList());
        this.extraI = new AtlasConfig.Category((AtlasConfig)this, "extra_integers", new ArrayList());
        this.extraD = new AtlasConfig.Category((AtlasConfig)this, "extra_doubles", new ArrayList());
        this.extraE = new AtlasConfig.Category((AtlasConfig)this, "extra_enums", new ArrayList());
        this.debug = new AtlasConfig.Category((AtlasConfig)this, "debug_options", new ArrayList());
        categoryList.add(this.ctsB);
        categoryList.add(this.ctsI);
        categoryList.add(this.ctsD);
        categoryList.add(this.ctsE);
        categoryList.add(this.extraB);
        categoryList.add(this.extraI);
        categoryList.add(this.extraD);
        categoryList.add(this.extraE);
        categoryList.add(this.debug);
        return categoryList;
    }

    public void resetExtraHolders() {
    }

    public <T> void alertChange(AtlasConfig.ConfigValue<T> tConfigValue, T newValue) {
        T t = newValue;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Boolean.class, Boolean.class}, t, n)) {
                case 0: {
                    Boolean bool = (Boolean)t;
                    if (!tConfigValue.name().equals("percentageDamageEffects")) {
                        n = 1;
                        continue block5;
                    }
                    if (!Combatify.isLoaded) break block5;
                    if (bool.booleanValue()) {
                        ((class_1291)class_1294.field_5910.comp_349()).method_5566(class_5134.field_23721, class_2960.method_60656((String)"effect.strength"), 0.2, class_1322.class_1323.field_6331);
                        ((class_1291)class_1294.field_5911.comp_349()).method_5566(class_5134.field_23721, class_2960.method_60656((String)"effect.weakness"), -0.2, class_1322.class_1323.field_6331);
                        break block5;
                    }
                    ((class_1291)class_1294.field_5910.comp_349()).method_5566(class_5134.field_23721, class_2960.method_60656((String)"effect.strength"), 3.0, class_1322.class_1323.field_6328);
                    ((class_1291)class_1294.field_5911.comp_349()).method_5566(class_5134.field_23721, class_2960.method_60656((String)"effect.weakness"), -4.0, class_1322.class_1323.field_6328);
                    break block5;
                }
                case 1: {
                    Boolean bool = (Boolean)t;
                    if (!tConfigValue.name().equals("dispensableTridents")) {
                        n = 2;
                        continue block5;
                    }
                    if (!Combatify.isLoaded) break block5;
                    if (bool.booleanValue()) {
                        class_2315.method_58681((class_1935)class_1802.field_8547);
                        break block5;
                    }
                    class_2315.method_10009((class_1935)class_1802.field_8547, (class_2357)((class_2357)((Object2ObjectOpenHashMap)class_2315.field_10919).defaultReturnValue()));
                    break block5;
                }
                case 2: {
                    Boolean ignored = (Boolean)t;
                    if (!tConfigValue.name().equals("mobsCanGuard")) {
                        n = 3;
                        continue block5;
                    }
                    if (!Combatify.isLoaded) break block5;
                    Combatify.mobConfigIsDirty = true;
                    break block5;
                }
            }
            break;
        }
    }

    public <T> void alertClientValue(AtlasConfig.ConfigValue<T> configValue, T t, T t1) {
    }

    protected void loadExtra(JsonObject jsonObject) {
    }

    @Environment(value=EnvType.CLIENT)
    public class_437 createScreen(class_437 prevScreen) {
        return null;
    }

    public Boolean iFramesBasedOnWeapon() {
        return (Boolean)this.iFramesBasedOnWeapon.get();
    }

    public Boolean bowFatigue() {
        return (Boolean)this.bowFatigue.get();
    }

    public Boolean bedrockBridging() {
        return (Boolean)this.bedrockBridging.get();
    }

    public Boolean canAttackEarly() {
        return (Boolean)this.canAttackEarly.get();
    }

    public Boolean chargedAttacks() {
        return (Boolean)this.chargedAttacks.get();
    }

    public Boolean chargedReach() {
        return (Boolean)this.chargedReach.get();
    }

    public Boolean creativeAttackReach() {
        return (Boolean)this.creativeAttackReach.get();
    }

    public Boolean attackDecay() {
        return ((AttackDecay)this.attackDecay.get()).enabled;
    }

    public Boolean axesAreWeapons() {
        return (Boolean)this.axesAreWeapons.get();
    }

    public Boolean missedAttackRecovery() {
        return (Boolean)this.missedAttackRecovery.get();
    }

    public Boolean canSweepOnMiss() {
        return (Boolean)this.canSweepOnMiss.get();
    }

    public Boolean canInteractWhenCrouchShield() {
        return (Boolean)this.canInteractWhenCrouchShield.get();
    }

    public Boolean hasMissTime() {
        return (Boolean)this.hasMissTime.get();
    }

    public Boolean disableDuringShieldDelay() {
        return (Boolean)this.disableDuringShieldDelay.get();
    }

    public Boolean bedrockImpaling() {
        return (Boolean)this.bedrockImpaling.get();
    }

    public Boolean snowballKB() {
        return (Boolean)this.snowballKB.get();
    }

    public Boolean resetOnItemChange() {
        return (Boolean)this.resetOnItemChange.get();
    }

    public Boolean sweepWithSweeping() {
        return (Boolean)this.sweepWithSweeping.get();
    }

    public Boolean sweepingNegatedForTamed() {
        return (Boolean)this.sweepingNegatedForTamed.get();
    }

    public Boolean ctsMomentumPassedToProjectiles() {
        return (Boolean)this.ctsMomentumPassedToProjectiles.get();
    }

    public Boolean swingThroughGrass() {
        return (Boolean)this.swingThroughGrass.get();
    }

    public Boolean delayedEntityUpdates() {
        return (Boolean)this.delayedEntityUpdates.get();
    }

    public Boolean strengthAppliesToEnchants() {
        return (Boolean)this.strengthAppliesToEnchants.get();
    }

    public Boolean percentageDamageEffects() {
        return (Boolean)this.percentageDamageEffects.get();
    }

    public Boolean ctsKB() {
        return (Boolean)this.ctsKB.get();
    }

    public Boolean tierDamageNerf() {
        return (Boolean)this.tierDamageNerf.get();
    }

    public Boolean tridentVoidReturn() {
        return (Boolean)this.tridentVoidReturn.get();
    }

    public Boolean dispensableTridents() {
        return (Boolean)this.dispensableTridents.get();
    }

    public Boolean disableLoyaltyOnHitEntity() {
        return (Boolean)this.disableLoyaltyOnHitEntity.get();
    }

    public Boolean midairKB() {
        return (Boolean)this.midairKB.get();
    }

    public Boolean fishingHookKB() {
        return (Boolean)this.fishingHookKB.get();
    }

    public Boolean shieldOnlyWhenCharged() {
        return (Boolean)this.shieldOnlyWhenCharged.get();
    }

    public Boolean letVanillaConnect() {
        return (Boolean)this.letVanillaConnect.get();
    }

    public Boolean projectilesHaveIFrames() {
        return (Boolean)this.projectilesHaveIFrames.get();
    }

    public Boolean magicHasIFrames() {
        return (Boolean)this.magicHasIFrames.get();
    }

    public Boolean autoAttackAllowed() {
        return (Boolean)this.autoAttackAllowed.get();
    }

    public Boolean configOnlyWeapons() {
        return (Boolean)this.configOnlyWeapons.get();
    }

    public Boolean tieredShields() {
        return (Boolean)this.tieredShields.get();
    }

    public Boolean attackReach() {
        return (Boolean)this.attackReach.get();
    }

    public Boolean armorPiercingDisablesShields() {
        return (Boolean)this.armorPiercingDisablesShields.get();
    }

    public Boolean attackSpeed() {
        return (Boolean)this.attackSpeed.get();
    }

    public Boolean instaAttack() {
        return (Boolean)this.instaAttack.get();
    }

    public Boolean improvedMiscEntityAttacks() {
        return (Boolean)this.improvedMiscEntityAttacks.get();
    }

    public Boolean hasteFix() {
        return (Boolean)this.hasteFix.get();
    }

    public Boolean mobsCanGuard() {
        return (Boolean)this.mobsCanGuard.get();
    }

    public Boolean mobsCanSprint() {
        return (Boolean)this.mobsCanSprint.get();
    }

    public Boolean enableDebugLogging() {
        return (Boolean)this.enableDebugLogging.get();
    }

    public Integer shieldDelay() {
        return (Integer)this.shieldDelay.get();
    }

    public Integer instantHealthBonus() {
        return (Integer)this.instantHealthBonus.get();
    }

    public double attackDecayMinCharge() {
        return ((AttackDecay)this.attackDecay.get()).minCharge.doubleValue() / 100.0;
    }

    public double attackDecayMaxCharge() {
        return ((AttackDecay)this.attackDecay.get()).maxCharge.doubleValue() / 100.0;
    }

    public double attackDecayMaxChargeDiff() {
        double ret = this.attackDecayMaxCharge() - this.attackDecayMinCharge();
        if (ret <= 0.0) {
            ret = 1.0;
        }
        return ret;
    }

    public double attackDecayMinPercentageBase() {
        return ((AttackDecay)this.attackDecay.get()).minPercentageBase.doubleValue() / 100.0;
    }

    public double attackDecayMaxPercentageBaseDiff() {
        return ((AttackDecay)this.attackDecay.get()).maxPercentageBase.doubleValue() / 100.0 - this.attackDecayMinPercentageBase();
    }

    public double attackDecayMinPercentageEnchants() {
        return ((AttackDecay)this.attackDecay.get()).minPercentageEnchants.doubleValue() / 100.0;
    }

    public double attackDecayMaxPercentageEnchantsDiff() {
        return ((AttackDecay)this.attackDecay.get()).maxPercentageEnchants.doubleValue() / 100.0 - this.attackDecayMinPercentageEnchants();
    }

    public Integer shieldChargePercentage() {
        return (Integer)this.shieldChargePercentage.get();
    }

    public Double fistDamage() {
        return (Double)this.fistDamage.get();
    }

    public Double instantTippedArrowEffectMultiplier() {
        return (Double)this.instantTippedArrowEffectMultiplier.get();
    }

    public Double shieldDisableTime() {
        return (Double)this.shieldDisableTime.get();
    }

    public Double shieldProtectionArc() {
        return (Double)this.shieldProtectionArc.get();
    }

    public Double snowballDamage() {
        return ((ProjectileDamage)this.projectileDamage.get()).snowballDamage;
    }

    public Double eggDamage() {
        return ((ProjectileDamage)this.projectileDamage.get()).eggDamage;
    }

    public Double windChargeDamage() {
        return ((ProjectileDamage)this.projectileDamage.get()).windChargeDamage;
    }

    public Double thrownTridentDamage() {
        return ((ProjectileDamage)this.projectileDamage.get()).thrownTridentDamage;
    }

    public Double bowUncertainty() {
        return ((ProjectileUncertainty)this.projectileUncertainty.get()).bowUncertainty;
    }

    public Double crossbowUncertainty() {
        return ((ProjectileUncertainty)this.projectileUncertainty.get()).crossbowUncertainty;
    }

    public Double baseHandAttackSpeed() {
        return (Double)this.baseHandAttackSpeed.get();
    }

    public Double minHitboxSize() {
        return (Double)this.minHitboxSize.get();
    }

    public EatingInterruptionMode eatingInterruptionMode() {
        return (EatingInterruptionMode)((Object)this.eatingInterruptionMode.get());
    }

    public JSImpl getCritImpl() {
        return (JSImpl)this.critImpl.get();
    }

    public JSImpl getFoodImpl() {
        return (JSImpl)this.foodImpl.get();
    }

    public ArrowDisableMode arrowDisableMode() {
        return (ArrowDisableMode)((Object)this.arrowDisableMode.get());
    }

    public ArmourPiercingMode armourPiercingMode() {
        return (ArmourPiercingMode)((Object)this.armourPiercingMode.get());
    }

    public void setBridging(boolean allowBridging) {
        this.bedrockBridging.setValue((Object)allowBridging);
        this.bedrockBridging.serverManaged = true;
    }

    public static class ProjectileUncertainty
    implements ConfigRepresentable<ProjectileUncertainty> {
        public static final ProjectileUncertainty DEFAULT = new ProjectileUncertainty(null, 0.25, 0.25);
        public static final class_9139<class_9129, ProjectileUncertainty> STREAM_CODEC = new class_9139<class_9129, ProjectileUncertainty>(){

            public void encode(class_9129 registryFriendlyByteBuf, ProjectileUncertainty projectileUncertainty) {
                registryFriendlyByteBuf.method_10812(projectileUncertainty.owner.heldValue.owner().name);
                registryFriendlyByteBuf.method_10814(projectileUncertainty.owner.heldValue.name());
                registryFriendlyByteBuf.method_52940(projectileUncertainty.bowUncertainty.doubleValue());
                registryFriendlyByteBuf.method_52940(projectileUncertainty.crossbowUncertainty.doubleValue());
            }

            @NotNull
            public ProjectileUncertainty decode(class_9129 registryFriendlyByteBuf) {
                AtlasConfig config = (AtlasConfig)AtlasConfig.configs.get(registryFriendlyByteBuf.method_10810());
                return new ProjectileUncertainty((AtlasConfig.ConfigHolder<ProjectileUncertainty>)((AtlasConfig.ConfigHolder)config.valueNameToConfigHolderMap.get(registryFriendlyByteBuf.method_19772())), registryFriendlyByteBuf.readDouble(), registryFriendlyByteBuf.readDouble());
            }
        };
        public AtlasConfig.ConfigHolder<ProjectileUncertainty> owner;
        public Double bowUncertainty;
        public Double crossbowUncertainty;
        public static final Map<String, Field> fields = (Map)class_156.method_654(new HashMap(), hashMap -> {
            try {
                hashMap.put("bowUncertainty", ProjectileUncertainty.class.getDeclaredField("bowUncertainty"));
                hashMap.put("crossbowUncertainty", ProjectileUncertainty.class.getDeclaredField("crossbowUncertainty"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        });
        public static final BiFunction<ProjectileUncertainty, String, class_2561> convertFieldToComponent = (projectileUncertainty, string) -> {
            try {
                return class_2561.method_43471((String)(projectileUncertainty.owner.getTranslationKey() + "." + string)).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(projectileUncertainty.fieldRepresentingHolder((String)string).get(projectileUncertainty))));
            }
            catch (IllegalAccessException var3) {
                return class_2561.method_43471((String)(projectileUncertainty.owner.getTranslationKey() + "." + string));
            }
        };
        public static final BiFunction<ProjectileUncertainty, String, class_2561> convertFieldToNameComponent = (projectileUncertainty, string) -> class_2561.method_43471((String)(projectileUncertainty.owner.getTranslationKey() + "." + string));
        public static final BiFunction<ProjectileUncertainty, String, class_2561> convertFieldToValueComponent = (projectileUncertainty, string) -> {
            try {
                return class_2561.method_43470((String)String.valueOf(projectileUncertainty.fieldRepresentingHolder((String)string).get(projectileUncertainty)));
            }
            catch (IllegalAccessException var3) {
                return class_2561.method_43471((String)(projectileUncertainty.owner.getTranslationKey() + "." + string));
            }
        };
        public Supplier<class_2561> resetTranslation = null;

        public Double bowUncertainty() {
            return this.bowUncertainty;
        }

        public Double crossbowUncertainty() {
            return this.crossbowUncertainty;
        }

        public ProjectileUncertainty(AtlasConfig.ConfigHolder<ProjectileUncertainty> owner, Double bowUncertainty, Double crossbowUncertainty) {
            this.owner = owner;
            this.bowUncertainty = class_3532.method_15350((double)bowUncertainty, (double)0.0, (double)4.0);
            this.crossbowUncertainty = class_3532.method_15350((double)crossbowUncertainty, (double)0.0, (double)4.0);
        }

        public Codec<ProjectileUncertainty> getCodec(AtlasConfig.ConfigHolder<ProjectileUncertainty> configHolder) {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codecs.doubleRange((double)0.0, (double)4.0).optionalFieldOf("bowUncertainty", (Object)0.25).forGetter(ProjectileUncertainty::bowUncertainty), (App)Codecs.doubleRange((double)0.0, (double)4.0).optionalFieldOf("crossbowUncertainty", (Object)0.25).forGetter(ProjectileUncertainty::crossbowUncertainty)).apply((Applicative)instance, (bowUncertainty, crossbowUncertainty) -> new ProjectileUncertainty(configHolder, (Double)bowUncertainty, (Double)crossbowUncertainty)));
        }

        public void setOwnerHolder(AtlasConfig.ConfigHolder<ProjectileUncertainty> owner) {
            this.owner = owner;
        }

        public List<String> fields() {
            return fields.keySet().stream().toList();
        }

        public class_2561 getFieldValue(String name) {
            return convertFieldToValueComponent.apply(this, name);
        }

        public class_2561 getFieldName(String name) {
            return convertFieldToNameComponent.apply(this, name);
        }

        public void listField(String name, Consumer<class_2561> input) {
            input.accept(convertFieldToComponent.apply(this, name));
        }

        public void listFields(Consumer<class_2561> input) {
            fields.keySet().forEach(string -> input.accept(convertFieldToComponent.apply(this, (String)string)));
        }

        public Field fieldRepresentingHolder(String name) {
            return fields.get(name);
        }

        public ArgumentType<?> argumentTypeRepresentingHolder(String name) {
            Object o;
            try {
                o = fields.get(name).get(this);
            }
            catch (IllegalAccessException e) {
                return null;
            }
            Object object = o;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class}, (Object)object, n)) {
                case 0 -> {
                    Double ignored = (Double)object;
                    yield DoubleArgumentType.doubleArg((double)0.0, (double)4.0);
                }
                default -> null;
            };
        }

        @Environment(value=EnvType.CLIENT)
        public List<AbstractConfigListEntry<?>> transformIntoConfigEntries() {
            if (this.resetTranslation == null) {
                this.resetTranslation = () -> class_2561.method_43471((String)this.owner.getTranslationResetKey());
            }
            ArrayList entries = new ArrayList();
            entries.add((AbstractConfigListEntry<?>)new DoubleListEntry(convertFieldToNameComponent.apply(this, "bowUncertainty"), this.bowUncertainty, this.resetTranslation.get(), () -> 0.25, uncertainty -> {
                this.bowUncertainty = class_3532.method_15350((double)uncertainty, (double)0.0, (double)4.0);
            }, Optional::empty, false));
            entries.add((AbstractConfigListEntry<?>)new DoubleListEntry(convertFieldToNameComponent.apply(this, "crossbowUncertainty"), this.crossbowUncertainty, this.resetTranslation.get(), () -> 0.25, uncertainty -> {
                this.crossbowUncertainty = class_3532.method_15350((double)uncertainty, (double)0.0, (double)4.0);
            }, Optional::empty, false));
            entries.forEach(entry -> entry.setEditable(!this.owner.serverManaged));
            return entries;
        }
    }
}

