/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.atlas.combatify.util.blocking.condition.BlockingCondition;
import net.atlas.combatify.util.blocking.condition.BlockingConditions;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7417;
import net.minecraft.class_8824;
import net.minecraft.class_9285;
import net.minecraft.class_9704;
import net.minecraft.class_9711;
import net.minecraft.class_9723;

public record ComponentModifier(class_2561 tooltipComponent, class_9723 modifier, Optional<BlockingCondition> showInTooltip, float componentValueFactor) {
    public static final Codec<ComponentModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_8824.field_46597.fieldOf("tooltip").forGetter(ComponentModifier::tooltipComponent), (App)class_9723.field_51709.fieldOf("modifier").forGetter(ComponentModifier::modifier), (App)BlockingConditions.MAP_CODEC.codec().optionalFieldOf("show_in_tooltip").forGetter(ComponentModifier::showInTooltip), (App)class_5699.field_53754.optionalFieldOf("tooltip_value_factor", (Object)Float.valueOf(1.0f)).forGetter(ComponentModifier::componentValueFactor)).apply((Applicative)instance, ComponentModifier::new));
    public static final Codec<ComponentModifier> NO_CONDITION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_8824.field_46597.optionalFieldOf("tooltip", (Object)class_2561.method_43473()).forGetter(ComponentModifier::tooltipComponent), (App)class_9723.field_51709.fieldOf("modifier").forGetter(ComponentModifier::modifier), (App)class_5699.field_53754.optionalFieldOf("tooltip_value_factor", (Object)Float.valueOf(1.0f)).forGetter(ComponentModifier::componentValueFactor)).apply((Applicative)instance, ComponentModifier::new));

    public ComponentModifier(class_2561 tooltipComponent, class_9723 modifier, BlockingCondition showInTooltip, float componentValueFactor) {
        this(tooltipComponent, modifier, Optional.of(showInTooltip), componentValueFactor);
    }

    public ComponentModifier(class_2561 tooltipComponent, class_9723 modifier, float componentValueFactor) {
        this(tooltipComponent, modifier, Optional.empty(), componentValueFactor);
    }

    public float modifyValue(float value, int blockingLevel, class_5819 randomSource) {
        return this.modifier.method_60213(blockingLevel, randomSource, value);
    }

    public boolean matches(class_1799 itemStack) {
        return this.showInTooltip.isEmpty() || this.showInTooltip.get().appliesComponentModifier(itemStack);
    }

    public static class_2561 buildComponent(class_2561 base, float val) {
        class_7417 class_74172 = base.method_27661().method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatableContents = (class_2588)class_74172;
            Object[] args = new Object[]{class_9285.field_49329.format(val)};
            args = Arrays.copyOf(args, translatableContents.method_11023().length + 1);
            int i = 1;
            for (Object o : translatableContents.method_11023()) {
                if (i >= args.length) break;
                args[i] = o;
                ++i;
            }
            class_2588 copiedContents = new class_2588(translatableContents.method_11022(), translatableContents.method_48323(), args);
            return class_5250.method_43477((class_7417)copiedContents);
        }
        return base;
    }

    public List<class_2561> tryCombine(List<ComponentModifier> others, int blockingLevel, class_5819 randomSource) {
        ArrayList<class_2561> res = new ArrayList<class_2561>();
        float val = 0.0f;
        for (int i = others.size() - 1; i >= 0; --i) {
            ComponentModifier other = others.get(i);
            if (!this.tooltipComponent.equals((Object)other.tooltipComponent) || this.componentValueFactor != other.componentValueFactor) continue;
            val = other.modifyValue(val, blockingLevel, randomSource);
            others.remove(i);
        }
        if ((val *= this.componentValueFactor) > 0.0f) {
            res.add(ComponentModifier.buildComponent(this.tooltipComponent, val));
        }
        if (!others.isEmpty()) {
            others.getFirst().tryCombine(others, blockingLevel, randomSource);
        }
        return res;
    }

    public float tryCombineVal(List<ComponentModifier> others, int blockingLevel, class_5819 randomSource) {
        float val = 0.0f;
        for (ComponentModifier other : others) {
            val = other.modifyValue(val, blockingLevel, randomSource);
        }
        return val;
    }

    public record DataSet(float addValue, float multiplyValue) {
    }

    public record CombinedModifier(ComponentModifier base, ComponentModifier factor, Optional<BlockingCondition> showInTooltip) {
        public static Codec<CombinedModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NO_CONDITION_CODEC.fieldOf("base").forGetter(CombinedModifier::base), (App)NO_CONDITION_CODEC.fieldOf("factor").forGetter(CombinedModifier::factor), (App)BlockingConditions.MAP_CODEC.codec().optionalFieldOf("show_in_tooltip").forGetter(CombinedModifier::showInTooltip)).apply((Applicative)instance, CombinedModifier::new));

        public DataSet modifyValues(DataSet val, int blockingLevel, class_5819 randomSource) {
            return new DataSet(this.base.modifyValue(val.addValue, blockingLevel, randomSource), this.factor.modifyValue(val.multiplyValue, blockingLevel, randomSource));
        }

        public List<class_2561> tryCombine(List<CombinedModifier> others, int blockingLevel, class_5819 randomSource) {
            ArrayList<ComponentModifier> res = new ArrayList<ComponentModifier>();
            for (CombinedModifier other : others) {
                if (!other.base.tooltipComponent.equals((Object)class_2561.method_43473())) {
                    res.add(other.base);
                }
                if (other.factor.tooltipComponent.equals((Object)class_2561.method_43473())) continue;
                res.add(other.factor);
            }
            if (!res.isEmpty()) {
                return ((ComponentModifier)res.getFirst()).tryCombine(res, blockingLevel, randomSource);
            }
            return Collections.emptyList();
        }

        public DataSet tryCombineVal(List<CombinedModifier> others, int blockingLevel, class_5819 randomSource) {
            DataSet val = new DataSet(0.0f, 0.0f);
            for (CombinedModifier other : others) {
                val = other.modifyValues(val, blockingLevel, randomSource);
            }
            return val;
        }

        public boolean matches(class_1799 itemStack) {
            return this.showInTooltip.isEmpty() || this.showInTooltip.get().appliesComponentModifier(itemStack);
        }

        public static CombinedModifier createFactorOnly(ComponentModifier factor, Optional<BlockingCondition> showInTooltip) {
            return new CombinedModifier(new ComponentModifier((class_2561)class_2561.method_43473(), (class_9723)new class_9711((class_9704)new class_9704.class_9706(0.0f)), Optional.empty(), 1.0f), factor, showInTooltip);
        }

        public static CombinedModifier createBaseOnly(ComponentModifier base, Optional<BlockingCondition> showInTooltip) {
            return new CombinedModifier(base, new ComponentModifier((class_2561)class_2561.method_43473(), (class_9723)new class_9711((class_9704)new class_9704.class_9706(0.0f)), Optional.empty(), 1.0f), showInTooltip);
        }
    }
}

