/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.atlas.combatify.config.ConfigurableItemData;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ConfigurableEntityData(Optional<Integer> optionalAttackInterval, Optional<Boolean> optionalIsMiscEntity) {
    public static final ConfigurableEntityData EMPTY = new ConfigurableEntityData(Optional.empty(), Optional.empty());
    public static final MapCodec<ConfigurableEntityData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("attack_interval").forGetter(ConfigurableEntityData::optionalAttackInterval), (App)Codec.BOOL.optionalFieldOf("is_misc_entity").forGetter(ConfigurableEntityData::optionalIsMiscEntity)).apply((Applicative)instance, ConfigurableEntityData::new));
    public static final class_9139<? super ByteBuf, ConfigurableEntityData> ENTITY_DATA_STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56382((class_9139)class_9135.field_48550), ConfigurableEntityData::optionalAttackInterval, (class_9139)class_9135.method_56382((class_9139)class_9135.field_48547), ConfigurableEntityData::optionalIsMiscEntity, ConfigurableEntityData::new);

    public ConfigurableEntityData(Optional<Integer> optionalAttackInterval, Optional<Boolean> optionalIsMiscEntity) {
        this.optionalAttackInterval = ConfigurableItemData.clamp(optionalAttackInterval, 0, 1000);
        this.optionalIsMiscEntity = optionalIsMiscEntity;
    }

    public Integer attackInterval() {
        return this.optionalAttackInterval.orElse(null);
    }

    public Boolean isMiscEntity() {
        return this.optionalIsMiscEntity.orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurableEntityData)) {
            return false;
        }
        ConfigurableEntityData that = (ConfigurableEntityData)o;
        return Objects.equals(this.optionalAttackInterval, that.optionalAttackInterval) && Objects.equals(this.optionalIsMiscEntity, that.optionalIsMiscEntity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.optionalAttackInterval, this.optionalIsMiscEntity);
    }
}

