/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.networking;

import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ItemConfig;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class NetworkingHandler {
    public NetworkingHandler() {
        PayloadTypeRegistry.playC2S().register(ServerboundMissPacket.TYPE, ServerboundMissPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(ServerboundClientInformationExtensionPacket.TYPE, ServerboundClientInformationExtensionPacket.CODEC);
        PayloadTypeRegistry.configurationC2S().register(ServerboundClientInformationExtensionPacket.TYPE, ServerboundClientInformationExtensionPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RemainingUseSyncPacket.TYPE, RemainingUseSyncPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(UpdateBridgingStatusPacket.TYPE, UpdateBridgingStatusPacket.CODEC);
        PayloadTypeRegistry.configurationS2C().register(ClientboundClientInformationRetrievalPacket.TYPE, ClientboundClientInformationRetrievalPacket.CODEC);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ClientboundClientInformationRetrievalPacket.TYPE)) {
                handler.addTask((class_8605)new ClientRetrievalTask());
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register(Combatify.modDetectionNetworkChannel, (handler, server) -> {
            if (Combatify.unmoddedPlayers.contains(handler.field_14140.method_5667())) {
                Combatify.unmoddedPlayers.remove(handler.field_14140.method_5667());
                Combatify.isPlayerAttacking.remove(handler.field_14140.method_5667());
            }
            Combatify.moddedPlayers.remove(handler.field_14140.method_5667());
        });
        ServerPlayNetworking.registerGlobalReceiver(ServerboundMissPacket.TYPE, (packet, context) -> {
            class_3222 player = context.player().field_13987.method_32311();
            class_3218 serverLevel = player.method_51469();
            player.method_14234();
            if (!serverLevel.method_8621().method_11952(player.method_24515())) {
                return;
            }
            player.combatify$attackAir();
        });
        ServerConfigurationNetworking.registerGlobalReceiver(ServerboundClientInformationExtensionPacket.TYPE, (payload, context) -> {
            context.networkHandler().combatify$setShieldOnCrouch(payload.useShieldOnCrouch);
            context.networkHandler().completeTask(ClientRetrievalTask.TYPE);
        });
        ServerPlayNetworking.registerGlobalReceiver(ServerboundClientInformationExtensionPacket.TYPE, (payload, context) -> context.player().field_13987.method_32311().combatify$setShieldOnCrouch(payload.useShieldOnCrouch));
        ServerPlayConnectionEvents.JOIN.register(Combatify.modDetectionNetworkChannel, (handler, sender, server) -> {
            boolean bl;
            boolean bl2 = bl = Combatify.CONFIG.configOnlyWeapons() != false || Combatify.CONFIG.letVanillaConnect() == false;
            if (!ServerPlayNetworking.canSend((class_3222)handler.field_14140, RemainingUseSyncPacket.TYPE)) {
                if (bl) {
                    handler.field_14140.field_13987.method_52396((class_2561)class_2561.method_43470((String)"Combatify needs to be installed on the client to join this server!"));
                    return;
                }
                Combatify.unmoddedPlayers.add(handler.field_14140.method_5667());
                Combatify.isPlayerAttacking.put(handler.field_14140.method_5667(), true);
                Combatify.LOGGER.info("Unmodded player joined: " + String.valueOf(handler.field_14140.method_5667()));
                return;
            }
            Combatify.moddedPlayers.add(handler.field_14140.method_5667());
        });
        ServerLifecycleEvents.SERVER_STARTED.register(Combatify.modDetectionNetworkChannel, server -> {
            Combatify.ITEMS = new ItemConfig();
        });
    }

    public record ServerboundMissPacket() implements class_8710
    {
        public static final class_8710.class_9154<ServerboundMissPacket> TYPE = new class_8710.class_9154(Combatify.id("miss_attack"));
        public static final class_9139<class_2540, ServerboundMissPacket> CODEC = class_8710.method_56484(ServerboundMissPacket::write, ServerboundMissPacket::new);

        public ServerboundMissPacket(class_2540 buf) {
            this();
        }

        public void write(class_2540 buf) {
        }

        @NotNull
        public class_8710.class_9154<?> method_56479() {
            return TYPE;
        }
    }

    public record ServerboundClientInformationExtensionPacket(boolean useShieldOnCrouch) implements class_8710
    {
        public static final class_8710.class_9154<ServerboundClientInformationExtensionPacket> TYPE = new class_8710.class_9154(Combatify.id("client_extras"));
        public static final class_9139<class_2540, ServerboundClientInformationExtensionPacket> CODEC = class_8710.method_56484(ServerboundClientInformationExtensionPacket::write, ServerboundClientInformationExtensionPacket::new);

        public ServerboundClientInformationExtensionPacket(class_2540 buf) {
            this(buf.readBoolean());
        }

        public void write(class_2540 buf) {
            buf.method_52964(this.useShieldOnCrouch);
        }

        @NotNull
        public class_8710.class_9154<?> method_56479() {
            return TYPE;
        }
    }

    public record RemainingUseSyncPacket(int id, int ticks) implements class_8710
    {
        public static final class_8710.class_9154<RemainingUseSyncPacket> TYPE = new class_8710.class_9154(Combatify.id("remaining_use_ticks"));
        public static final class_9139<class_2540, RemainingUseSyncPacket> CODEC = class_8710.method_56484(RemainingUseSyncPacket::write, RemainingUseSyncPacket::new);

        public RemainingUseSyncPacket(class_2540 buf) {
            this(buf.method_10816(), buf.readInt());
        }

        public void write(class_2540 buf) {
            buf.method_10804(this.id);
            buf.method_53002(this.ticks);
        }

        @NotNull
        public class_8710.class_9154<?> method_56479() {
            return TYPE;
        }
    }

    public record UpdateBridgingStatusPacket(boolean enableBridging) implements class_8710
    {
        public static final class_8710.class_9154<UpdateBridgingStatusPacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"c", (String)"update_status"));
        public static final class_9139<class_2540, UpdateBridgingStatusPacket> CODEC = class_8710.method_56484(UpdateBridgingStatusPacket::write, UpdateBridgingStatusPacket::new);

        public UpdateBridgingStatusPacket(class_2540 buf) {
            this(buf.readBoolean());
        }

        public void write(class_2540 buf) {
            buf.method_52964(this.enableBridging);
        }

        @NotNull
        public class_8710.class_9154<?> method_56479() {
            return TYPE;
        }
    }

    public record ClientboundClientInformationRetrievalPacket() implements class_8710
    {
        public static final class_8710.class_9154<ClientboundClientInformationRetrievalPacket> TYPE = new class_8710.class_9154(Combatify.id("client_retrieval"));
        public static final class_9139<class_2540, ClientboundClientInformationRetrievalPacket> CODEC = class_8710.method_56484(ClientboundClientInformationRetrievalPacket::write, ClientboundClientInformationRetrievalPacket::new);

        public ClientboundClientInformationRetrievalPacket(class_2540 buf) {
            this();
        }

        public void write(class_2540 buf) {
        }

        @NotNull
        public class_8710.class_9154<?> method_56479() {
            return TYPE;
        }
    }

    public record ClientRetrievalTask() implements class_8605
    {
        public static final class_8605.class_8606 TYPE = new class_8605.class_8606(Combatify.id("client_info_retrieval").toString());

        public void method_52376(Consumer<class_2596<?>> sender) {
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)new ClientboundClientInformationRetrievalPacket()));
        }

        @NotNull
        public class_8605.class_8606 method_52375() {
            return TYPE;
        }
    }
}

