/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.item.WeaponType;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.component.PatchGenerator;
import net.atlas.defaulted.component.ToolMaterialWrapper;
import net.atlas.defaulted.component.generators.WeaponLevelBasedValue;
import net.atlas.defaulted.extension.ItemExtensions;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9335;

public record WeaponStatsGenerator(Optional<WeaponLevelBasedValue> damage, Optional<WeaponLevelBasedValue> speed, Optional<WeaponLevelBasedValue> reach, Optional<class_2960> damageIdOverride, Optional<class_2960> speedIdOverride, Optional<class_2960> reachIdOverride, List<class_9285.class_9287> additionalModifiers, boolean tieredDamage, boolean persistPrevious) implements PatchGenerator
{
    public static final MapCodec<WeaponStatsGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_damage").forGetter(WeaponStatsGenerator::damage), (App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_speed").forGetter(WeaponStatsGenerator::speed), (App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_reach").forGetter(WeaponStatsGenerator::reach), (App)class_2960.field_25139.optionalFieldOf("damage_id_override").forGetter(WeaponStatsGenerator::damageIdOverride), (App)class_2960.field_25139.optionalFieldOf("speed_id_override").forGetter(WeaponStatsGenerator::speedIdOverride), (App)class_2960.field_25139.optionalFieldOf("reach_id_override").forGetter(WeaponStatsGenerator::reachIdOverride), (App)class_9285.class_9287.field_49332.listOf().optionalFieldOf("additional_modifiers", Collections.emptyList()).forGetter(WeaponStatsGenerator::additionalModifiers), (App)Codec.BOOL.optionalFieldOf("apply_tier_to_damage", (Object)true).forGetter(WeaponStatsGenerator::tieredDamage), (App)Codec.BOOL.fieldOf("persist_previous").forGetter(WeaponStatsGenerator::persistPrevious)).apply((Applicative)instance, WeaponStatsGenerator::new));

    public void patchDataComponentMap(class_1792 item, class_9335 patchedDataComponentMap) {
        class_9285 oldModifiers = (class_9285)patchedDataComponentMap.method_57829(class_9334.field_49636);
        ToolMaterialWrapper toolMaterialWrapper = ((ItemExtensions)item).defaulted$getToolMaterial();
        if (toolMaterialWrapper == null) {
            toolMaterialWrapper = Defaulted.DEFAULT_WRAPPER;
        }
        class_9285.class_9286 builder = class_9285.method_57480();
        double damageModifier = 2.0 - Combatify.CONFIG.fistDamage();
        class_2960 damageID = this.damageIdOverride.orElse(class_1792.field_8006);
        class_2960 speedID = this.speedIdOverride.orElse(WeaponType.BASE_ATTACK_SPEED_CTS_ID);
        class_2960 reachID = this.reachIdOverride.orElse(WeaponType.BASE_ATTACK_REACH_ID);
        class_1322 attackDamage = null;
        boolean hasDamage = false;
        if (this.damage.isPresent()) {
            hasDamage = true;
            attackDamage = new class_1322(damageID, (double)this.damage.get().getResult(toolMaterialWrapper.weaponLevel(), toolMaterialWrapper.attackDamageBonus(), this.tieredDamage).floatValue() + damageModifier, class_1322.class_1323.field_6328);
        }
        class_1322 attackSpeed = null;
        boolean hasSpeed = false;
        if (this.speed.isPresent()) {
            hasSpeed = true;
            attackSpeed = new class_1322(speedID, (double)this.speed.get().getResult(toolMaterialWrapper.speedLevel(), true).floatValue(), class_1322.class_1323.field_6328);
        }
        class_1322 attackReach = null;
        boolean hasReach = false;
        if (this.reach.isPresent()) {
            hasReach = true;
            attackReach = new class_1322(reachID, (double)this.reach.get().getResult(toolMaterialWrapper.weaponLevel(), true).floatValue(), class_1322.class_1323.field_6328);
        }
        if (!hasDamage && !hasSpeed) {
            return;
        }
        for (class_9285.class_9287 entry : this.additionalModifiers) {
            if (hasDamage && entry.method_60767(class_5134.field_23721, damageID) || hasSpeed && this.isSpeed(entry, speedID) || hasReach && entry.method_60767(class_5134.field_47759, reachID)) continue;
            builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
        }
        if (this.persistPrevious && oldModifiers != null) {
            for (class_9285.class_9287 entry : oldModifiers.comp_2393()) {
                if (hasDamage && entry.method_60767(class_5134.field_23721, damageID) || hasSpeed && this.isSpeed(entry, speedID) || hasReach && entry.method_60767(class_5134.field_47759, reachID)) continue;
                builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
            }
        }
        if (hasDamage) {
            builder.method_57487(class_5134.field_23721, attackDamage, class_9274.field_49217);
        }
        if (hasSpeed) {
            builder.method_57487(class_5134.field_23723, attackSpeed, class_9274.field_49217);
        }
        if (hasReach) {
            builder.method_57487(class_5134.field_47759, attackReach, class_9274.field_49217);
        }
        patchedDataComponentMap.method_57938(class_9334.field_49636, (Object)builder.method_57486());
    }

    private boolean isSpeed(class_9285.class_9287 entry, class_2960 speedID) {
        boolean baseRet = entry.method_60767(class_5134.field_23723, speedID);
        if (speedID.equals((Object)WeaponType.BASE_ATTACK_SPEED_CTS_ID)) {
            baseRet |= entry.method_60767(class_5134.field_23723, class_1792.field_8001);
        }
        return baseRet;
    }

    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }
}

