/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.lang.runtime.SwitchBootstraps;
import java.util.UUID;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.EatingInterruptionMode;
import net.atlas.combatify.extensions.LivingEntityExtensions;
import net.atlas.combatify.networking.NetworkingHandler;
import net.atlas.combatify.util.MethodHandler;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class}, priority=1400)
public abstract class LivingEntityMixin
extends class_1297
implements LivingEntityExtensions {
    @Unique
    private double piercingNegation;
    @Unique
    private class_1796 fallbackCooldowns = MethodHandler.createItemCooldowns();
    @Unique
    protected int attackStrengthMaxValue;
    @Unique
    class_1309 thisEntity = (class_1309)class_1309.class.cast(this);
    @Shadow
    protected int field_6222;
    @Shadow
    public int field_6273;

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    public abstract class_1799 method_6030();

    @Shadow
    public abstract void method_48761(double var1, double var3);

    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    @Override
    public class_1796 combatify$getFallbackCooldowns() {
        return this.fallbackCooldowns;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tickCooldowns(CallbackInfo ci) {
        this.fallbackCooldowns.method_7903();
        if (!(this.thisEntity instanceof class_1657)) {
            ++this.field_6273;
        }
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit) {
        this.resetAttackStrengthTicker(false);
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit, boolean force) {
        this.resetAttackStrengthTicker(force);
    }

    @Unique
    public void resetAttackStrengthTicker(boolean force) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return;
        }
        if (Combatify.CONFIG.attackSpeed() == false && this.method_45325((class_6880<class_1320>)class_5134.field_23723) - 1.5 >= 20.0 || Combatify.CONFIG.instaAttack().booleanValue()) {
            return;
        }
        int chargeTicks = MethodHandler.getCurrentItemAttackStrengthDelay((class_1309)class_1309.class.cast(this));
        if (force || chargeTicks > this.attackStrengthMaxValue - this.field_6273) {
            if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                Combatify.LOGGER.info("Ticks for charge: " + chargeTicks);
            }
            this.attackStrengthMaxValue = chargeTicks;
            this.field_6273 = 0;
        }
    }

    @Override
    public boolean combatify$isAttackAvailable(float baseTime) {
        return (float)this.attackStrengthMaxValue - ((float)this.field_6273 + baseTime) <= 0.0f;
    }

    @ModifyReturnValue(method={"isBlocking"}, at={@At(value="RETURN")})
    public boolean isBlocking(boolean original) {
        return !MethodHandler.getBlockingItem(this.thisEntity).stack().method_7960();
    }

    @Inject(method={"blockedByShield"}, at={@At(value="HEAD")}, cancellable=true)
    public void blockedByShield(class_1309 target, CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public void combatify$setPiercingNegation(double negation) {
        this.piercingNegation = negation;
    }

    @Override
    public double combatify$getPiercingNegation() {
        return this.piercingNegation;
    }

    @ModifyConstant(method={"handleDamageEvent"}, constant={@Constant(intValue=20, ordinal=0)})
    private int syncInvulnerability(int x) {
        return 10;
    }

    @WrapOperation(method={"hurtServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z")})
    public boolean shield(class_1309 instance, class_1282 source, Operation<Boolean> original, @Local(ordinal=0, argsOnly=true) class_3218 serverLevel, @Local(ordinal=0, argsOnly=true) LocalFloatRef amount, @Local(ordinal=2) LocalFloatRef protectedDamage, @Local(ordinal=0) LocalBooleanRef wasBlocked, @Share(value="blocked") LocalBooleanRef blocked) {
        class_1799 itemStack = MethodHandler.getBlockingItem(this.thisEntity).stack();
        if (amount.get() > 0.0f && ((Boolean)original.call(new Object[]{instance, source})).booleanValue()) {
            MethodHandler.getBlocking(itemStack).block(serverLevel, instance, source, itemStack, amount, protectedDamage, wasBlocked);
        }
        blocked.set(wasBlocked.get());
        return false;
    }

    @Inject(method={"hurtServer"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;invulnerableTime:I", ordinal=1, shift=At.Shift.AFTER)})
    public void injectEatingInterruption(class_3218 serverLevel, class_1282 source, float f, CallbackInfoReturnable<Boolean> cir) {
        boolean canInterrupt;
        class_1297 entity = source.method_5529();
        boolean bl = canInterrupt = this.thisEntity.method_6115() && (this.method_6030().method_7976() == class_1839.field_8950 || this.method_6030().method_7976() == class_1839.field_8946);
        if (entity instanceof class_1309 && canInterrupt) {
            EatingInterruptionMode eatingInterruptionMode = Combatify.CONFIG.eatingInterruptionMode();
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FULL_RESET", "DELAY"}, (EatingInterruptionMode)eatingInterruptionMode, n)) {
                case 0: {
                    int n2 = this.thisEntity.method_6030().method_7935(this.thisEntity);
                    break;
                }
                case 1: {
                    int n2 = this.field_6222 + this.field_6008;
                    break;
                }
                default: {
                    int n2 = this.field_6222 = this.field_6222;
                }
            }
            if (Combatify.CONFIG.eatingInterruptionMode() != EatingInterruptionMode.OFF) {
                for (UUID playerUUID : Combatify.moddedPlayers) {
                    class_1657 class_16572 = serverLevel.method_18470(playerUUID);
                    if (!(class_16572 instanceof class_3222)) continue;
                    class_3222 serverPlayer = (class_3222)class_16572;
                    ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new NetworkingHandler.RemainingUseSyncPacket(this.method_5628(), this.field_6222));
                }
            }
        }
    }

    @ModifyExpressionValue(method={"hurtServer"}, at={@At(value="CONSTANT", args={"floatValue=10.0F"}, ordinal=0)})
    public float changeIFrames(float constant) {
        return constant - 10.0f;
    }

    @WrapOperation(method={"hurtServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    public void modifyKB(class_1309 instance, double d, double e, double f, Operation<Void> original, @Local(ordinal=0, argsOnly=true) class_1282 source, @Local(argsOnly=true) float amount, @Share(value="blocked") LocalBooleanRef bl) {
        if (bl.get() && amount > 0.0f) {
            this.method_48761(e, f);
        }
        Combatify.CONFIG.knockbackMode().runKnockback(instance, source, d, e, f, (xva$0, xva$1, xva$2, xva$3) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1, xva$2, xva$3});
        });
    }

    @ModifyExpressionValue(method={"startUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isUsingItem()Z")})
    public boolean addCooldownCheck(boolean original, @Local(ordinal=0) class_1799 itemStack) {
        return original || MethodHandler.getCooldowns(this.thisEntity).method_7904(itemStack);
    }

    @ModifyExpressionValue(method={"isDamageSourceBlocked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;getPierceLevel()B")})
    public byte isDamageSourceBlocked(byte original) {
        return Combatify.CONFIG.arrowDisableMode().pierceArrowsBlocked() ? (byte)0 : original;
    }

    @ModifyReturnValue(method={"isDamageSourceBlocked"}, at={@At(value="RETURN", ordinal=0)})
    public boolean isDamageSourceBlocked(boolean original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return Combatify.CONFIG.shieldProtectionArc() == 0.0 || original;
    }

    @ModifyExpressionValue(method={"isDamageSourceBlocked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;dot(Lnet/minecraft/world/phys/Vec3;)D")})
    public double modifyDotResultToGetRadians(double original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return Combatify.CONFIG.shieldProtectionArc() == 90.0 ? original : Math.acos(original) / -1.0;
    }

    @ModifyExpressionValue(method={"isDamageSourceBlocked"}, at={@At(value="CONSTANT", args={"doubleValue=0.0"}, ordinal=1)})
    public double modifyCompareValue(double original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return Combatify.CONFIG.shieldProtectionArc() == 90.0 ? original : Math.toRadians(Combatify.CONFIG.shieldProtectionArc()) / -1.0;
    }

    @ModifyReturnValue(method={"getItemBlockingWith"}, at={@At(value="RETURN")})
    public class_1799 removeMojangStupidity(class_1799 original) {
        return (original == null || !(original.method_7909() instanceof class_1819)) && !MethodHandler.getBlockingItem(this.thisEntity).stack().method_7960() ? class_1802.field_8255.method_7854() : original;
    }

    @Override
    public boolean combatify$hasEnabledShieldOnCrouch() {
        return true;
    }

    @Override
    public void combatify$setUseItemRemaining(int ticks) {
        this.field_6222 = ticks;
    }
}

