/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.damage_parsers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.atlas.combatify.util.blocking.BlockingTypeInit;
import net.atlas.combatify.util.blocking.ComponentModifier;
import net.atlas.combatify.util.blocking.damage_parsers.Nullify;
import net.atlas.combatify.util.blocking.damage_parsers.PercentageBase;
import net.atlas.combatify.util.blocking.damage_parsers.PercentageLimit;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8129;

public interface DamageParser {
    public static final Codec<DamageParser> CODEC = BlockingTypeInit.DAMAGE_PARSER_TYPE_REG.method_39673().dispatch(DamageParser::codec, mapCodec -> mapCodec);

    public static void bootstrap(class_2378<MapCodec<? extends DamageParser>> registry) {
        class_2378.method_10226(registry, (String)"percentage_base", PercentageBase.CODEC);
        class_2378.method_10226(registry, (String)"percentage_limit", PercentageLimit.CODEC);
        class_2378.method_10226(registry, (String)"nullify", Nullify.CODEC);
    }

    public float parse(float var1, ComponentModifier.DataSet var2, class_6880<class_8110> var3);

    public MapCodec<? extends DamageParser> codec();

    public List<class_8129<class_8110>> requirements();

    public boolean enforceAll();

    default public boolean allAre(class_6880<class_8110> damageType) {
        if (this.requirements().isEmpty()) {
            return true;
        }
        boolean enforce = this.enforceAll();
        for (class_8129<class_8110> requirement : this.requirements()) {
            boolean matches = requirement.method_48967(damageType);
            if (matches == enforce) continue;
            return matches;
        }
        return enforce;
    }

    public static <D extends DamageParser> MapCodec<D> mapCodec(BiFunction<List<class_8129<class_8110>>, Boolean, D> creator) {
        return RecordCodecBuilder.mapCodec((T instance) -> instance.group((App)class_8129.method_53245((class_5321)class_7924.field_42534).listOf().optionalFieldOf("damage_types", Collections.emptyList()).forGetter(DamageParser::requirements), (App)Codec.BOOL.optionalFieldOf("enforce_all", (Object)true).forGetter(DamageParser::enforceAll)).apply((Applicative)instance, creator));
    }
}

