/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.component;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.UnaryOperator;
import net.atlas.combatify.component.custom.ProtectionBaseFactor;
import net.atlas.combatify.util.blocking.effect.PostBlockEffect;
import net.atlas.combatify.util.blocking.effect.PostBlockEffects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CustomEnchantmentEffectComponents {
    private static final DeferredRegister.DataComponents ENCHANTMENT_EFFECT_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, (String)"combatify");
    public static DeferredHolder<DataComponentType<?>, DataComponentType<List<TargetedConditionalEffect<PostBlockEffect>>>> POST_BLOCK_EFFECTS = CustomEnchantmentEffectComponents.register("post_block_effects", builder -> builder.persistent(TargetedConditionalEffect.codec(PostBlockEffects.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).listOf()));
    public static DeferredHolder<DataComponentType<?>, DataComponentType<List<ProtectionBaseFactor>>> SHIELD_EFFECTIVENESS = CustomEnchantmentEffectComponents.register("shield_effectiveness", builder -> builder.persistent(ProtectionBaseFactor.CODEC.listOf()));
    public static DeferredHolder<DataComponentType<?>, DataComponentType<List<TargetedConditionalEffect<EnchantmentValueEffect>>>> SHIELD_DISABLE = CustomEnchantmentEffectComponents.register("shield_disable_time", builder -> builder.persistent(TargetedConditionalEffect.equipmentDropsCodec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).listOf()));

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String string, UnaryOperator<DataComponentType.Builder<T>> unaryOperator) {
        return ENCHANTMENT_EFFECT_COMPONENTS.registerComponentType(string, unaryOperator);
    }

    public static void registerEnchantmentEffectComponents(IEventBus bus) {
        ENCHANTMENT_EFFECT_COMPONENTS.register(bus);
    }
}

