/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.component.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record CanSweep(boolean enabled, boolean showInTooltip) implements TooltipProvider
{
    public static final CanSweep DISABLED = new CanSweep(false, false);
    public static final Codec<CanSweep> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)Boolean.TRUE).forGetter(CanSweep::enabled), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)Boolean.FALSE).forGetter(CanSweep::showInTooltip)).apply((Applicative)instance, CanSweep::new));
    public static final Codec<CanSweep> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Codec.BOOL.xmap(enabled -> new CanSweep((boolean)enabled, false), CanSweep::enabled));
    public static final StreamCodec<ByteBuf, CanSweep> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, CanSweep::enabled, (StreamCodec)ByteBufCodecs.BOOL, CanSweep::showInTooltip, CanSweep::new);
    private static final Component TOOLTIP = Component.translatableWithFallback((String)"item.can_sweep", (String)"Able to Sweep").withStyle(ChatFormatting.BLUE);

    public void addToTooltip(Item.TooltipContext tooltipContext, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        if (this.showInTooltip && this.enabled) {
            consumer.accept(TOOLTIP);
        }
    }
}

