/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableEntityData;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.JSImpl;
import net.atlas.combatify.item.CombatifyItemTags;
import net.atlas.combatify.util.blocking.BlockingType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ItemConfig
extends AtlasConfig {
    public static final List<RegistryConfigDataWrapper<Item, ConfigurableItemData>> DEFAULT_ITEMS = List.of(new RegistryConfigDataWrapper(HolderSet.direct((Holder[])new Holder[0]), List.of(CombatifyItemTags.PROJECTILES_WITH_COOLDOWNS), new ConfigurableItemData(null, 0.2)), new RegistryConfigDataWrapper(HolderSet.direct((Holder[])new Holder[0]), List.of(CombatifyItemTags.FAST_DRINKABLES), new ConfigurableItemData(1.0, null)));
    public boolean isModifying = false;
    public AtlasConfig.TagHolder<List<RegistryConfigDataWrapper<EntityType<?>, ConfigurableEntityData>>> entities;
    public AtlasConfig.TagHolder<List<RegistryConfigDataWrapper<Item, ConfigurableItemData>>> items;
    public AtlasConfig.TagHolder<JSImpl> armourCalcs;
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceLocation> RESOURCE_NAME_STREAM_CODEC = StreamCodec.of(FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::readResourceLocation);
    public static final MapCodec<RegistryConfigDataWrapper<Item, ConfigurableItemData>> ITEMS_CODEC = RegistryConfigDataWrapper.mapCodec(BuiltInRegistries.ITEM, holder -> holder.is((Holder)Items.AIR.builtInRegistryHolder()) ? DataResult.error(() -> "Item must not be minecraft:air", (Object)holder) : DataResult.success((Object)holder), ConfigurableItemData.CODEC);
    public static final MapCodec<RegistryConfigDataWrapper<EntityType<?>, ConfigurableEntityData>> ENTITIES_CODEC = RegistryConfigDataWrapper.mapCodec(BuiltInRegistries.ENTITY_TYPE, DataResult::success, ConfigurableEntityData.CODEC);

    public ItemConfig() {
        super(Combatify.id("combatify-items-1.21-v3"));
    }

    public void reloadFromDefault() {
        super.reloadFromDefault();
    }

    public void handleExtraSync(AtlasCore.AtlasConfigPacket atlasConfigPacket, ClientPlayNetworking.Context context) {
        if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
            Combatify.LOGGER.info("Loading config details from buffer.");
        }
    }

    public void handleConfigInformation(AtlasCore.ClientInformPacket clientInformPacket, ServerPlayer serverPlayer, PacketSender packetSender) {
    }

    protected void loadExtra(JsonObject object) {
        this.isModifying = true;
        if (!object.has("blocking_types")) {
            object.add("blocking_types", (JsonElement)new JsonArray());
        }
        JsonElement defenders = object.get("blocking_types");
        Combatify.registeredTypes = new HashMap<ResourceLocation, BlockingType>(Combatify.defaultTypes);
        List altered = (List)BlockingType.CODEC.listOf().orElse(Collections.emptyList()).parse((DynamicOps)JsonOps.INSTANCE, (Object)defenders).getOrThrow();
        altered.forEach(Combatify::registerBlockingType);
        this.isModifying = false;
    }

    public void defineConfigHolders() {
        this.items = this.createCodecBacked("items", DEFAULT_ITEMS, ITEMS_CODEC.codec().listOf());
        this.entities = this.createCodecBacked("entities", new ArrayList(), ENTITIES_CODEC.codec().listOf());
        this.armourCalcs = this.createCodecBacked("armor_calculation", new JSImpl("armor_calculations"), JSImpl.CODEC);
    }

    public void resetExtraHolders() {
        Combatify.registeredTypes = new HashMap<ResourceLocation, BlockingType>(Combatify.defaultTypes);
    }

    public <T> void alertChange(AtlasConfig.ConfigValue<T> tConfigValue, T newValue) {
    }

    public <T> void alertClientValue(AtlasConfig.ConfigValue<T> configValue, T t, T t1) {
    }

    public AtlasConfig readClientConfigInformation(RegistryFriendlyByteBuf buf) {
        super.readClientConfigInformation(buf);
        ItemConfig.readMap(buf, RESOURCE_NAME_STREAM_CODEC, BlockingType.FULL_STREAM_CODEC);
        return this;
    }

    public ItemConfig loadFromNetwork(RegistryFriendlyByteBuf buf) {
        super.loadFromNetwork(buf);
        Combatify.registeredTypes = ItemConfig.readMap(buf, RESOURCE_NAME_STREAM_CODEC, BlockingType.FULL_STREAM_CODEC);
        return this;
    }

    public void saveToNetwork(RegistryFriendlyByteBuf buf) {
        super.saveToNetwork(buf);
        ItemConfig.writeMap(buf, Combatify.registeredTypes, RESOURCE_NAME_STREAM_CODEC, BlockingType.FULL_STREAM_CODEC);
    }

    public JsonElement saveExtra(JsonElement jsonElement) {
        JsonArray defenders = new JsonArray();
        ArrayList<BlockingType> blockingTypes = new ArrayList<BlockingType>(Combatify.registeredTypes.values());
        blockingTypes.removeIf(Combatify.defaultTypes::containsValue);
        defenders = (JsonElement)BlockingType.CODEC.listOf().encode(blockingTypes, (DynamicOps)JsonOps.INSTANCE, (Object)defenders).getOrThrow();
        JsonObject result = jsonElement.getAsJsonObject();
        result.add("blocking_types", (JsonElement)defenders);
        return result;
    }

    public static <B extends FriendlyByteBuf, K, V> Map<K, V> readMap(B buf, StreamCodec<B, K> keyCodec, StreamCodec<B, V> valueCodec) {
        return ItemConfig.readMap(buf, Maps::newHashMapWithExpectedSize, keyCodec, valueCodec);
    }

    public static <B extends FriendlyByteBuf, K, V, M extends Map<K, V>> M readMap(B buf, IntFunction<M> intFunction, StreamCodec<B, K> keyCodec, StreamCodec<B, V> valueCodec) {
        int size = buf.readVarInt();
        Map map = (Map)intFunction.apply(size);
        for (int index = 0; index < size; ++index) {
            Object key = keyCodec.decode(buf);
            Object value = valueCodec.decode(buf);
            map.put(key, value);
        }
        return (M)map;
    }

    public static <B extends FriendlyByteBuf, K, V> void writeMap(B buf, Map<K, V> map, StreamCodec<B, K> keyCodec, StreamCodec<B, V> valueCodec) {
        buf.writeVarInt(map.size());
        map.forEach((key, value) -> {
            keyCodec.encode((Object)buf, key);
            valueCodec.encode((Object)buf, value);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public Screen createScreen(Screen prevScreen) {
        return null;
    }

    public static void noNamePresent(RegistryConfigDataWrapper<?, ?> invalid, String stage) {
        Combatify.LOGGER.error("No name is present: " + String.valueOf(invalid) + ", no changes will occur. This may be due to an incorrectly written config file. " + ItemConfig.errorStage(stage));
    }

    public static String errorStage(String stage) {
        return "[Config Stage]: " + stage;
    }

    public record RegistryConfigDataWrapper<T, U>(HolderSet.Direct<T> holders, List<TagKey<T>> tagKeys, U configurableData) implements ConfigDataWrapper<Holder<T>, U>
    {
        public static final RegistryConfigDataWrapper<Item, ConfigurableItemData> EMPTY_ITEM = new RegistryConfigDataWrapper(HolderSet.direct((Holder[])new Holder[0]), Collections.emptyList(), ConfigurableItemData.EMPTY);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(Holder<T> test) {
            if (this.holders.contains(test)) return true;
            if (!this.tagKeys.stream().anyMatch(arg_0 -> test.is(arg_0))) return false;
            return true;
        }

        public static <T, U> RegistryConfigDataWrapper<T, U> build(HolderSet.Direct<T> holders, List<TagKey<T>> tagKeys, U configurableData) {
            RegistryConfigDataWrapper<T, U> result = new RegistryConfigDataWrapper<T, U>(holders, tagKeys, configurableData);
            if (holders.size() == 0 && tagKeys.isEmpty()) {
                ItemConfig.noNamePresent(result, "Configuring Registry");
            }
            return result;
        }

        public static <T, U> MapCodec<RegistryConfigDataWrapper<T, U>> mapCodec(Registry<T> registry, Function<Holder<T>, DataResult<Holder<T>>> validator, MapCodec<U> mapCodec) {
            Codec holderCodec = registry.holderByNameCodec().validate(validator);
            Codec tagKeyCodec = Codec.withAlternative((Codec)TagKey.codec((ResourceKey)registry.key()), (Codec)TagKey.hashedCodec((ResourceKey)registry.key()));
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.withAlternative((Codec)holderCodec.listOf(), (Codec)holderCodec, Collections::singletonList).xmap(HolderSet::direct, holders -> holders.stream().toList()).optionalFieldOf("name", (Object)HolderSet.direct((Holder[])new Holder[0])).forGetter(RegistryConfigDataWrapper::holders), (App)Codec.withAlternative((Codec)tagKeyCodec.listOf(), (Codec)tagKeyCodec, Collections::singletonList).optionalFieldOf("tag", Collections.emptyList()).forGetter(RegistryConfigDataWrapper::tagKeys), (App)mapCodec.forGetter(RegistryConfigDataWrapper::configurableData)).apply((Applicative)instance, RegistryConfigDataWrapper::build));
        }

        public static <T, U> StreamCodec<RegistryFriendlyByteBuf, RegistryConfigDataWrapper<T, U>> streamCodec(ResourceKey<? extends Registry<T>> registry, StreamCodec<? super ByteBuf, U> streamCodec) {
            return StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet(registry).map(holders -> (HolderSet.Direct)holders, holders -> holders), RegistryConfigDataWrapper::holders, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.fromCodecWithRegistriesTrusted((Codec)TagKey.codec(registry))), RegistryConfigDataWrapper::tagKeys, streamCodec, RegistryConfigDataWrapper::configurableData, RegistryConfigDataWrapper::build);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RegistryConfigDataWrapper)) {
                return false;
            }
            RegistryConfigDataWrapper that = (RegistryConfigDataWrapper)o;
            return Objects.equals(this.holders, that.holders) && Objects.equals(this.tagKeys, that.tagKeys) && Objects.equals(this.configurableData, that.configurableData);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.holders, this.tagKeys, this.configurableData);
        }

        @Override
        public String toString() {
            return "RegistryConfigDataWrapper{holders=" + String.valueOf(this.holders) + ", tagKeys=" + String.valueOf(this.tagKeys) + ", configurableData=" + String.valueOf(this.configurableData) + "}";
        }
    }

    public record RawConfigDataWrapper<T, U>(List<T> objects, U configurableData) implements ConfigDataWrapper<T, U>
    {
        public static <T, U> MapCodec<RawConfigDataWrapper<T, U>> mapCodec(MapCodec<List<T>> codec, MapCodec<U> mapCodec) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)codec.forGetter(RawConfigDataWrapper::objects), (App)mapCodec.forGetter(RawConfigDataWrapper::configurableData)).apply((Applicative)instance, RawConfigDataWrapper::new));
        }

        public static <T, U> StreamCodec<RegistryFriendlyByteBuf, RawConfigDataWrapper<T, U>> streamCodec(StreamCodec<RegistryFriendlyByteBuf, T> inputCodec, StreamCodec<RegistryFriendlyByteBuf, U> dataCodec) {
            return StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, inputCodec), RawConfigDataWrapper::objects, dataCodec, RawConfigDataWrapper::configurableData, RawConfigDataWrapper::new);
        }

        @Override
        public boolean matches(T test) {
            return this.objects.contains(test);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RawConfigDataWrapper)) {
                return false;
            }
            RawConfigDataWrapper that = (RawConfigDataWrapper)o;
            return Objects.equals(this.objects, that.objects) && Objects.equals(this.configurableData, that.configurableData);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.objects, this.configurableData);
        }

        @Override
        public String toString() {
            return "RawConfigDataWrapper{objects=" + String.valueOf(this.objects) + ", configurableData=" + String.valueOf(this.configurableData) + "}";
        }
    }

    public static interface ConfigDataWrapper<V, U> {
        public boolean matches(V var1);

        default public U match(V test) {
            if (this.matches(test)) {
                return this.configurableData();
            }
            return null;
        }

        public U configurableData();
    }
}

