/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.atlas.combatify.Combatify;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;

public class JSImpl {
    public static final ThreadLocal<Context> CONTEXT = ThreadLocal.withInitial(Context::enter);
    public final Scriptable scope;
    public final String fileName;
    public final String fileData;
    public final Map<String, Function> functions;
    public static final Codec<JSImpl> CODEC = Codec.STRING.validate(str -> str.contains(".") ? DataResult.error(() -> "File loc not expected to contain a file extension!") : DataResult.success((Object)str)).xmap(JSImpl::new, JSImpl::fileName);

    public JSImpl(String fileName) {
        String[] funcs;
        String readFileData;
        this.fileName = fileName;
        this.scope = CONTEXT.get().initStandardObjects();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDirectory().getAbsolutePath() + "/" + fileName + ".js"));
            readFileData = Kit.readReader((Reader)reader);
            String defineVariables = readFileData.substring(0, readFileData.indexOf("function"));
            readFileData = readFileData.substring(readFileData.indexOf("function"));
            if (!defineVariables.isBlank()) {
                CONTEXT.get().evaluateString(this.scope, defineVariables, "", 0, null);
            }
        }
        catch (IOException e) {
            Combatify.JS_LOGGER.error("Error parsing JS File " + fileName + ". Exception: {}", (Throwable)e);
            readFileData = "";
        }
        this.fileData = readFileData;
        this.functions = new Object2ObjectOpenHashMap();
        for (String func : funcs = (String[])Arrays.stream(this.fileData.split("function")).filter(s -> !s.isBlank()).map(str -> "function" + str).toArray(String[]::new)) {
            this.functions.put(func.substring("function ".length(), func.indexOf(41) + 1), CONTEXT.get().compileFunction(this.scope, func, fileName, 0, null));
        }
        List func = this.functions.entrySet().stream().toList();
        for (Map.Entry stringFunctionEntry : func) {
            String key = (String)stringFunctionEntry.getKey();
            this.scope.put(key.substring(0, key.indexOf(40)), this.scope, stringFunctionEntry.getValue());
        }
    }

    public String fileName() {
        return this.fileName;
    }

    public static void initIncluded(String fileName) {
        File included = new File(FabricLoader.getInstance().getConfigDirectory().getAbsolutePath() + "/" + fileName + ".js");
        if (!included.exists()) {
            try {
                included.createNewFile();
                try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName + ".js");){
                    Files.write(included.toPath(), inputStream.readAllBytes(), new OpenOption[0]);
                }
            }
            catch (IOException e) {
                throw new ReportedException(new CrashReport("Failed to clone base JS files!", (Throwable)e));
            }
        }
    }

    public boolean execFunc(String name, Object ... args) {
        try {
            Boolean bool;
            Object ret = this.invokeFunc(name, args);
            return !(ret instanceof Boolean) || (bool = (Boolean)ret) != false;
        }
        catch (Exception e) {
            Combatify.JS_LOGGER.error("Error executing " + name + " function: {}", (Throwable)e);
            return false;
        }
    }

    public double execGetterFunc(double fallback, String name, Object ... args) {
        try {
            double d;
            Object ret = this.invokeFunc(name, args);
            if (!(ret instanceof Number)) {
                d = fallback;
            } else {
                Number number = (Number)ret;
                d = number.doubleValue();
            }
            return d;
        }
        catch (Exception e) {
            Combatify.JS_LOGGER.error("Error executing " + name + " function: {}", (Throwable)e);
            return fallback;
        }
    }

    private Object invokeFunc(String name, Object ... params) {
        String func = this.functions.keySet().stream().filter(function -> function.contains(name)).findFirst().orElseThrow();
        return this.functions.get(func).call(CONTEXT.get(), this.scope, null, params);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JSImpl)) {
            return false;
        }
        JSImpl js = (JSImpl)o;
        return Objects.equals(this.fileName(), js.fileName());
    }

    public int hashCode() {
        return Objects.hash(this.fileName());
    }

    static {
        JSImpl.initIncluded("vanilla_food_impl");
        JSImpl.initIncluded("cts_food_impl");
        JSImpl.initIncluded("combatify_food_impl");
        JSImpl.initIncluded("vanilla_crit_impl");
        JSImpl.initIncluded("cts_crit_impl");
        JSImpl.initIncluded("combatify_crit_impl");
        JSImpl.initIncluded("armor_calculations");
    }
}

