/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config.wrapper;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.wrapper.GenericAPIWrapper;
import net.atlas.combatify.config.wrapper.RandomSourceWrapper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class EntityWrapper<E extends Entity>
implements GenericAPIWrapper<E> {
    public final E value;

    public EntityWrapper(E value) {
        this.value = value;
    }

    public final boolean matchesTag(String tag) {
        return this.value.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)tag)));
    }

    public final String getType() {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.value.getType()).toString();
    }

    public final UUID getUUID() {
        return this.value.getUUID();
    }

    public final boolean isLivingEntity() {
        return this.value instanceof LivingEntity;
    }

    public final RandomSourceWrapper getLevelRandom() {
        return new RandomSourceWrapper(this.value.level().getRandom());
    }

    public final RandomSourceWrapper getRandom() {
        return new RandomSourceWrapper(this.value.getRandom());
    }

    public final void kill() {
        this.value.kill();
    }

    public final void discard() {
        this.value.discard();
    }

    public final Vec2 getRotationVector() {
        return this.value.getRotationVector();
    }

    public final Vec3 getEyePosition() {
        return this.value.getEyePosition();
    }

    public final Vec3 position() {
        return this.value.position();
    }

    public final void teleportTo(double d, double e, double f) {
        this.value.teleportTo(d, e, f);
    }

    public final Vec3 getDeltaMovement() {
        return this.value.getDeltaMovement();
    }

    public final void setDeltaMovement(double d, double e, double f) {
        this.value.setDeltaMovement(d, e, f);
    }

    public final void addDeltaMovement(double d, double e, double f) {
        this.value.addDeltaMovement(new Vec3(d, e, f));
    }

    public final void igniteForSeconds(float seconds) {
        this.value.igniteForSeconds(seconds);
    }

    public final void extinguishFire() {
        this.value.extinguishFire();
    }

    public final void playSound(String soundEvent, float f, float g) {
        this.value.playSound(Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)soundEvent))), f, g);
    }

    public final void playSound(String soundEvent) {
        this.value.playSound(Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)soundEvent))));
    }

    public final float getFallDistance() {
        return ((Entity)this.value).fallDistance;
    }

    public final boolean isFreezing() {
        return this.value.isFreezing();
    }

    public final boolean isSilent() {
        return this.value.isSilent();
    }

    public final void setSilent(boolean bl) {
        this.value.setSilent(bl);
    }

    public final boolean isNoGravity() {
        return this.value.isNoGravity();
    }

    public final void setNoGravity(boolean bl) {
        this.value.setNoGravity(bl);
    }

    public final double getGravity() {
        return this.value.getGravity();
    }

    public final double distanceToSqr(EntityWrapper<?> other) {
        return this.value.distanceToSqr(other.value);
    }

    public final float distanceTo(EntityWrapper<?> other) {
        return this.value.distanceTo(other.value);
    }

    public final double distanceToSqr(double d, double e, double f) {
        return this.value.distanceToSqr(d, e, f);
    }

    public final DamageSource createDamageSourceNoCause(String damageType) {
        return this.value.damageSources().source(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)damageType)));
    }

    public final DamageSource createDamageSourceAsCause(String damageType) {
        return this.value.damageSources().source(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)damageType)), this.value);
    }

    public final boolean hurt(DamageSource damageSource, float amount) {
        return this.value.hurt(damageSource, amount);
    }

    public final boolean onGround() {
        return this.value.onGround();
    }

    public final boolean isInWater() {
        return this.value.isInWater();
    }

    public final boolean isInWaterOrRain() {
        return this.value.isInWaterOrRain();
    }

    public final boolean isPickable() {
        return this.value.isPickable();
    }

    public final boolean isOnFire() {
        return this.value.isOnFire();
    }

    public final boolean isPassenger() {
        return this.value.isPassenger();
    }

    public final boolean isVehicle() {
        return this.value.isVehicle();
    }

    public final boolean dismountsUnderwater() {
        return this.value.dismountsUnderwater();
    }

    public final boolean canControlVehicle() {
        return this.value.canControlVehicle();
    }

    public final void setShiftKeyDown(boolean down) {
        this.value.setShiftKeyDown(down);
    }

    public final boolean isShiftKeyDown() {
        return this.value.isShiftKeyDown();
    }

    public final boolean isSteppingCarefully() {
        return this.value.isSteppingCarefully();
    }

    public final boolean isSuppressingBounce() {
        return this.value.isSuppressingBounce();
    }

    public final boolean isDiscrete() {
        return this.value.isDiscrete();
    }

    public final boolean isDescending() {
        return this.value.isDescending();
    }

    public final boolean isCrouching() {
        return this.value.isCrouching();
    }

    public final boolean isSprinting() {
        return this.value.isSprinting();
    }

    public final void setSprinting(boolean bl) {
        this.value.setSprinting(bl);
    }

    public final boolean isSwimming() {
        return this.value.isSwimming();
    }

    public final boolean isVisuallySwimming() {
        return this.value.isVisuallySwimming();
    }

    public final boolean isVisuallyCrawling() {
        return this.value.isVisuallyCrawling();
    }

    public final void setSwimming(boolean bl) {
        this.value.setSwimming(bl);
    }

    public final boolean hasGlowingTag() {
        return this.value.hasGlowingTag();
    }

    public final void setGlowingTag(boolean bl) {
        this.value.setGlowingTag(bl);
    }

    public final boolean isCurrentlyGlowing() {
        return this.value.isCurrentlyGlowing();
    }

    public final boolean isInvisible() {
        return this.value.isInvisible();
    }

    public final List<EntityWrapper<Entity>> getPassengers() {
        return this.value.getPassengers().stream().map(EntityWrapper::new).toList();
    }

    public final void executeFunction(String command) {
        ResourceLocation function = ResourceLocation.parse((String)command);
        Level level = this.value.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MinecraftServer minecraftServer = serverLevel.getServer();
            ServerFunctionManager serverFunctionManager = minecraftServer.getFunctions();
            Optional optional = serverFunctionManager.get(function);
            if (optional.isPresent()) {
                CommandSourceStack commandSourceStack = minecraftServer.createCommandSourceStack().withPermission(2).withSuppressedOutput().withEntity(this.value).withLevel(serverLevel).withPosition(this.position()).withRotation(this.value.getRotationVector());
                serverFunctionManager.execute((CommandFunction)optional.get(), commandSourceStack);
            } else {
                Combatify.LOGGER.unwrap().error("Running MCFunction in JavaScript failed for non-existent function {}", (Object)function);
            }
        }
    }

    @Override
    public E unwrap() {
        return this.value;
    }
}

