/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.enchantment;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Optional;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.component.CustomEnchantmentEffectComponents;
import net.atlas.combatify.util.blocking.ComponentModifier;
import net.atlas.combatify.util.blocking.effect.PostBlockEffect;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableFloat;

public class CustomEnchantmentHelper {
    public static float getBreach(ItemStack stack, RandomSource randomSource) {
        MutableFloat mutableFloat = new MutableFloat(1.0f);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (holder, i) -> ((Enchantment)holder.value()).getEffects(EnchantmentEffectComponents.ARMOR_EFFECTIVENESS).forEach(enchantmentValueEffectConditionalEffect -> mutableFloat.setValue(((EnchantmentValueEffect)enchantmentValueEffectConditionalEffect.effect()).process(i, randomSource, mutableFloat.floatValue()))));
        return -(mutableFloat.floatValue() - 1.0f);
    }

    public static float getArmorModifier(ServerLevel serverLevel, ItemStack itemStack, Entity entity, DamageSource damageSource) {
        MutableFloat mutableFloat = new MutableFloat(1.0f);
        EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (holder, i) -> ((Enchantment)holder.value()).modifyArmorEffectivness(serverLevel, i, itemStack, entity, damageSource, mutableFloat));
        return -(mutableFloat.floatValue() - 1.0f);
    }

    public static ComponentModifier.DataSet modifyShieldEffectiveness(ItemStack itemStack, RandomSource randomSource, ComponentModifier.DataSet value) {
        MutableFloat base = new MutableFloat(value.addValue());
        MutableFloat factor = new MutableFloat(value.multiplyValue());
        EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (holder, i) -> ((Enchantment)holder.value()).getEffects((DataComponentType)CustomEnchantmentEffectComponents.SHIELD_EFFECTIVENESS.get()).forEach(protectionBaseFactor -> {
            base.setValue(protectionBaseFactor.base().process(i, randomSource, base.floatValue()));
            factor.setValue(protectionBaseFactor.factor().process(i, randomSource, factor.floatValue()));
        }));
        return new ComponentModifier.DataSet(base.floatValue(), factor.floatValue());
    }

    public static void applyPostBlockedEffects(ServerLevel serverLevel, LivingEntity target, LivingEntity attacker, DamageSource damageSource) {
        EnchantmentHelper.runIterationOnEquipment((LivingEntity)attacker, (holder, enchantmentLevel, enchantedItemInUse) -> ((Enchantment)holder.value()).getEffects((DataComponentType)CustomEnchantmentEffectComponents.POST_BLOCK_EFFECTS.get()).forEach(targetedConditionalEffect -> {
            if (targetedConditionalEffect.matches(Enchantment.damageContext((ServerLevel)serverLevel, (int)enchantmentLevel, (Entity)target, (DamageSource)damageSource)) && (targetedConditionalEffect.enchanted() == EnchantmentTarget.ATTACKER || targetedConditionalEffect.enchanted() == EnchantmentTarget.DAMAGING_ENTITY)) {
                LivingEntity applicable = switch (targetedConditionalEffect.affected()) {
                    default -> throw new MatchException(null, null);
                    case EnchantmentTarget.ATTACKER, EnchantmentTarget.DAMAGING_ENTITY -> attacker;
                    case EnchantmentTarget.VICTIM -> target;
                };
                ((PostBlockEffect)targetedConditionalEffect.effect()).doEffect(serverLevel, enchantedItemInUse, target, damageSource, enchantmentLevel, applicable, applicable.position());
            }
        }));
        EnchantmentHelper.runIterationOnEquipment((LivingEntity)target, (holder, enchantmentLevel, enchantedItemInUse) -> ((Enchantment)holder.value()).getEffects((DataComponentType)CustomEnchantmentEffectComponents.POST_BLOCK_EFFECTS.get()).forEach(targetedConditionalEffect -> {
            if (targetedConditionalEffect.matches(Enchantment.damageContext((ServerLevel)serverLevel, (int)enchantmentLevel, (Entity)target, (DamageSource)damageSource)) && targetedConditionalEffect.enchanted() == EnchantmentTarget.VICTIM) {
                LivingEntity applicable = switch (targetedConditionalEffect.affected()) {
                    default -> throw new MatchException(null, null);
                    case EnchantmentTarget.ATTACKER, EnchantmentTarget.DAMAGING_ENTITY -> attacker;
                    case EnchantmentTarget.VICTIM -> target;
                };
                ((PostBlockEffect)targetedConditionalEffect.effect()).doEffect(serverLevel, enchantedItemInUse, attacker, damageSource, enchantmentLevel, applicable, applicable.position());
            }
        }));
    }

    public static float modifyDamage(ServerLevel serverLevel, ItemStack itemStack, Entity entity, DamageSource damageSource, float baseDamage, Operation<Float> original) {
        Optional sensitiveToImpaling;
        if (Combatify.CONFIG.bedrockImpaling().booleanValue() && entity.isInWaterOrRain() && !(sensitiveToImpaling = BuiltInRegistries.ENTITY_TYPE.getTag(EntityTypeTags.SENSITIVE_TO_IMPALING)).isEmpty() && ((HolderSet.Named)sensitiveToImpaling.get()).size() > 0) {
            Entity applicable;
            int i = 0;
            while ((applicable = ((EntityType)((HolderSet.Named)sensitiveToImpaling.get()).get(i).value()).create((Level)serverLevel)) == null && ((HolderSet.Named)sensitiveToImpaling.get()).size() > ++i) {
            }
            float result = Math.max(((Float)original.call(new Object[]{serverLevel, itemStack, entity, damageSource, Float.valueOf(baseDamage)})).floatValue(), ((Float)original.call(new Object[]{serverLevel, itemStack, applicable, damageSource, Float.valueOf(baseDamage)})).floatValue());
            assert (applicable != null);
            applicable.discard();
            return result;
        }
        return ((Float)original.call(new Object[]{serverLevel, itemStack, entity, damageSource, Float.valueOf(baseDamage)})).floatValue();
    }

    public static float modifyShieldDisable(ServerLevel serverLevel, ItemStack itemStack, Entity target, Entity sourceEntity, DamageSource damageSource, float timeSeconds) {
        LivingEntity livingEntity;
        MutableFloat disableTime = new MutableFloat(timeSeconds);
        if (itemStack != null) {
            EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (holder, enchantmentLevel) -> CustomEnchantmentHelper.modifyDisableTime(EnchantmentTarget.ATTACKER, (Holder<Enchantment>)holder, serverLevel, enchantmentLevel, target, damageSource, disableTime));
        } else if (sourceEntity instanceof LivingEntity) {
            livingEntity = (LivingEntity)sourceEntity;
            EnchantmentHelper.runIterationOnEquipment((LivingEntity)livingEntity, (holder, enchantmentLevel, enchantedItemInUse) -> CustomEnchantmentHelper.modifyDisableTime(EnchantmentTarget.ATTACKER, (Holder<Enchantment>)holder, serverLevel, enchantmentLevel, target, damageSource, disableTime));
        }
        if (target instanceof LivingEntity) {
            livingEntity = (LivingEntity)target;
            EnchantmentHelper.runIterationOnEquipment((LivingEntity)livingEntity, (holder, enchantmentLevel, enchantedItemInUse) -> CustomEnchantmentHelper.modifyDisableTime(EnchantmentTarget.VICTIM, (Holder<Enchantment>)holder, serverLevel, enchantmentLevel, target, damageSource, disableTime));
        }
        return disableTime.floatValue();
    }

    public static void modifyDisableTime(EnchantmentTarget enchantmentTarget, Holder<Enchantment> holder, ServerLevel serverLevel, int enchantmentLevel, Entity target, DamageSource damageSource, MutableFloat disableTime) {
        for (TargetedConditionalEffect effect : ((Enchantment)holder.value()).getEffects((DataComponentType)CustomEnchantmentEffectComponents.SHIELD_DISABLE.get())) {
            if (effect.enchanted() != enchantmentTarget || !effect.matches(Enchantment.damageContext((ServerLevel)serverLevel, (int)enchantmentLevel, (Entity)target, (DamageSource)damageSource))) continue;
            disableTime.setValue(((EnchantmentValueEffect)effect.effect()).process(enchantmentLevel, target.getRandom(), disableTime.floatValue()));
        }
    }
}

